REM: Include file for Hex Editor v7.0a PD 2005.

' initialize all default variables as integer.
DEFINT A-Z

' load all arrays during runtime.
REM $DYNAMIC

' get include files.
REM $INCLUDE: 'bpb.bi'
REM $INCLUDE: 'dta.bi'
REM $INCLUDE: 'qbx.bi'
REM $INCLUDE: 'wdta.bi'

' declare multiple file structure.
TYPE FileType
 AsciiValue AS INTEGER
 ASCIIZ AS STRING*260
 Buffer AS STRING*1
 CopyPositionEnd AS DOUBLE
 CopyPositionPivot AS DOUBLE
 CopyPositionStart AS DOUBLE
 CurrentMarker AS INTEGER
 CurrentUndo AS INTEGER
 CurrentWindow2 AS INTEGER
 Filename AS STRING*12
 FileAttribute AS INTEGER
 FileByte AS STRING*1
 FileLength AS DOUBLE
 FilePage AS DOUBLE
 FilePosition AS DOUBLE
 Handle AS INTEGER
 MarkerCount AS INTEGER
 Netpath AS STRING*260
 PageColumn AS DOUBLE
 PageRow AS DOUBLE
 ShortFilename AS STRING*260
END TYPE

' declare dos filename structure.
TYPE DosFileType
 Name AS STRING*12 ' 8.3 DOS
END TYPE

' declare windows filename structure.
TYPE WinFileType
 Name AS STRING*260 ' ASCIIZ
END TYPE

' declare marker filename structure.
TYPE MarkerFileType
 Markers1(9) AS DOUBLE
END TYPE

' declare undo filename structure
TYPE UndoFileType
 UndoByte1(9) AS INTEGER
 UndoPosition1(9) AS DOUBLE
END TYPE

' declare undo structure.
COMMON SHARED UndoFile AS UndoFileType

' declare undo variables.
COMMON SHARED CurrentUndo AS INTEGER, UndoToggle AS INTEGER

' declare marker structure.
COMMON SHARED MarkerFile AS MarkerFileType

' declare marker variables.
COMMON SHARED CurrentMarker AS INTEGER, NewMarker AS INTEGER
COMMON SHARED MarkerCount AS INTEGER, MarkerPosition AS INTEGER

' declare menu area storage arrays.
COMMON SHARED Area1() AS INTEGER, Area2() AS INTEGER

' declare ascii character variables.
COMMON SHARED Hline AS INTEGER, Vline AS INTEGER
COMMON SHARED ULcorner AS INTEGER, URcorner AS INTEGER
COMMON SHARED LLcorner AS INTEGER, LRcorner AS INTEGER

' declare temporary file position variables.
COMMON SHARED FileDisplay AS INTEGER, FileDisplay2 AS INTEGER
COMMON SHARED Low AS DOUBLE, High AS DOUBLE, HeapSortOff AS INTEGER
COMMON SHARED TempPosition AS DOUBLE, TempPosition1 AS DOUBLE
COMMON SHARED TempPosition2 AS DOUBLE, TempPosition3 AS DOUBLE
COMMON SHARED TempFiles() AS STRING

' declare common program variables.
COMMON SHARED AsciiValue AS INTEGER, AsciiValue2 AS INTEGER
COMMON SHARED ASCIIValue3 AS DOUBLE, HexValue AS DOUBLE
COMMON SHARED CurrentWindow AS INTEGER, CurrentWindow2 AS INTEGER
COMMON SHARED PageColumn AS DOUBLE, PageRow AS DOUBLE
COMMON SHARED ScreenDrawn AS INTEGER, ScreenRow AS INTEGER
COMMON SHARED StatusMessage AS STRING, SupportedCall AS INTEGER

' declare common validity check variables.
COMMON SHARED AllowWildCard AS INTEGER
COMMON SHARED ValidFunction AS INTEGER, ValidASCIIValue AS INTEGER
COMMON SHARED ValidString AS INTEGER, ValidHexValue AS INTEGER
COMMON SHARED ValidByteString AS INTEGER, NumBytes AS INTEGER

' declare filename/file position variables.
COMMON SHARED BlockByte AS STRING*32767, Column AS DOUBLE
COMMON SHARED Column2 AS DOUBLE, DumpFile AS STRING, ExcludeFile AS STRING
COMMON SHARED FileDumped AS INTEGER, Filename AS STRING
COMMON SHARED FileByte AS STRING*1, FileBytePosition AS DOUBLE
COMMON SHARED FileLength AS DOUBLE, FilePage AS DOUBLE
COMMON SHARED FilePosition AS DOUBLE, FilePosition2 AS DOUBLE
COMMON SHARED FirstByte AS DOUBLE, FilePage2 AS DOUBLE
COMMON SHARED LastByte AS DOUBLE, LastPage AS DOUBLE
COMMON SHARED NewByte AS DOUBLE, NextByte AS DOUBLE
COMMON SHARED NextLine AS DOUBLE, NextPage AS DOUBLE
COMMON SHARED NewPosition AS DOUBLE, NewPosition2 AS DOUBLE
COMMON SHARED PageColumn2 AS DOUBLE, PageRow2 AS DOUBLE
COMMON SHARED SeekPosition AS DOUBLE, SeekPosition2 AS DOUBLE
COMMON SHARED ShortFilename AS STRING, StorePosition AS DOUBLE

' declare file search position variables.
COMMON SHARED SearchBytePosition AS DOUBLE, StoreNumBytes AS INTEGER
COMMON SHARED StoreSearchPosition AS DOUBLE, StoreSearchString AS STRING

' declare all long filename common variables.
COMMON SHARED ASCIIZ AS STRING*260, ASCIIZ2 AS STRING*260
COMMON SHARED Buffer AS STRING*1, BPBfile AS BPBtype
COMMON SHARED ConfigFile AS STRING, BASIC.DTA.OFF AS INTEGER
COMMON SHARED BASIC.DTA.SEG AS INTEGER, DTAfile AS DTAtype
COMMON SHARED ErrorTrap AS INTEGER, FileAttribute AS INTEGER
COMMON SHARED FileDateTime AS STRING, FileSwitch AS INTEGER
COMMON SHARED FileSize AS DOUBLE, FileSizeType AS INTEGER
COMMON SHARED Handle AS INTEGER, QuietSwitch AS INTEGER
COMMON SHARED Quote AS STRING, Windows.Detected AS INTEGER
COMMON SHARED Wfile.Handle AS INTEGER, WDTAfile AS WDTAtype
COMMON SHARED Directory.ASCIIZ AS STRING*260

' declare all common mouse variables.
COMMON SHARED Mouse.Present AS INTEGER, Mouse.Button1 AS INTEGER
COMMON SHARED Mouse.Button2 AS INTEGER, Mouse.Button3 AS INTEGER
COMMON SHARED Mouse.Row AS INTEGER, Mouse.Column AS INTEGER
COMMON SHARED Old.Mouse.Row AS INTEGER, Old.Mouse.Column AS INTEGER
COMMON SHARED Mouse.X AS INTEGER, Mouse.Y AS INTEGER, Show.Mouse AS INTEGER

' common default left click mouse variables.
COMMON SHARED Mouse.ButtonX AS INTEGER
COMMON SHARED Mouse.RowX AS INTEGER, Mouse.ColumnX AS INTEGER
COMMON SHARED MouseTime AS SINGLE, Time1 AS SINGLE

' common left click and drag mouse variables.
COMMON SHARED Mouse.Button1.Row AS INTEGER, Mouse.Button1.Column AS INTEGER
COMMON SHARED Mouse.Button1.X AS INTEGER, Mouse.Button1.Y AS INTEGER
COMMON SHARED Mouse.Drag AS INTEGER, Reset1 AS INTEGER

' declare filename variables for file menu box.
COMMON SHARED AmbiguateSwitch AS INTEGER, Attribute AS INTEGER
COMMON SHARED ASCIIZ3 AS STRING*260, Current.Drive AS INTEGER
COMMON SHARED Drive.Box.Line AS INTEGER, Default.Drive AS INTEGER
COMMON SHARED Last.Drive AS INTEGER, Num.Dirs AS INTEGER
COMMON SHARED Num.Files AS INTEGER, Keys() AS INTEGER

' declare filename sort variables for file menu box.
COMMON SHARED FileSort AS INTEGER, DirSort AS INTEGER, Millisecond AS INTEGER

' declare requirement filename attribute bit variables for file menu box.
COMMON SHARED RequireReadOnly AS INTEGER, RequireHidden AS INTEGER
COMMON SHARED RequireSystem AS INTEGER, RequireArchive AS INTEGER

' declare requirement directory attribute bit variables for file menu box.
COMMON SHARED RequireDirReadOnly AS INTEGER, RequireDirHidden AS INTEGER
COMMON SHARED RequireDirSystem AS INTEGER, RequireDirArchive AS INTEGER

' declare structures for file menu box.
COMMON SHARED DosFileStruc AS DosFileType, WinFileStruc AS WinFileType

' declare menu screen location offsets for file menu box.
COMMON SHARED Xcoor AS INTEGER, Ycoor AS INTEGER

' declare menu variables for DropDownMenu.
COMMON SHARED CurrentMenu AS INTEGER, CurrentMenuSelection AS INTEGER

' declare variables for copy/paste.
COMMON SHARED CopyByte AS STRING*1, CopyStart AS DOUBLE
COMMON SHARED CopyPositionEnd AS DOUBLE, CopyPositionPivot AS DOUBLE
COMMON SHARED CopyPositionStart AS DOUBLE

' declare structure for multiple files.
COMMON SHARED File() AS FileType

' declare multiple file variables.
COMMON SHARED CurrentFile AS INTEGER, NumberFiles AS INTEGER

' declare temp file share variables.
COMMON SHARED Process.Number AS INTEGER

' declare interrupt structures.
COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX
COMMON SHARED InregsX2 AS RegtypeX

' declare color variables.
COMMON SHARED Black AS INTEGER, Blue AS INTEGER, Cyan AS INTEGER
COMMON SHARED Green AS INTEGER, Magenta AS INTEGER, Plain AS INTEGER
COMMON SHARED Red AS INTEGER, White AS INTEGER, Yellow AS INTEGER

' declare color storage variables.
COMMON SHARED Background.Color AS INTEGER, Foreground.Color AS INTEGER
COMMON SHARED Video.Page AS INTEGER

' declare network path variables.
COMMON SHARED CurrentNetPath AS STRING*260, DefaultNetPath AS STRING*260

' declare author constants.
CONST Author="Erik Jon Oredson AS. CSci"
CONST Email="eoredson@yahoo.com"
CONST Urls="www.filegate.net, www.simtel.net"

' declare constants.
CONST Nul=""
CONST False=0
CONST SFalse=0!
CONST DFalse=0#
CONST True=-1
CONST Version="v7.0a"
CONST Release="r1.0a"
CONST Publish="04/10/2005"
CONST Status="Public Domain"
CONST Program="Hex Editor"

' declare bit constants.
CONST ReadOnlyBit=1
CONST HiddenBit=2
CONST SystemBit=4
CONST ArchiveBit=32

' declare mouse function constants.
CONST CheckMouse=0
CONST ShowMouse=1
CONST HideMouse=2
CONST MovePosition=4
CONST Position=3
CONST Button=5

' declare functions.
DECLARE FUNCTION Conanicalize$(V$)
DECLARE FUNCTION ReleaseTime()
DECLARE FUNCTION TestFile(V$)
DECLARE FUNCTION TimeElapsed(V1!,V2!)
DECLARE FUNCTION TimeNow!()
DECLARE FUNCTION TrimSpaces$(V$)

' declare record structure functions.
DECLARE FUNCTION Directories$(V%)
DECLARE FUNCTION Filenames$(V%)

' declare marker record structure function.
DECLARE FUNCTION Markers#(V%)

' declare undo record structure functions.
DECLARE FUNCTION UndoByte%(V%)
DECLARE FUNCTION UndoPosition#(V%)

' declare test functions.
DECLARE FUNCTION TestMouse()
DECLARE FUNCTION TestWindows()

' declare DTA subroutines.
DECLARE SUB GetDateTime()
DECLARE SUB GetFileSize()
DECLARE SUB GetFileAttribute()

' declare DTA function.
DECLARE FUNCTION GetAttributeString$()

' declare specialized DIR$ function.
DECLARE FUNCTION DIRx$(F$)

' declare calculation subroutines.
DECLARE SUB CalculatePosition1()
DECLARE SUB CalculatePosition2()
DECLARE SUB FormatPosition1()

' declare calculation functions.
DECLARE FUNCTION CalculateColumn()
DECLARE FUNCTION CalculateColumn2()
DECLARE FUNCTION CalculatePosition3#()
DECLARE FUNCTION CalculatePosition4#()
DECLARE FUNCTION DumpLineRange$()

' declare subroutines.
DECLARE SUB CheckExcluded(V1$,V2$,M%)
DECLARE SUB Clipboard2(V%)
DECLARE SUB Colorf(V%)
DECLARE SUB Colorf2(V1%,V2%)
DECLARE SUB Deconcatenate(N$,V$,V%)
DECLARE SUB DisplayANSIChart()
DECLARE SUB DisplayBootUsage()
DECLARE SUB DisplayHEXChart()
DECLARE SUB DisplayScreen()
DECLARE SUB DisplayScreen2()
DECLARE SUB DumpFileSub()
DECLARE SUB DumpScreenSub()
DECLARE SUB DOSCommand(V$)
DECLARE SUB DropDownMenu()
DECLARE SUB ExcludeList(Y1%,Y2$)
DECLARE SUB HelpScreen()
DECLARE SUB FormatX(V$,V#,V%)
DECLARE SUB InitPasteFiles(V%)
DECLARE SUB InitVars()
DECLARE SUB Locatef(V1%,V2%,V3%)
DECLARE SUB Marker(V%)
DECLARE SUB Menu(V1$,V2$,V3$,V4$,V5$)
DECLARE SUB MoveMenu()
DECLARE SUB MultiFileFunction(V%)
DECLARE SUB OpenCopyFiles()
DECLARE SUB OpenMarkerFile(V%)
DECLARE SUB OpenPasteFiles(V%)
DECLARE SUB OpenUndoFile(V%)
DECLARE SUB OverridePrompt()
DECLARE SUB Printf(V$)
DECLARE SUB PrintFileSub()
DECLARE SUB PrintHelpScreens()
DECLARE SUB PrintScreenSub()
DECLARE SUB ReadCommandLine(V$)
DECLARE SUB ReadConfigFile(V$)
DECLARE SUB SearchFile(V1%,V2%)
DECLARE SUB ViewFiles(V%)
DECLARE SUB Window2DrawSub()

' declare mouse subroutines.
DECLARE SUB HMouse() ' hide mouse
DECLARE SUB SMouse() ' show mouse
DECLARE SUB MouseButton1Drag(V%)
DECLARE SUB MouseDriver()
DECLARE SUB MouseDriver1()
DECLARE SUB MouseDriver2()
DECLARE SUB MouseFunction(V1%,V2%)
DECLARE SUB MouseFunction2(V1%,V2%)

' declare small replacement subroutines.
DECLARE SUB LseekFile()
DECLARE SUB ReadFile()
DECLARE SUB Writefile()
DECLARE SUB LockedFile()
DECLARE SUB LocateCursor()
DECLARE SUB LocateCursor2()
DECLARE SUB LocateHilightCursor()
DECLARE SUB BytePrint()
DECLARE SUB DisplayPosition()
DECLARE SUB ClearStatus()
DECLARE SUB DisplayFilename()
DECLARE SUB DisplayFileTitle()
DECLARE SUB DisplayPageByte()
DECLARE SUB ResetHilightBytes()
DECLARE SUB ResetBytes()
DECLARE SUB RestoreHilightBytes()
DECLARE SUB ResetByte()
DECLARE SUB ClearPageByte()
DECLARE SUB ClearHilightByte()
DECLARE SUB DisplayHilightByte()
DECLARE SUB DisplayStatus1()
DECLARE SUB DisplayStatus2()
DECLARE SUB DisplayStatusLine()
DECLARE SUB PromptKey()
DECLARE SUB PromptEscKey()
DECLARE SUB DisplayHexPage()
DECLARE SUB RedrawRightWindow()
DECLARE SUB RedrawWindow1()
DECLARE SUB RedrawWindow2()
DECLARE SUB PressKey()
DECLARE SUB CheckASCIIValue(S$)
DECLARE SUB CheckString(S$)
DECLARE SUB CheckHexValue(S$)
DECLARE SUB FormatPosition2(V%)
DECLARE SUB AsciiToHex1(S$)
DECLARE SUB AsciiToHex2(S$)
DECLARE SUB CheckAsciiBytes(S$)
DECLARE SUB CheckHexBytes(S$)

'end
