REM Program: Hex Editor v7.0a, Module 1 of 5, PD 2005.
REM Author: Erik Jon Oredson AS. Csci
REM Release: 04/10/2005.
REM Status: Public Domain.
REM Email: eoredson@yahoo.com
REM Urls: www.filegate.net www.simtel.net

' get include file.
REM $INCLUDE: 'hexedit.inc'

' declare error trap.
ON ERROR GOTO Error.Routine

' increase stack for recursion.
STACK STACK

' init variables.
CALL InitVars

' store default server name.
DefaultNetPath = Nul
InregsX.AX = &H5E00
InregsX.DS = VARSEG(ASCIIZ3)
InregsX.DX = VARPTR(ASCIIZ3)
CALL InterruptX(&H21, InregsX, OutregsX)
' check error flag.
IF (OutregsX.Flags AND &H1) = &H0 THEN
   ' read CH
   VarS = (OutregsX.CX AND &HFF00) / 256
   IF VarS > 0 THEN ' valid name.
      DefaultNetPath = ASCIIZ3
      Imbedded = INSTR(DefaultNetPath, CHR$(0))
      IF Imbedded THEN
         DefaultNetPath = LEFT$(DefaultNetPath, Imbedded - 1)
      END IF
   END IF
END IF

' get current drive.
InregsX.AX = &H1900
CALL InterruptX(&H21, InregsX, OutregsX)
Drive.Number = OutregsX.AX AND &HFF ' 0=a, 1=b, ..

' check windows dos.
IF Windows.Detected THEN
   ' get current directory.
   InregsX.AX = &H7147
   InregsX.DX = Drive.Number + 1
   InregsX.DS = VARSEG(ASCIIZ3)
   InregsX.SI = VARPTR(ASCIIZ3)
   CALL InterruptX(&H21, InregsX, OutregsX)
ELSE
   ' get current directory.
   InregsX.AX = &H4700
   InregsX.DX = Drive.Number + 1
   InregsX.DS = VARSEG(ASCIIZ3)
   InregsX.SI = VARPTR(ASCIIZ3)
   CALL InterruptX(&H21, InregsX, OutregsX)
END IF
Directory.ASCIIZ = ASCIIZ3
Directory$ = ASCIIZ3
Imbedded = INSTR(Directory$, CHR$(0))
IF Imbedded THEN
   Directory$ = LEFT$(ASCIIZ3, Imbedded - 1)
END IF

' init undo file.
CALL OpenUndoFile(VarQ)

' check bad filename.
If VarQ Then
   GOTO Error.Exit
End if

' init marker file.
CALL OpenMarkerFile(VarQ)

' check bad filename.
IF VarQ THEN
   GOTO Error.Exit
END IF

' init paste file.
CALL InitializePaste(VarQ)

' check bad filename.
IF VarQ THEN
   GOTO Error.Exit
END IF

' dimension multiple files array structure.
REDIM File(9) AS FileType
REDIM TempFiles(9) AS STRING

' dimension menu area arrays.
REDIM Area1(24, 44) AS INTEGER
REDIM Area2(24, 44) AS INTEGER

' read config file.
CALL ReadConfigFile(FileName)
IsMenuFile = False

' check startup config edit file.
IF Filename <> "" THEN
   CommandLine$ = Filename
   GOTO StartFile
END IF

' check command line.
SELECT CASE COMMAND$
CASE "/?", "-?"
   GOTO BootUsage
END SELECT

' read command line.
CALL ReadCommandLine(CommandLine$)

' check command line filename.
IF CommandLine$ <> Nul THEN
   ' store command line.
   GOTO StartFile
END IF

' filename entry starts here.
BeginFile:
CALL SMouse

' call file menu box.
CALL Menu(NetPath$, Drive$, Directory$, FileSpec1$, FileSpec2$)
IsMenuFile = True
CLOSE #2, #3

' check filename.
IF FileSpec2$ = Nul THEN
   ' verify a file open already.
   IF NumberFiles >=1 THEN
      GOTO TopProgram
   END IF
   ' exit program.
   GOTO BootUsage
END IF

' get filename from menu box.
IF NetPath$ = Nul THEN
   IF Directory$ = Nul THEN
      Filename = Drive$ + ":\" + FileSpec2$
   ELSE
      Filename = Drive$ + ":\" + Directory$ + "\" + FileSpec2$
   END IF
ELSE
   IF Directory$ = Nul THEN
      Filename = NetPath$ + "\" + FileSpec2$
   ELSE
      Filename = NetPath$ + "\" + Directory$ + "\" + FileSpec2$
   END IF
END IF
CommandLine$ = Filename

' filename entry loop starts here.
StartFile:
CALL SMouse

' start filename entry loop.
DO
   ' check filenames
   IF CommandLine$ = Nul THEN
      EXIT DO
   END IF

   ' get filename from command line.
   CommandLine$ = RTRIM$(CommandLine$)
   CommandLine$ = LTRIM$(CommandLine$)

   ' check menu filename returned.
   IF IsMenuFile THEN
      Filename = CommandLine$
      CommandLine$ = Nul
   END IF

   ' parse command line
   IF IsMenuFile = False THEN
      IF LEFT$(CommandLine$, 1) = Quote THEN
         Var = INSTR(2, CommandLine$, Quote)
         IF Var = False THEN
            GOTO BeginFile
         END IF
         Filename = LEFT$(CommandLine$, Var - 1)
         Filename = MID$(Filename, 2)
         IF Filename = Nul THEN
            GOTO BeginFile
         END IF
         CommandLine$ = MID$(CommandLine$, Var + 1)
      ELSE
         Var = INSTR(CommandLine$, " ")
         IF Var THEN
            Filename = LEFT$(CommandLine$, Var - 1)
            CommandLine$ = MID$(CommandLine$, Var + 1)
         ELSE
            Filename = CommandLine$
            CommandLine$ = Nul
         END IF
      END IF
   END IF

   ' trim filename.
   Filename = RTRIM$(Filename)
   Filename = LTRIM$(Filename)

   ' check long filename in quotes.
   IF LEFT$(Filename, 1) = Quote THEN
      IF RIGHT$(Filename, 1) = Quote THEN
         Filename = MID$(Filename, 2)
         Filename = LEFT$(Filename, LEN(Filename) - 1)
      END IF
   END IF

   ' check max files.
   IF NumberFiles = 9 THEN
      EXIT DO
   END IF

   ' check filelist character.
   Var3$ = Filename
   DO
      ' check multiple filenames.
      Var3 = INSTR(Var3$, CHR$(13))
      IF Var3 THEN
         Var$ = LEFT$(Var3$, Var3 - 1)
         Var3$ = MID$(Var3$, Var3 + 1)
      ELSE
         IF LEN(Var3$) THEN
            Var$ = Var3$
            Var3$ = Nul
         ELSE
            EXIT DO
         END IF
      END IF
      IF LEFT$(Var$, 1) = "@" THEN
         Var4$ = MID$(Var$, 2)
         CLOSE #1
         IF DIRx$(Var4$) <> Nul THEN
            ErrorTrap = False
            OPEN Var4$ FOR INPUT AS #1
            IF ErrorTrap = False THEN
               DO UNTIL EOF(1)
                  LINE INPUT #1, Var$
                  Var$ = RTRIM$(Var$)
                  Var$ = LTRIM$(Var$)
                  IF LEN(Var$) THEN
                     ' check max files.
                     IF NumberFiles = 9 THEN
                        EXIT DO
                     END IF
                     GOSUB LoadMultipleFile
                  END IF
               LOOP
            END IF
         END IF
      ELSE
         GOSUB LoadMultipleFile
      END IF
   LOOP
LOOP

' check files loaded.
IF NumberFiles = False THEN
   GOTO BeginFile
END IF

' initialize file buffer.
IF FileLength > False THEN
   SeekPosition = 1
   Call lseekfile
   Call readfile
   FileByte = Buffer
   AsciiValue = ASC(FileByte)
END IF

' main program loop starts here.
TopProgram:
CALL SMouse

' reset mouse activity.
IF Mouse.Present THEN
   CALL ClearMouse
END IF

' setup editing screen.
GOSUB RedrawScreen
CALL SMouse

' keyboard/mouse input loop starts here.
StartLoop:

' keyboard/mouse input loop.
DO
   ' check for keypress or mouse activity.
   CharInput$ = Nul
   DO
      ' store keyboard buffer.
      CharInput$ = INKEY$
      IF LEN(CharInput$) THEN
         EXIT DO
      END IF

      ' call mouse subroutine.
      CALL MouseDriver2

      ' check left mouse button release.
      IF Mouse.ButtonX THEN
         ' store mouse position.
         Mouse.Row = Mouse.RowX
         Mouse.Column = Mouse.ColumnX
         ' process mouse row/column.
         IF Mouse.Drag = False THEN
            GOSUB MouseButton1
         END IF
         ' init mouse drag pivot byte.
         CopyStart = False
         Time1 = SFalse
         IF Mouse.Row > 3 AND Mouse.Row < 20 THEN
            IF Mouse.Column >= 6 AND Mouse.Column <= 49 THEN
               CopyStart = FilePosition
            END IF
         END IF
      ELSE
         ' check left mouse button drag.
         IF Mouse.Button1 = 2 THEN
            IF Mouse.Row OR Mouse.Column THEN
               Time1 = SFalse
               Mouse.Drag = True
               CALL MouseButton1Drag(0)
            END IF
         ELSE
            ' check left mouse button drag/scroll up.
            IF Mouse.Button1 = 3 THEN
               IF Mouse.Row OR Mouse.Column THEN
                  Mouse.Drag = True
                  CALL MouseButton1Drag(9)
               END IF
            ELSE
               ' check left mouse button drag/scroll down.
               IF Mouse.Button1 = 4 THEN
                  IF Mouse.Row OR Mouse.Column THEN
                     Mouse.Drag = True
                     CALL MouseButton1Drag(10)
                  END IF
               ELSE
                  ' check right/middle mouse button.
                  IF Mouse.Button2 OR Mouse.Button3 THEN
                     GOSUB MouseButton2
                  ELSE
                     ' check mouse position for mouseover.
                     IF Mouse.Row OR Mouse.Column THEN
                        Mouse.Drag = False
                        GOSUB MoveMouse
                     END IF
                  END IF
               END IF
            END IF
         END IF
      END IF

      ' release time slice.
      ' (speeds up mouse in windows).
      Var = ReleaseTime
   LOOP

   ' reset mouse activity.
   CALL HMouse
   Call locatecursor2

   ' set to keyboard port segment.
   DEF SEG = &H40

   ' get shift state from keyboard address.
   ShiftFlag = PEEK(&H17)

   ' reset to basic segment.
   DEF SEG

   ' store shift state.
   LeftShift = ShiftFlag AND 1 ' left shift.
   RightShift = ShiftFlag AND 2 ' right shift.

   ' check shift flags.
   IF LeftShift OR RightShift THEN
      SELECT CASE LEN(CharInput$)
      CASE 1
         SELECT CASE ASC(CharInput$)
         CASE 33 ' ! = display page/row/column.
            GOSUB DisplayData
         CASE 34 ' " = display file path.
            GOSUB DisplayPath
         CASE 63 ' ? = display filelength\undos.
            GOSUB DisplayInfo
         CASE 123 ' { = display paste entries.
            GOSUB DisplayPasteUndos
         CASE 126 ' ~ = display last page\markers.
            GOSUB DisplayLengths
         CASE 43 ' + = list range of markers.
            IF FileLength THEN
               CALL MultiFileFunction(2)
               CALL Marker(1)
               IF ValidFunction THEN
                  COLORf Plain
                  ScreenDrawn = True
                  CALL DisplayScreen
                  GOSUB RestoreCurrentFile
                  GOSUB RedrawScreen2
                  Call restorehilightbytes
               END IF
            END IF
         ' remaining byte hilighting functions.
         CASE 52 ' Shift-Left
            IF FileLength THEN
               CALL MouseButton1Drag(1)
            END IF
         CASE 54 ' Shift-Right
            IF FileLength THEN
               CALL MouseButton1Drag(2)
            END IF
         CASE 56 ' Shift-Up
            IF FileLength THEN
               CALL MouseButton1Drag(3)
            END IF
         CASE 50 ' Shift-Down
            IF FileLength THEN
               CALL MouseButton1Drag(4)
            END IF
         CASE 57 ' Shift-PageUp
            IF FileLength THEN
               CALL MouseButton1Drag(5)
            END IF
         CASE 51 ' Shift-PageDown
            IF FileLength THEN
               CALL MouseButton1Drag(6)
            END IF
         CASE 49 ' Shift-End
            IF FileLength THEN
               CALL MouseButton1Drag(7)
            END IF
         CASE 55 ' Shift-Home
            IF FileLength THEN
               CALL MouseButton1Drag(8)
            END IF
         CASE ELSE ' Unknown key.
            GOSUB HelpLine
         END SELECT
      CASE 2
         SELECT CASE ASC(RIGHT$(CharInput$, 1))
         ' byte hlighting functions.
         CASE 75 ' Shift-Left
            IF FileLength THEN
               CALL MouseButton1Drag(1)
            END IF
         CASE 77 ' Shift-Right
            IF FileLength THEN
               CALL MouseButton1Drag(2)
            END IF
         CASE 72 ' Shift-Up
            IF FileLength THEN
               CALL MouseButton1Drag(3)
            END IF
         CASE 80 ' Shift-Down
            IF FileLength THEN
               CALL MouseButton1Drag(4)
            END IF
         CASE 73 ' Shift-PageUp
            IF FileLength THEN
               CALL MouseButton1Drag(5)
            END IF
         CASE 81 ' Shift-PageDown
            IF FileLength THEN
               CALL MouseButton1Drag(6)
            END IF
         CASE 79 ' Shift-End
            IF FileLength THEN
               CALL MouseButton1Drag(7)
            END IF
         CASE 71 ' Shift-Home
            IF FileLength THEN
               CALL MouseButton1Drag(8)
            END IF
         CASE ELSE ' Unknown key.
            GOSUB HelpLine
         END SELECT
      END SELECT
   ELSE
      ' parse the key.
      SELECT CASE LEN(CharInput$)
      CASE 1 ' single ascii key.
         SELECT CASE ASC(CharInput$)
         CASE 9 ' Tab = Toggle window.
            IF FileLength THEN
               GOSUB TabWindow
            END IF
         CASE 13 ' Enter = Change byte value.
            IF FileLength THEN
               GOSUB ChangeHexValue
            END IF
         CASE 27 ' Escape = Start drop down menu.
            IF CurrentMenu <> 1 THEN
               ' remove hilight menu tab.
               COLORf2 White, 0
               CALL DisplayTab(CurrentMenu)
            END IF
            CurrentMenu = 1
            CurrentMenuSelection = 1
            GOTO Menu2
         CASE 59 ' ; = display hilight range.
            GOSUB DisplayCopy
         CASE 49 ' 1 = Add marker.
            IF FileLength THEN
               CALL Marker(2)
            END IF
         CASE 50 ' 2 = Add marker value.
            IF FileLength THEN
               CALL Marker(3)
            END IF
         CASE 51 ' 3 = delete marker.
            IF FileLength THEN
               CALL Marker(4)
            END IF
         CASE 52 ' 4 = delete specified marker.
            IF FileLength THEN
               CALL Marker(5)
            END IF
         CASE 53 ' 5 = jump to previous marker.
            IF FileLength THEN
               CALL Marker(6)
            END IF
         CASE 54 ' 6 = jump to current marker.
            IF FileLength THEN
               CALL Marker(7)
            END IF
         CASE 55 ' 7 = Jump to next marker.
            IF FileLength THEN
               CALL Marker(8)
            END IF
         CASE 56 ' 8 = Jump to specified marker.
            IF FileLength THEN
               CALL Marker(9)
            END IF
         CASE 57 ' 9 = List all markers.
            IF FileLength THEN
               CALL MultiFileFunction(2)
               CALL Marker(10)
               COLORf Plain
               ScreenDrawn = True
               CALL DisplayScreen
               GOSUB RestoreCurrentFile
               GOSUB RedrawScreen2
               Call restorehilightbytes
            END IF
         CASE 48 ' 0 = List specified markers.
            IF FileLength THEN
               CALL Marker(11)
            END IF
         CASE 45 ' - = List marker of value.
            IF FileLength THEN
               CALL MultiFileFunction(2)
               CALL Marker(12)
               COLORf Plain
               ScreenDrawn = True
               CALL DisplayScreen
               GOSUB RestoreCurrentFile
               GOSUB RedrawScreen2
               Call restorehilightbytes
            END IF
         CASE 61 ' = = Delete range of markers.
            IF FileLength THEN
               CALL Marker(13)
            END IF
         CASE 91 ' [ = Delete all markers.
            IF FileLength THEN
               CALL Marker(14)
            END IF
         CASE 93 ' ] = Delete markers of specified values.
            IF FileLength THEN
               CALL Marker(15)
            END IF
         CASE 3 ' Control-C = Copy paste area.
            IF FileLength THEN
               CALL Clipboard2(1)
            END IF
         CASE 22 ' Control-V = Paste area.
            IF FileLength THEN
               CALL Clipboard2(2)
            END IF
         CASE 24 ' Control-X = Undo previous paste.
            IF FileLength THEN
               CALL Clipboard2(3)
            END IF
         CASE 26 ' Control-Z = Undo all pastes.
            IF FileLength THEN
               CALL Clipboard2(4)
            END IF
         CASE ELSE ' Unknown key.
            GOSUB HelpLine
         END SELECT
      CASE 2 ' extended ascii key.
         SELECT CASE ASC(RIGHT$(CharInput$, 1))
         CASE 0 ' Control-Break = Nul activity.
            ' Note: Ctrl-Break clears keyboard buffer,
            '   places word 0000h in buffer, invokes INT 1B,
            '   and sets flag 80h at memory 0040h:0071h
            BEEP
         CASE 15 ' Shift-tab = Switch windows.
            IF FileLength THEN
               GOSUB TabWindow
            END IF
         CASE 30 ' Alt-A = Append multiple bytes.
            IF FileLength THEN
               GOSUB AppendByte
            END IF
         CASE 48 ' Alt-B = Append multiple null bytes.
            IF FileLength THEN
               GOSUB AppendNullBytes
            END IF
         CASE 46 ' Alt-C = ANSI Chart.
            GOSUB ANSIChart
         CASE 32 ' Alt-D = HEX screen dump.
            IF FileLength THEN
               GOSUB DumpScreen
            END IF
         CASE 18 ' Alt-E = HEX file dump.
            IF FileLength THEN
               GOSUB DumpHEXFile
            END IF
         CASE 33 ' Alt-F = Start drop down menu.
            IF CurrentMenu <> 1 THEN
               ' remove hilight menu tab.
               COLORf2 White, 0
               CALL DisplayTab(CurrentMenu)
            END IF
            CurrentMenu = 1
            CurrentMenuSelection = 1
            GOTO Menu2
         CASE 34 ' Alt-G = Append multiple specified bytes.
            IF FileLength THEN
               GOSUB AppendAnyByte
            END IF
         CASE 35 ' Alt-H = HEX chart.
            GOSUB HEXChart
         CASE 23 ' Alt-I = DOS command.
            GOSUB DoDOSCommand
         CASE 36 ' Alt-J = Jump to byte.
            IF FileLength THEN
               GOSUB JumpByte
            END IF
         CASE 37 ' Alt-K = Search for ASCII string.
            IF FileLength THEN
               GOSUB SearchASCII
            END IF
         CASE 38 ' Alt-L = Jump to page.
            IF FileLength THEN
               GOSUB JumpPage
            END IF
         CASE 50 ' Alt-M = Append ASCII string.
            IF FileLength THEN
               GOSUB AppendASCII
            END IF
         CASE 49 ' Alt-N = Open new file.
            IF NumberFiles = 9 THEN
               StatusMessage = "Maximum of 9 files open."
               Call displaystatus2
            ELSE
               CALL MultiFileFunction(2)
               GOSUB NewFile
               GOTO BeginFile
            END IF
         CASE 24 ' Alt-O = Print help screens.
            GOSUB PrintHelp
         CASE 25 ' Alt-P = HEX screen print.
            IF FileLength THEN
               GOSUB PrintScreen
            END IF
         CASE 16 ' Alt-Q = Display help screens.
            GOSUB DisplayHelp
         CASE 19 ' Alt-R = Redraw screen.
            CALL MultiFileFunction(2)
            COLORf Plain
            ScreenDrawn = True
            CALL DisplayScreen
            GOSUB RestoreCurrentFile
            GOSUB RedrawScreen2
            Call restorehilightbytes
         CASE 31 ' Alt-S = Search for multiple bytes.
            IF FileLength THEN
               GOSUB SearchBytes
            END IF
         CASE 20 ' Alt-T = HEX file print.
            IF FileLength THEN
               GOSUB PrintFile
            END IF
         CASE 22 ' Alt-U = Undo last byte change.
            IF FileLength THEN
               GOSUB UndoByte
            END IF
         CASE 47 ' Alt-V = View files.
            CALL ViewFiles(Var)
            IF Var > False THEN
               NextFile = Var
               GOSUB SelectFile
            END IF
            Call displayfilename
         CASE 17 ' Alt-W = Close file.
            GOSUB CloseCurrentFile
            IF NumberFiles = False THEN
               GOSUB NewFile
               GOTO BeginFile
            END IF
         CASE 45 ' Alt-X = Exit program.
            EXIT DO ' exit program.
         CASE 21 ' Alt-Y = Toggle right window.
            IF FileLength THEN
               GOSUB ToggleRight
            END IF
         CASE 44 ' Alt-Z = Undo all byte changes.
            IF FileLength THEN
               GOSUB UndoAll
            END IF
         CASE 129 ' Alt-0 = Close all files.
            GOSUB CloseAllFiles
            GOSUB ResetAllAttributes
            GOSUB NewFile
            NumberFiles = False
            GOTO BeginFile
         CASE 59 ' F1 - toggle filename display.
            FileDisplay = NOT FileDisplay
            IF FileDisplay = False THEN
               Call DisplayFileTitle
            ELSE
               GOSUB DisplayScreen3
            END IF
         CASE 60 ' F2 - toggle bottom row help keys.
            ScreenRow = NOT ScreenRow
            CALL MultiFileFunction(2)
            COLORf Plain
            ScreenDrawn = True
            CALL DisplayScreen
            GOSUB RestoreCurrentFile
            GOSUB RedrawScreen2
            Call restorehilightbytes
         CASE 61 ' F3 - search ascii string.
            IF FileLength THEN
               GOSUB SearchASCII
            END IF
         CASE 62 ' F4 - search multiple bytes.
            IF FileLength THEN
               GOSUB SearchBytes
            END IF
         CASE 63 ' F5 - toggle right window.
            IF FileLength THEN
               GOSUB ToggleRight
            END IF
         CASE 64 ' F6 - goto next file.
            GOSUB GotoNextFile
         CASE 65 ' F7 - goto previous file.
            GOSUB GotoPreviousFile
         CASE 66 ' F8 - load new file.
            IF NumberFiles = 9 THEN
               StatusMessage = "Maximum of 9 files open."
               Call displaystatus2
            ELSE
               CALL MultiFileFunction(2)
               GOSUB NewFile
               GOTO BeginFile
            END IF
         CASE 67 ' F9 - close current file.
            GOSUB CloseCurrentFile
            IF NumberFiles = False THEN
               GOSUB NewFile
               GOTO BeginFile
            END IF
         CASE 68 ' F10 - view files.
            CALL ViewFiles(Var)
            IF Var > False THEN
               NextFile = Var
               GOSUB SelectFile
            END IF
            Call displayfilename
         CASE 96 ' Ctrl-F3  continue search.
            IF FileLength THEN
               GOSUB ContinueSearch
            END IF
         CASE 133 ' F11 - Drop to DOS.
            CALL MultiFileFunction(2)
            COLORf Plain
            CLS
            PRINTf "Type 'Exit' to return to editor.."
            Var$=Curdir$
            SHELL
            Chdrive Var$
            Chdir Var$
            ScreenDrawn = True
            CALL DisplayScreen
            GOSUB RestoreCurrentFile
            GOSUB RedrawScreen2
            Call restorehilightbytes
         CASE 134 ' F12 - DOS Command.
            GOSUB DoDOSCommand
         CASE 76, 108 ' keypad '5' key/Alt-F5 - Hex/Dec calculator.
            GOSUB HEXCalculator ' was in Hexedit6.bas
         CASE 120 TO 128 ' Alt-1 to Alt-9 - Select file.
            NextFile = ASC(RIGHT$(CharInput$, 1)) - 119
            GOSUB SelectFile
         CASE 82 ' Insert - Change string value.
            IF FileLength THEN
               GOSUB ChangeASCIIValues
            END IF
         CASE 83 ' Delete - Change HEX string.
            IF FileLength THEN
               GOSUB ChangeHEXValues
            END IF
         CASE 72 ' Up
            IF FileLength THEN
               GOSUB CursorUp
            END IF
         CASE 80 ' Down
            IF FileLength THEN
               GOSUB CursorDown
            END IF
         CASE 75 ' Left
            IF FileLength THEN
               GOSUB CursorLeft
            END IF
         CASE 77 ' Right
            IF FileLength THEN
               GOSUB CursorRight
            END IF
         CASE 73 ' PageUp
            IF FileLength THEN
               GOSUB PageUp
            END IF
         CASE 81 ' PageDown
            IF FileLength THEN
               GOSUB PageDown
            END IF
         CASE 79 ' End
            IF FileLength THEN
               GOSUB EndKey
            END IF
         CASE 71 ' Home
            IF FileLength THEN
               GOSUB HomeKey
            END IF
         CASE 115 ' Ctrl-Left
            IF FileLength THEN
               GOSUB CtrlLeftKey
            END IF
         CASE 116 ' Ctrl-Right
            IF FileLength THEN
               GOSUB CtrlRightKey
            END IF
         CASE 117 ' Ctrl-End
            IF FileLength THEN
               GOSUB CtrlEndKey
            END IF
         CASE 119 ' Ctrl-Home
            IF FileLength THEN
               GOSUB CtrlHomeKey
            END IF
         CASE ELSE ' Unknown key.
            GOSUB HelpLine
         END SELECT
      CASE ELSE ' Unknown key.
         ' impossible to get here.
      END SELECT
   END IF

   ' reset mouse activity.
   CALL SMouse
   GOSUB RestorePosition
   Call locatecursor2
LOOP

' stop program.
StopLabel:

' clear hilighted byte.
Call clearpagebyte
GOSUB MoveOldPosition

' clear status areas.
Call clearstatus
GOSUB DisplayScreen3

' display goodbye message.
CALL GoodBye

' clear file menu tab.
IF CurrentMenu THEN
   COLORf2 White, 0
   CALL DisplayTab(CurrentMenu)
END IF

' clear lower screen lines.
CALL ClearLines

' end of program.
GOSUB CloseAllFiles
GOSUB ResetAllAttributes

' goto stop program.
COLORf Plain
GOTO StopProgram
END

' load filespec.
LoadMultipleFile:
 ' check max files.
 IF NumberFiles = 9 THEN
    RETURN
 END IF

 ' trim filename.
 Filename = Var$
 Filename = RTRIM$(Filename)
 Filename = LTRIM$(Filename)

 ' check long filename in quotes.
 IF LEFT$(Filename, 1) = Quote THEN
    IF RIGHT$(Filename, 1) = Quote THEN
       Filename = MID$(Filename, 2)
       Filename = LEFT$(Filename, LEN(Filename) - 1)
    END IF
 END IF

 ' check wildcard characters.
 IF INSTR(Filename, "?") OR INSTR(Filename, "*") THEN
    ' store filename drive/directory
    D$ = Nul
    C$ = Nul
    N$ = Nul
    X$ = Nul
    ' get netpath
    IF LEFT$(Filename, 2) = "\\" THEN
       Net1 = INSTR(3, Filename, "\")
       IF Net1 THEN
          Net2 = INSTR(Net1 + 1, Filename, "\")
          IF Net2 THEN
             N$ = LEFT$(Filename, Net2 - 1)
             Filename = MID$(Filename, Net2)
          END IF
       END IF
    END IF
    ' get directory
    FOR Var = LEN(Filename) TO 1 STEP -1
       IF MID$(Filename, Var, 1) = "\" THEN
          D$ = LEFT$(Filename, Var)
          X$ = MID$(Filename, Var + 1)
          EXIT FOR
       END IF
    NEXT
    ' restore filename
    IF N$ <> Nul THEN
       Filename = N$ + D$ + X$
    END IF
    ' get drive
    IF MID$(Filename, 2, 1) = ":" THEN
       C$ = LEFT$(Filename, 2)
       D$ = MID$(D$, 3)
    END IF
    ' clear filename array.
    FOR VarZ = 1 TO 9
       TempFiles(VarZ) = Nul
    NEXT
    ' store filename array.
    VarZ = False
    X$ = DIRx$(Filename)
    DO
       IF LEN(X$) THEN
          IF VarZ < 9 THEN
             VarZ = VarZ + 1
             IF N$ = Nul THEN
                TempFiles(VarZ) = C$ + D$ + X$
             ELSE
                IF D$ = Nul THEN
                   TempFiles(VarZ) = N$ + "\" + X$
                ELSE
                   TempFiles(VarZ) = N$ + "\" + D$ + X$
                END IF
             END IF
          ELSE
             EXIT DO
          END IF
       ELSE
          EXIT DO
       END IF
       X$ = DIRx$(Nul)
    LOOP
    ' load filename array.
    FOR VarZ = 1 TO 9
       IF RTRIM$(TempFiles(VarZ)) <> "" THEN
          ' check max files.
          IF NumberFiles = 9 THEN
             RETURN
          END IF
          Filename = RTRIM$(TempFiles(VarZ))
          GOSUB LoadNewFile
       END IF
    NEXT
 ELSE
    ' load single file.
    GOSUB LoadNewFile
 END IF
 RETURN

' loads filename.
LoadNewFile:
 ' check max files.
 IF NumberFiles = 9 THEN
    RETURN
 END IF

 ' store filename.
 ASCIIZ = Filename + CHR$(0)

 ' open/create file.
 GOSUB OpenFile

 ' get netpath
 GOSUB ParseNetPath

 ' conanicalize filename.
 GOSUB ShortFilename

 ' check file exclusion list.
 GOSUB CheckFile
 IF VarP THEN
    GOSUB CloseFile
    RETURN
 END IF

 ' check open error.
 IF ValidFile THEN

    ' initialize multiple file variables.
    NumberFiles = NumberFiles + 1
    CurrentFile = NumberFiles
    CALL MultiFileFunction(1)

    ' check length of file.
    GOSUB GetFileLength

    ' create 1 byte file.
    IF FileLength = False THEN
       GOSUB AppendFile
       GOSUB GetFileLength
    END IF

    ' store filelength.
    File(CurrentFile).FileLength = FileLength

    ' restore current file variables.
    GOSUB RestoreCurrentFile

    ' init paste files.
    CALL InitPasteFiles(VarQ)

    ' check bad filename.
    If VarQ Then
       GOTO Error.Exit
    End if
 END IF
 RETURN

' check file exclusion list.
CheckFile:
 VarP = False
 Check.Disk = True
 CLOSE #2
 OPEN ExcludeFile FOR INPUT AS #2
 Check.Disk = False
 IF Disk.Ready THEN
    RETURN
 END IF
 Y2$ = Filename
 Y2$ = UCASE$(Y2$)
 DO UNTIL EOF(2)
    LINE INPUT #2, Y1$
    Y1$ = LTRIM$(Y1$)
    Y1$ = RTRIM$(Y1$)
    Y1$ = UCASE$(Y1$)
    IF LEFT$(Y1$, 1) = Quote THEN
       Y1$ = MID$(Y1$, 2)
       IF RIGHT$(Y1$, 1) = Quote THEN
          Y1$ = LEFT$(Y1$, LEN(Y1$) - 1)
       END IF
    END IF
    Y1$ = LTRIM$(Y1$)
    Y1$ = RTRIM$(Y1$)
    IF LEN(Y1$) THEN
       IF INSTR(Y1$, " ") = False THEN
          ' check excluded file in filename.
          CALL CheckExcluded(Y1$, Y2$, Exclude.File%)
          IF Exclude.File% THEN
             VarP = True
             EXIT DO
          END IF
       END IF
    END IF
 LOOP
 RETURN

' select specific file number.
SelectFile:
 IF NextFile <= NumberFiles THEN
    IF NextFile <> CurrentFile THEN
       CALL MultiFileFunction(2)
       CurrentFile = NextFile
       GOSUB RestoreCurrentFile
       GOSUB RedrawScreen2
       Call restorehilightbytes
    END IF
 END IF
 RETURN

' goto next file.
GotoNextFile:
 IF NumberFiles = 1 THEN
    RETURN
 END IF
 CALL MultiFileFunction(2)
 CurrentFile = CurrentFile + 1
 IF CurrentFile > NumberFiles THEN
    CurrentFile = 1
 END IF
 GOSUB RestoreCurrentFile
 GOSUB RedrawScreen2
 Call restorehilightbytes
 RETURN

' goto previous file.
GotoPreviousFile:
 IF NumberFiles = 1 THEN
    RETURN
 END IF
 CALL MultiFileFunction(2)
 CurrentFile = CurrentFile - 1
 IF CurrentFile = False THEN
    CurrentFile = NumberFiles
 END IF
 GOSUB RestoreCurrentFile
 GOSUB RedrawScreen2
 Call restorehilightbytes
 RETURN

' close current file.
CloseCurrentFile:
 GOSUB CloseFile
 GOSUB ResetAttribute
 GOSUB PackFileArray
 RETURN

' pack file structure array.
PackFileArray:
 ' pack remaining structure.
 FOR Var = CurrentFile TO 8
    File(Var) = File(Var + 1)
 NEXT

 ' reduce files by one.
 NumberFiles = NumberFiles - 1

 ' check remaining files.
 IF NumberFiles > False THEN
    ' reset current file.
    IF CurrentFile > NumberFiles THEN
       CurrentFile = NumberFiles
    END IF

    ' restore current file.
    GOSUB RestoreCurrentFile
    GOSUB RedrawScreen2
    Call restorehilightbytes
 END IF
 RETURN

' prepare for new file.
NewFile:
 ' reset window.
 CLS
 LOCATEf 1, 1, 1
 PRINTf "Loading.."
 CurrentWindow = False
 CurrentWindow2 = False
 ScreenDrawn = False
 LOCATEf 24, 1, 1
 COLORf Plain
 RETURN

' restore current file variables.
RestoreCurrentFile:
 CALL MultiFileFunction(3)
 CALL OpenPasteFiles(VarQ)
 IF VarQ THEN
    GOTO Error.Exit
 END IF
 RETURN

' display command line instructions.
BootUsage:
 CALL DisplayBootUsage
 COLORf Plain
 GOTO StopProgram

' display filename border area.
DisplayScreen3:
 CALL DisplayScreen3X
 Call locatecursor2
 RETURN

' display ANSI charts.
ANSIChart:
 CALL DisplayANSIChart
 CALL MultiFileFunction(2)
 COLORf Plain
 ScreenDrawn = True
 CALL DisplayScreen
 GOSUB RestoreCurrentFile
 GOSUB RedrawScreen2
 Call restorehilightbytes
 RETURN

' display HEX charts.
HEXChart:
 CALL DisplayHEXCHart
 CALL MultiFileFunction(2)
 COLORf Plain
 ScreenDrawn = True
 CALL DisplayScreen
 GOSUB RestoreCurrentFile
 GOSUB RedrawScreen2
 Call restorehilightbytes
 RETURN

' display HEX calculator.
HEXCalculator:
 CALL HexCalc
 CALL MultiFileFunction(2)
 COLORf Plain
 ScreenDrawn = True
 CALL DisplayScreen
 GOSUB RestoreCurrentFile
 GOSUB RedrawScreen2
 Call restorehilightbytes
 RETURN

' function for unknown key.
HelpLine:
 Call clearstatus
 PRINTf "Editing file: " + RTRIM$(Filename)
 COLORf White
 PRINTf " Type Alt-Q for Help, Alt-O to print Help."
 Call locatecursor2
 RETURN

' displays help screens.
DisplayHelp:
 CALL HMouse
 CALL MultiFileFunction(2)
 CALL HelpScreen
 COLORf Plain
 ScreenDrawn = True
 CALL DisplayScreen
 GOSUB RestoreCurrentFile
 GOSUB RedrawScreen2
 Call restorehilightbytes
 CALL SMouse
 RETURN

' function for ? key.
DisplayInfo:
 Call clearstatus
 PRINTf "Editing file: " + RTRIM$(Filename) + " "
 IF FileLength = False THEN
    Call lockedfile
    RETURN
 END IF
 Attr$ = Nul
 IF (FileAttribute AND ReadOnlyBit) = ReadOnlyBit THEN
    Attr$ = Attr$ + "o"
 END IF
 IF (FileAttribute AND HiddenBit) = HiddenBit THEN
    Attr$ = Attr$ + "h"
 END IF
 IF (FileAttribute AND SystemBit) = SystemBit THEN
    Attr$ = Attr$ + "s"
 END IF
 IF (FileAttribute AND ArchiveBit) = ArchiveBit THEN
    Attr$ = Attr$ + "a"
 END IF
 IF LEN(Attr$) THEN
    PRINTf "(" + Attr$ + ") "
 END IF
 IF CurrentWindow2 = False THEN
    PRINTf "(Length:" + STR$(FileLength) + ") "
 ELSE
    PRINTf "(Length: " + RIGHT$("00000000" + HEX$(FileLength - 1), 8) + "H) "
 END IF
 PRINTf "(Undos:" + STR$(CurrentUndo) + ") "
 Call locatecursor2
 RETURN

' function for ! key.
DisplayData:
 Call clearstatus
 PRINTf "Editing file: " + RTRIM$(Filename) + " "
 IF FileLength = False THEN
    Call lockedfile
    RETURN
 END IF
 TempPosition3 = FilePosition
 CALL FormatPosition1
 Call locatecursor2
 RETURN

' function for ~ key.
DisplayLengths:
 Call clearstatus
 PRINTf "Editing file: " + RTRIM$(Filename) + " "
 IF FileLength = False THEN
    Call lockedfile
    RETURN
 END IF
 FilePage2 = INT((FileLength - 1) / 320) + 1
 IF CurrentWindow2 = False THEN
    PRINTf "(Last page:" + STR$(FilePage2 - 1) + ") "
 ELSE
    PRINTf "(Last page: " + RIGHT$("00000000" + HEX$(FilePage2 - 1), 8) + "H) "
 END IF
 ' count markers
 Var1 = False
 FOR Var2 = 1 TO MarkerCount
    IF Markers#(Var2) > 0# THEN
       Var1 = Var1 + 1
    END IF
 NEXT
 PRINTf "(Markers: " + MID$(STR$(Var1), 2) + ")"
 Call locatecursor2
 RETURN

' display copy start/end.
DisplayCopy:
 Call clearstatus
 PRINTf "Editing file: " + RTRIM$(Filename) + " "
 IF FileLength = False THEN
    Call lockedfile
    RETURN
 END IF
 IF CurrentWindow2 = False THEN
    PRINTf "(Copy position:"
    PRINTf STR$(CopyPositionStart) + " -" + STR$(CopyPositionEnd) + ") "
 ELSE
    PRINTf "(CopyPosition: "
    IF CopyPositionStart = False AND CopyPositionEnd = False THEN
       PRINTf "00000000H - 00000000H) "
    ELSE
       PRINTf RIGHT$("00000000" + HEX$(CopyPositionStart - 1), 8) + "H - "
       PRINTf RIGHT$("00000000" + HEX$(CopyPositionEnd - 1), 8) + "H) "
    END IF
 END IF
 Call locatecursor2
 RETURN

' display paste undos.
DisplayPasteUndos:
 Call clearstatus
 PRINTf "Editing file: " + RTRIM$(Filename) + " "
 IF FileLength = False THEN
    Call lockedfile
    RETURN
 END IF
 IF LOF(5)=0 THEN
    PRINTf " : No paste undos."
 ELSE
    GET #5, 1, CopyByte
    ByteEntries = ASC(CopyByte) * 16 ^ 2
    GET #5, 2, CopyByte
    ByteEntries = ByteEntries + ASC(CopyByte)
    PRINTf " :" + STR$(ByteEntries) + "paste undos stored."
 END IF
 Call locatecursor2
 RETURN

' display path of file being edited.
DisplayPath:
 IF FileLength = False THEN
    RETURN
 END IF
 Call clearstatus
 Z$ = RTRIM$(ShortFilename)
 N$ = RTRIM$(CurrentNetPath)
 IF N$ <> Nul THEN
    IF MID$(Z$, 2, 1) = ":" THEN
       Z$ = MID$(Z$, 3)
    END IF
 END IF
 CALL Deconcatenate(N$, Z$, 64)
 Var = LEN(Z$)
 DO
    Var = Var - 1
    IF Var = False THEN
       Z$ = Nul
       EXIT DO
    END IF
    IF MID$(Z$, Var, 1) = "\" THEN
       Z$ = LEFT$(Z$, Var)
       EXIT DO
    END IF
 LOOP
 IF Z$ = Nul THEN
    Z$ = "\"
 END IF
 PRINTf "Editing path: " + Z$ + " "
 FileDisplay2 = True
 Call locatecursor2
 RETURN

' redraw editing screen
RedrawScreen:
 ScreenDrawn = True
 CALL DisplayScreen
RedrawScreen2:
 Call displayfilename
 Call displayhexpage
 Call displaypagebyte
 IF FileDisplay = False THEN
    Call DisplayFileTitle
 END IF
 RETURN

' search file for ascii string.
SearchASCII:
 CALL SearchFile(0, FoundString)
 GOTO FinishSearch

' search file for hex string.
SearchBytes:
 CALL SearchFile(1, FoundString)
 GOTO FinishSearch

' continue previous search.
ContinueSearch:
 IF RTRIM$(StoreSearchString) = Nul THEN
    RETURN
 END IF
 CALL SearchFile(2, FoundString)

' display search results.
FinishSearch:
 ' check byte comparison
 IF FoundString = True THEN
    FilePosition = SearchBytePosition
    StoreSearchPosition = FilePosition
    CALL CalculatePosition1
    IF LastPage <> FilePage THEN
       Call displayhexpage
    END IF
 END IF
 Call displaypagebyte
 IF FoundString = False THEN
    StoreSearchPosition = DFalse
    StatusMessage = "String not found."
    Call displaystatus2
    RETURN
 END IF
 Call displayfilename
 RETURN

' dump screen of current page of hex/ascii values to file.
DumpScreen:
 Column = False
 ColumnSpace = False
 HexLine$ = Nul
 HexLine2$ = Nul
 CLOSE #1
 ErrorTrap = False
 IF TestFile(DumpFile) = False THEN
    StatusMessage = "Error opening dump filename."
    Call displaystatus1
    RETURN
 END IF
 OPEN DumpFile FOR APPEND AS #1
 IF ErrorTrap THEN
    CALL MultiFileFunction(2)
    COLORf Plain
    ScreenDrawn = True
    CALL DisplayScreen
    GOSUB RestoreCurrentFile
    GOSUB RedrawScreen2
    Call restorehilightbytes
    RETURN
 END IF
 CALL DumpScreenSub
 Call displaypagebyte
 ' conanicalize filename.
 Filename2$ = Conanicalize$(DumpFile)
 ' display filename.
 StatusMessage = "Screen dumped to: '" + Filename2$ + "'."
 Call displaystatus1
 RETURN

' dump file of current hex/ascii values to file.
DumpHEXFile:
 Column = False
 ColumnSpace = False
 HexLine$ = Nul
 HexLine2$ = Nul
 CLOSE #1
 ErrorTrap = False
 IF TestFile(DumpFile) = False THEN
    StatusMessage = "Error opening dump filename."
    Call displaystatus1
    RETURN
 END IF
 OPEN DumpFile FOR APPEND AS #1
 IF ErrorTrap THEN
    CALL MultiFileFunction(2)
    COLORf Plain
    ScreenDrawn = True
    CALL DisplayScreen
    GOSUB RestoreCurrentFile
    GOSUB RedrawScreen2
    Call restorehilightbytes
    RETURN
 END IF
 CALL DumpFileSub
 Call displaypagebyte
 ' conanicalize filename.
 Filename2$ = Conanicalize$(DumpFile)
 ' display filename.
 IF FileDumped THEN
    StatusMessage = "File dumped to: '" + Filename2$ + "'."
 ELSE
    StatusMessage = "Partial file dumped to: '" + Filename2$ + "'."
 END IF
 Call displaystatus1
 RETURN

' print screen of current page of hex/ascii values to printer.
PrintScreen:
 ' get printer port.
 GOSUB OpenPrinter
 IF ValidPrint = False THEN
    RETURN
 END IF
 ' start print.
 CALL PrintSCreenSub
 Call displaypagebyte
 StatusMessage = "Screen dumped to printer port:" + STR$(PortNumber) + "."
 Call displaystatus1
 RETURN

' print file of current hex/ascii values to printer.
PrintFile:
 ' get printer port.
 GOSUB OpenPrinter
 IF ValidPrint = False THEN
    RETURN
 END IF
 ' start print.
 CALL PrintFileSub
 Call displaypagebyte
 IF FileDumped THEN
    StatusMessage = "File dumped to printer port:" + STR$(PortNumber) + "."
 ELSE
    StatusMessage = "Partial file dumped to printer port:" + STR$(PortNumber) + "."
 END IF
 Call displaystatus1
 RETURN

' print help screens.
PrintHelp:
 ' get printer port.
 GOSUB OpenPrinter
 IF ValidPrint = False THEN
    RETURN
 END IF
 ' start print.
 CALL PrintHelpScreens
 Call displayfilename
 RETURN

' get printer port.
OpenPrinter:
 ValidPrint = False
 Call clearstatus
 PRINT "Enter printer port(1-3)";
 INPUT PortNumber
 PortNumber = INT(PortNumber)
 IF PortNumber >= 1 AND PortNumber <= 3 THEN
    CLOSE #1
    Filename2$ = "LPT" + MID$(STR$(PortNumber), 2) + ":"
    ErrorTrap = False
    OPEN Filename2$ FOR OUTPUT AS #1
    IF ErrorTrap THEN
       CALL MultiFileFunction(2)
       COLORf Plain
       ScreenDrawn = True
       CALL DisplayScreen
       GOSUB RestoreCurrentFile
       GOSUB RedrawScreen2
       Call restorehilightbytes
       RETURN
    END IF
 ELSE
    StatusMessage = "Invalid printer port number."
    Call displaystatus1
    RETURN
 END IF
 ValidPrint = True
 RETURN

' add multiple specified byte to file and locate there.
AppendAnyByte:
 Call clearstatus
 PRINTf "Enter number of bytes"
 INPUT ByteString$
 IF LEN(ByteString$) = False THEN
    StatusMessage = "Invalid append bytes."
    Call displaystatus2
    RETURN
 END IF
 IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
    CALL CheckHexValue(ByteString$)
    IF ValidHexValue = False THEN
       RETURN
    END IF
    NumBytes2# = HexValue - 1#
 ELSE
    CALL CheckASCIIValue(ByteString$)
    IF ValidASCIIValue = False THEN
       RETURN
    END IF
    NumBytes2# = ASCIIValue3
 END IF
 Call clearstatus
 ValidByteString = False
 PRINTf "Enter hex byte"
 INPUT ByteString$
 IF LEN(ByteString$) = 2 THEN
    AllowWildcard = False
    CALL CheckHexBytes(ByteString$)
    IF ValidByteString THEN
       Byte2 = VAL("&H" + ByteString$)
    END IF
 END IF
 IF ValidByteString = False THEN
    StatusMessage = "Invalid append hex value."
    Call displaystatus2
    RETURN
 END IF
 Call clearstatus
 PRINTf "Editing file: " + RTRIM$(Filename)
 COLORf White
 PRINTf " Appending specified bytes to file:"
 CursorLocation = 53 + LEN(RTRIM$(Filename))
 GOTO AppendBytes2

' add multiple null bytes to file and locate there.
AppendNullBytes:
 Call clearstatus
 PRINTf "Enter number of bytes"
 INPUT ByteString$
 IF LEN(ByteString$) = False THEN
    StatusMessage = "Invalid append bytes."
    Call displaystatus2
    RETURN
 END IF
 IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
    CALL CheckHexValue(ByteString$)
    IF ValidHexValue = False THEN
       RETURN
    END IF
    NumBytes2# = HexValue - 1#
 ELSE
    CALL CheckASCIIValue(ByteString$)
    IF ValidASCIIValue = False THEN
       RETURN
    END IF
    NumBytes2# = ASCIIValue3
 END IF
 Byte2 = False
 Call clearstatus
 PRINTf "Editing file: " + RTRIM$(Filename)
 COLORf White
 PRINTf " Appending null bytes to file:"
 CursorLocation = 48 + LEN(RTRIM$(Filename))

' append bytes past end of file.
AppendBytes2:
 LastPage = FilePage
 Call clearpagebyte
 PercentDisplayed! = SFalse
 LOCATEf 2, CursorLocation, 0
 PRINTf " 0%"
 BlockBytes# = INT(NumBytes2# / 32767#)
 RemainingBytes# = NumBytes2# MOD 32767#
 ' write 32767 byte blocks.
 IF BlockBytes# > 0# THEN
    BlockByte = STRING$(32767, CHR$(Byte2))
    FOR Byte1# = 1# TO BlockBytes#
       IF INKEY$ = CHR$(27) THEN
          GOTO EndAppend
       END IF
       IF FileLength + 32767# <= 2147483647# THEN
          SeekPosition = FileLength + 1#
          FileLength = FileLength + 32767#
          Call lseekfile
          GOSUB WriteBlockFile
          FilePosition = FileLength
          CALL CalculatePosition1
          PercentCopied! = INT(CSNG(Byte1# / BlockBytes#) * 100!)
          IF PercentCopied! > PercentDisplayed! THEN
             LOCATEf 2, CursorLocation, 0
             PRINTf STR$(PercentCopied!) + "%"
             PercentDisplayed! = PercentCopied!
          END IF
       ELSE
          GOTO EndAppend
       END IF
    NEXT
 END IF
 ' write remaining bytes.
 PercentDisplayed! = SFalse
 LOCATEf 2, CursorLocation, 0
 PRINTf " 0%  "
 IF RemainingBytes# > 0# THEN
    FileByte = CHR$(Byte2)
    FOR Byte1# = 1# TO RemainingBytes#
       IF FileLength + 1# <= 2147483647# THEN
          FileLength = FileLength + 1#
          SeekPosition = FileLength
          Call lseekfile
          Call writefile
          FilePosition = FileLength
          CALL CalculatePosition1
          IF LastPage = FilePage THEN
             Call clearpagebyte
          END IF
          PercentCopied! = INT(CSNG(Byte1# / RemainingBytes#) * 100!)
          IF PercentCopied! > PercentDisplayed! THEN
             LOCATEf 2, CursorLocation, 0
             PRINTf STR$(PercentCopied!) + "%"
             PercentDisplayed! = PercentCopied!
          END IF
       ELSE
          EXIT FOR
       END IF
    NEXT
 END IF
EndAppend:
 CALL CalculatePosition1
 IF LastPage <> FilePage THEN
    LastPage = FilePage
    Call displayhexpage
 END IF
 Call displaypagebyte
 Call displayfilename
 RETURN 

' add multiple bytes of an ASCII string to file and locate there.
AppendASCII:
 Call clearstatus
 PRINTf "Enter ASCII string"
 INPUT ByteString$
 IF LEN(ByteString$) = False THEN
    StatusMessage = "Invalid append string."
    Call displaystatus2
    RETURN
 END IF
 NumBytes = LEN(ByteString$)
 CALL AsciiToHex2(ByteString$)
 GOTO StartAppend

' add multiple bytes to file and locate there.
'   left window specifies space-separated hex byte pairs,
'   right window specifies space-separated 3-byte ascii pairs.
AppendByte:
 Call clearstatus
 IF CurrentWindow = False THEN
    PRINTf "Enter hex byte(s)"
    INPUT ByteString$
    IF LEFT$(ByteString$, 1) = "+" THEN
       ByteString$ = MID$(ByteString$, 2)
       CALL CheckAsciiBytes(ByteString$)
    ELSE
       AllowWildcard = False
       CALL CheckHexBytes(ByteString$)
    END IF
 ELSE
    PRINTf "Enter ascii byte(s)"
    INPUT ByteString$
    IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
       ByteString$ = MID$(ByteString$, 2)
       AllowWildcard = False
       CALL CheckHexBytes(ByteString$)
    ELSE
       CALL CheckAsciiBytes(ByteString$)
    END IF
 END IF
 IF ValidByteString = False THEN
    StatusMessage = "Invalid append string."
    Call displaystatus2
    RETURN
 END IF

' append the byte string.
StartAppend:
 LastPage = FilePage
 FOR Byte1 = 1 TO NumBytes
    Call clearpagebyte
    Byte$ = MID$(ByteString$, (Byte1 - 1) * 2 + 1, 2)
    Byte2 = VAL("&H" + Byte$)
    GOSUB AppendIt
    IF ValidAppend = False THEN
       EXIT FOR
    END IF
 NEXT
 Call displayfilename
 RETURN

' appends a byte to file.
AppendIt:
 ValidAppend = False
 FileByte = CHR$(Byte2)
 IF FileLength + 1# <= 2147483647# THEN
    ValidAppend = True
    FileLength = FileLength + 1#
    SeekPosition = FileLength
    Call lseekfile
    Call writefile
    FilePosition = FileLength
    CALL CalculatePosition1
    IF LastPage <> FilePage THEN
       LastPage = FilePage
       Call displayhexpage
    END IF
    Call displaypagebyte
 END IF
 RETURN

' jump to page position in file.
JumpPage:
 Call clearstatus
 PRINTf "Enter page position"
 INPUT ByteString$
 IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
    CALL CheckHexValue(ByteString$)
    IF ValidHexValue = False THEN
       RETURN
    END IF
    NextPage = HexValue
 ELSE
    CALL CheckASCIIValue(ByteString$)
    IF ValidASCIIValue = False THEN
       RETURN
    END IF
    NextPage = ASCIIValue3
 END IF
 ' check the new page is there to jump to.
 TempPosition3 = (NextPage - 1) * 320 + 1
 IF TempPosition3 >= 1 AND TempPosition3 <= FileLength THEN
    Call clearpagebyte
    LastPage = FilePage
    ' preserve current row, column.
    FilePosition = TempPosition3
    TempPosition2 = FilePosition + (PageRow - 1) * 20 + PageColumn - 1
    IF TempPosition2 <= FileLength THEN
       FilePosition = TempPosition2
    ELSE
       FilePosition = FileLength
    END IF
    CALL CalculatePosition1
    IF LastPage <> FilePage THEN
       Call displayhexpage
    END IF
    Call displaypagebyte
    Call displayfilename
    RETURN
 END IF
 StatusMessage = "Invalid page."
 Call displaystatus2
 RETURN

' jump to a byte position in file.
JumpByte:
 Call clearstatus
 PRINTf "Enter file position"
 INPUT ByteString$
 IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
    CALL CheckHexValue(ByteString$)
    IF ValidHexValue = False THEN
       RETURN
    END IF
    NewByte = HexValue
 ELSE
    CALL CheckASCIIValue(ByteString$)
    IF ValidASCIIValue = False THEN
       RETURN
    END IF
    NewByte = ASCIIValue3
 END IF
 IF NewByte >= 1 AND NewByte <= FileLength THEN
    IF NewByte <> FilePosition THEN
       Call clearpagebyte
       LastPage = FilePage
       FilePosition = NewByte
       CALL CalculatePosition1
       IF LastPage <> FilePage THEN
          Call displayhexpage
       END IF
       Call displaypagebyte
    END IF
    Call displayfilename
    RETURN
 END IF
 StatusMessage = "Invalid byte."
 Call displaystatus2
 RETURN

' undo a byte from stored arrays of previous position/byte value.
UndoByte:
 IF CurrentUndo > False THEN
    Call clearpagebyte
    LastPage = FilePage
    FileByte = CHR$(UndoByte%(CurrentUndo))
    FilePosition = UndoPosition#(CurrentUndo)
    CurrentUndo = CurrentUndo - 1
    SeekPosition = FilePosition
    Call lseekfile
    Call writefile
    CALL CalculatePosition1
    IF LastPage <> FilePage THEN
       Call displayhexpage
    END IF
    Call displaypagebyte
 END IF
 RETURN

' undo all bytes from stored arrays of previous position/byte value.
UndoAll:
 IF CurrentUndo > False THEN
    TotalUndos = CurrentUndo
    FOR NextUndo = TotalUndos TO 1 STEP -1
       Call clearpagebyte
       LastPage = FilePage
       FileByte = CHR$(UndoByte%(NextUndo))
       FilePosition = UndoPosition#(NextUndo)
       CurrentUndo = CurrentUndo - 1
       SeekPosition = FilePosition
       Call lseekfile
       Call writefile
       CALL CalculatePosition1
       IF LastPage <> FilePage THEN
          LastPage = FilePage
          Call displayhexpage
       END IF
       Call displaypagebyte
    NEXT
 END IF
 RETURN

REM Cursor key routines:

' move cursor up.
CursorUp:
 IF PageRow - 1 >= 1 THEN
    Call clearpagebyte
    PageRow = PageRow - 1
    FilePosition = FilePosition - 20
    Call displaypagebyte
    RETURN
 END IF
 Call clearpagebyte
 Call displaypagebyte
 RETURN

' move cursor down.
CursorDown:
 IF PageRow + 1 <= 16 THEN
    IF FilePosition + 20 <= FileLength THEN
       Call clearpagebyte
       PageRow = PageRow + 1
       FilePosition = FilePosition + 20
       IF FilePosition > FileLength THEN
          PageColumn = PageColumn - 1
          FilePosition = FilePosition - 1
       END IF
       Call displaypagebyte
       RETURN
    END IF
 END IF
 Call clearpagebyte
 Call displaypagebyte
 RETURN

' move cursor left.
CursorLeft:
 IF PageColumn - 1 >= 1 THEN
    IF CopyPositionStart > False THEN
       IF PageColumn = 20 THEN
          Call clearpagebyte
          Call displaypagebyte
          RETURN
       END IF
       IF FilePosition = FileLength THEN
          Call clearpagebyte
          Call displaypagebyte
          RETURN
       END IF
    END IF
    Call clearpagebyte
    PageColumn = PageColumn - 1
    FilePosition = FilePosition - 1
    Call displaypagebyte
 ELSE
    Call clearpagebyte
    IF PageColumn > 1 THEN
       PageColumn = 1
       FilePosition = FilePosition - 1
    END IF
    Call displaypagebyte
 END IF
 RETURN

' move cursor right.
CursorRight:
 IF PageColumn + 1 <= 20 THEN
    IF FilePosition + 1 <= FileLength THEN
       Call clearpagebyte
       IF PageColumn < 20 THEN
          IF FilePosition + 1 <= FileLength THEN
             PageColumn = PageColumn + 1
             FilePosition = FilePosition + 1
          END IF
       END IF
       Call displaypagebyte
       RETURN
    END IF
 END IF
 Call clearpagebyte
 Call displaypagebyte
 RETURN

' end key
EndKey:
 ' set to column 20
 IF PageColumn < 20 THEN
    ' check column 20 is positioned before end of file
    IF FilePosition - PageColumn + 20 <= FileLength THEN
       Call clearpagebyte
       FilePosition = FilePosition - PageColumn + 20
       PageColumn = 20
       Call displaypagebyte
    ELSE
       ' position end of file
       Call clearpagebyte
       FilePosition = FileLength
       CALL CalculatePosition1
       Call displaypagebyte
    END IF
 ELSE
    Call clearpagebyte
    Call displaypagebyte
    Call locatecursor
 END IF
 RETURN

' home key
HomeKey:
 IF PageColumn > 1 THEN
    Call clearpagebyte
    FilePosition = FilePosition - PageColumn + 1
    PageColumn = 1
    Call displaypagebyte
 ELSE
    Call clearpagebyte
    IF PageColumn > 1 THEN
       PageColumn = 1
       FilePosition = FilePosition - 1
    END IF
    Call displaypagebyte
    Call locatecursor
 END IF
 RETURN

' control-left key
CtrlLeftKey:
 NewColumn = False
 SELECT CASE PageColumn
 CASE 2, 3, 4
    NewColumn = 1
 CASE 5
    NewColumn = 4
 CASE 6, 7, 8
    NewColumn = 5
 CASE 9
    NewColumn = 8
 CASE 10, 11, 12
    NewColumn = 9
 CASE 13
    NewColumn = 12
 CASE 14, 15, 16
    NewColumn = 13
 CASE 17
    NewColumn = 16
 CASE 18, 19, 20
    NewColumn = 17
 END SELECT
 IF NewColumn > False THEN
    Call clearpagebyte
    FilePosition = FilePosition - PageColumn + NewColumn
    PageColumn = NewColumn
    Call displaypagebyte
 END IF
 RETURN

' control-right key
CtrlRightKey:
 NewColumn = False
 SELECT CASE PageColumn
 CASE 1, 2, 3
    NewColumn = 4
 CASE 4
    NewColumn = 5
 CASE 5, 6, 7
    NewColumn = 8
 CASE 8
    NewColumn = 9
 CASE 9, 10, 11
    NewColumn = 12
 CASE 12
    NewColumn = 13
 CASE 13, 14, 15
    NewColumn = 16
 CASE 16
    NewColumn = 17
 CASE 17, 18, 19
    NewColumn = 20
 END SELECT
 IF NewColumn THEN
    ' check new column is positioned before end of file
    IF FilePosition - PageColumn + NewColumn <= FileLength THEN
       Call clearpagebyte
       FilePosition = FilePosition - PageColumn + NewColumn
       PageColumn = NewColumn
       Call displaypagebyte
    ELSE
       ' position end of file
       Call clearpagebyte
       FilePosition = FileLength
       CALL CalculatePosition1
       Call displaypagebyte
    END IF
 END IF
 RETURN

' control-end key
CtrlEndKey:
 IF FilePosition <> FileLength THEN
    LastPage = FilePage
    Call clearpagebyte
    FilePosition = FileLength
    CALL CalculatePosition1
    IF LastPage <> FilePage THEN
       Call displayhexpage
    END IF
    Call displaypagebyte
 ELSE
    Call clearpagebyte
    Call displaypagebyte
    Call locatecursor
 END IF
 RETURN

' control-home key
CtrlHomeKey:
 IF FilePosition <> 1 THEN
    LastPage = FilePage
    Call clearpagebyte
    FilePosition = 1
    CALL CalculatePosition1
    IF LastPage <> FilePage THEN
       Call displayhexpage
    END IF
    Call displaypagebyte
 END IF
 RETURN

' move one page up.
PageUp:
 ' check there is a page to move up.
 IF FilePosition - 320 >= 1 THEN
    FilePage = FilePage - 1
    FilePosition = FilePosition - 320
    Call displayhexpage
    Call displaypagebyte
 ELSE
    ' check there is a first position on the first page to move up to.
    IF FilePosition > 1 THEN
       Call clearpagebyte
       PageRow = 1
       PageColumn = 1
       FilePosition = 1
       Call displaypagebyte
    ELSE
       Call clearpagebyte
       Call displaypagebyte
       Call locatecursor
    END IF
 END IF
 RETURN

' move one page down.
PageDown:
 ' check there is a page to move down.
 IF FilePosition + 320 <= FileLength THEN
    FilePage = FilePage + 1
    FilePosition = FilePosition + 320
    Call displayhexpage
    Call displaypagebyte
 ELSE
    ' check there is a last position on the last page to move down to.
    IF FilePosition < FileLength THEN
       Call clearpagebyte
       FilePosition = FileLength
       CALL CalculatePosition1
       Call displayhexpage
       Call displaypagebyte
    ELSE
       Call clearpagebyte
       Call displaypagebyte
       Call locatecursor
    END IF
 END IF
 RETURN

REM More routines:

' switch editing windows.
TabWindow:
 IF CurrentWindow2 = False THEN
    CurrentWindow = NOT CurrentWindow
    Call locatecursor2
 END IF
 RETURN

' switch editing windows.
ToggleRight:
 CurrentWindow = False
 CurrentWindow2 = NOT CurrentWindow2
 Call redrawrightwindow
 Call displaypagebyte
 RETURN

' change the byte value at the current position.
'   change by hex value in left window,
'   by ascii value in right window.
'   overrides with +255 in left window,
'   and with hff in right window.
ChangeHexValue:
 Call clearstatus
 FileByte = Nul
 ValidByteString = False
 IF CurrentWindow = False THEN
    PRINTf "Enter hex byte value"
    INPUT ByteString$
    IF LEFT$(ByteString$, 1) = "+" THEN
       ByteString$ = MID$(ByteString$, 2)
       IF LEN(ByteString$) = 3 THEN
          NewValue = INT(VAL(ByteString$))
          IF NewValue >= False AND NewValue <= 255 THEN
             ValidByteString = True
             FileByte = CHR$(NewValue)
          END IF
       END IF
    ELSE
       IF LEN(ByteString$) = 2 THEN
          AllowWildcard = False
          CALL CheckHexBytes(BYteString$)
          IF ValidByteString THEN
             NewValue = VAL("&H" + ByteString$)
             FileByte = CHR$(NewValue)
          END IF
       END IF
    END IF
 ELSE
    PRINTf "Enter ascii byte value"
    INPUT ByteString$
    IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
       ByteString$ = MID$(ByteString$, 2)
       IF LEN(ByteString$) = 2 THEN
          AllowWildcard = False
          CALL CheckHexBytes(ByteString$)
          IF ValidByteString THEN
             NewValue = VAL("&H" + ByteString$)
             FileByte = CHR$(NewValue)
          END IF
       END IF
    ELSE
       IF LEN(ByteString$) = 3 THEN
          NewValue = INT(VAL(ByteString$))
          IF NewValue >= False AND NewValue <= 255 THEN
             ValidByteString = True
             FileByte = CHR$(NewValue)
          END IF
       END IF
    END IF
 END IF
 IF ValidByteString = False THEN
    StatusMessage = "Invalid byte."
    Call displaystatus2
    RETURN
 END IF
 GOSUB StoreUndo
 SeekPosition = FilePosition
 Call lseekfile
 Call writefile
 Call displaypagebyte
 Call displayfilename
 RETURN

' change the ascii values with string starting at the current position.
ChangeASCIIValues:
 Call clearstatus
 PRINTf "Enter ascii value(s)? "
 LINE INPUT ByteString$
 IF LEN(ByteString$) = False THEN
    StatusMessage = "Invalid ascii string."
    Call displaystatus2
    RETURN
 END IF
 ' store all current ascii values.
 Call clearpagebyte
 StorePosition = FilePosition
 FOR NumberBytes = 1 TO LEN(ByteString$)
    SeekPosition = FilePosition
    Call lseekfile
    Call readfile
    FileByte = Buffer
    AsciiValue = ASC(FileByte)
    GOSUB StoreUndo
    IF FilePosition = FileLength THEN
       EXIT FOR
    END IF
    FilePosition = FilePosition + 1
 NEXT
 ' write ascii string.
 FilePosition = StorePosition
 FOR NumberBytes = 1 TO LEN(ByteString$)
    FileByte = MID$(ByteString$, NumberBytes, 1)
    SeekPosition = FilePosition
    Call lseekfile
    Call writefile
    Call displaypagebyte
    IF FilePosition = FileLength THEN
       EXIT FOR
    END IF
    Call clearpagebyte
    FilePosition = FilePosition + 1
    CALL CalculatePosition1
    IF LastPage <> FilePage THEN
       LastPage = FilePage
       Call displayhexpage
    END IF
 NEXT
 Call displaypagebyte
 Call displayfilename
 RETURN

' change the hex values with string starting at the current position.
ChangeHEXValues:
 Call clearstatus
 PRINTf "Enter HEX value(s)? "
 LINE INPUT ByteString$
 IF LEN(ByteString$) = False THEN
    StatusMessage = "Invalid hex string."
    Call displaystatus2
    RETURN
 END IF
 ' check hex string.
 AllowWildcard = False
 CALL CheckHexBytes(BYteString$)
 IF ValidByteString = False THEN
    StatusMessage = "Invalid hex string."
    Call displaystatus2
    RETURN
 END IF
 ' store all current hex values.
 Call clearpagebyte
 StorePosition = FilePosition
 FOR NumberBytes = 1 TO LEN(ByteString$)
    SeekPosition = FilePosition
    Call lseekfile
    Call readfile
    FileByte = Buffer
    AsciiValue = ASC(FileByte)
    GOSUB StoreUndo
    IF FilePosition = FileLength THEN
       EXIT FOR
    END IF
    FilePosition = FilePosition + 1
 NEXT
 ' write hex string.
 FilePosition = StorePosition
 FOR NumberBytes = 1 TO LEN(ByteString$) STEP 2
    FileByte = CHR$(VAL("&H" + MID$(ByteString$, NumberBytes, 2)))
    SeekPosition = FilePosition
    Call lseekfile
    Call writefile
    Call displaypagebyte
    IF FilePosition = FileLength THEN
       EXIT FOR
    END IF
    Call clearpagebyte
    FilePosition = FilePosition + 1
    CALL CalculatePosition1
    IF LastPage <> FilePage THEN
       LastPage = FilePage
       Call displayhexpage
    END IF
 NEXT
 Call displaypagebyte
 Call displayfilename
 RETURN

' record the current byte position and value.
' increment the number of undos in record structure array.
StoreUndo:
 IF CurrentUndo >= 32767 THEN
    StatusMessage = "Maximum undos are at 32,767."
    Call displaystatus2
    RETURN
 END IF
 IF CurrentUndo < 32767 THEN
    CurrentUndo = CurrentUndo + 1
    UndoFile.UndoByte1(CurrentFile) = AsciiValue
    UndoFile.UndoPosition1(CurrentFile) = FilePosition
    PUT #6, CurrentUndo, UndoFile
 END IF
 RETURN

' drop down input menu.
Menu2:
 CALL SMouse
 CALL DropDownMenu
 GOSUB RestorePosition
 IF CurrentMenu = False THEN
    Call locatecursor
    GOTO StartLoop
 END IF
 ' reset mouse activity.
 CALL HMouse
 SELECT CASE CurrentMenu
 CASE 1
    SELECT CASE CurrentMenuSelection
    CASE 1 ' Alt-N  Open new file
       IF NumberFiles < 9 THEN
          CALL MultiFileFunction(2)
          GOSUB NewFile
          GOTO BeginFile
       END IF
    CASE 2 ' Alt-W  Close file
       GOSUB CloseCurrentFile
       IF NumberFiles = False THEN
          GOSUB NewFile
          GOTO BeginFile
       END IF
    CASE 3 ' Alt-0  Close All Files
       GOSUB CloseAllFiles
       GOSUB ResetAllAttributes
       GOSUB NewFile
       NumberFiles = False
       GOTO BeginFile
    CASE 4 ' Alt-V  View files
       CALL ViewFiles(Var)
       IF Var > False THEN
          NextFile = Var
          GOSUB SelectFile
       END IF
       Call displayfilename
    CASE 5 ' Alt-Y  Toggle window
       IF FileLength THEN
          GOSUB ToggleRight
       END IF
    CASE 6 ' Alt-X  Exit program
       GOTO StopLabel
    END SELECT
 CASE 2
    If FileLength Then
       SELECT CASE CurrentMenuSelection
       CASE 1 ' Alt-C  ANSI Chart
          GOSUB ANSIChart
       CASE 2 ' Alt-H  HEX Chart
          GOSUB HEXChart
       END SELECT
    End if
 CASE 3
    If FileLength Then
       SELECT CASE CurrentMenuSelection
       CASE 1 ' Alt-D  HEX Screen Dump
          GOSUB DumpScreen
       CASE 2 ' Alt-E  HEX File Dump
          GOSUB DumpHEXFile
       END SELECT
    End if
 CASE 4
    If FileLength Then
       SELECT CASE CurrentMenuSelection
       CASE 1 ' Alt-A  Append bytes
          GOSUB AppendByte
       CASE 2 ' Alt-M  Append ASCII string
          GOSUB AppendASCII
       CASE 3 ' Alt-R  Redraw screen
          CALL MultiFileFunction(2)
          COLORf Plain
          ScreenDrawn = True
          CALL DisplayScreen
          GOSUB RestoreCurrentFile
          GOSUB RedrawScreen2
          Call restorehilightbytes
       CASE 4 ' Alt-U  Undo last byte
          GOSUB UndoByte
       CASE 5 ' Alt-Z  Undo All bytes
          GOSUB UndoAll
       END SELECT
    End if
 CASE 5
    If FileLength Then
       SELECT CASE CurrentMenuSelection
       CASE 1 ' Alt-J  Jump to byte
          GOSUB JumpByte
       CASE 2 ' Alt-L  Jump to page
          GOSUB JumpPage
       END SELECT
    End if
 CASE 6
    If FileLength Then
       SELECT CASE CurrentMenuSelection
       CASE 1 ' Alt-P  HEX Screen Print
          GOSUB PrintScreen
       CASE 2 ' Alt-T  HEX File Print
          GOSUB PrintFile
       END SELECT
    End if
 CASE 7
    If FileLength Then
       SELECT CASE CurrentMenuSelection
       CASE 1 ' Alt-K  Search for string
          GOSUB SearchASCII
       CASE 2 ' Alt-S  Search for bytes
          GOSUB SearchBytes
       END SELECT
    End if
 END SELECT
 ' reset mouse activity.
 CALL SMouse
 GOSUB RestorePosition
 Call locatecursor
 GOTO StartLoop

REM Long filename routines follow:

' determine length of file.
GetFileLength:
 FileLength = False
 InregsX.AX = &H4202
 InregsX.BX = Handle
 InregsX.CX = &H0
 InregsX.DX = &H0
 CALL InterruptX(&H21, InregsX, OutregsX)
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    RETURN
 END IF
 ' check signed bit.
 IF OutregsX.AX < 0 THEN
    Low = CDBL(OutregsX.AX + 65536)
 ELSE
    Low = CDBL(OutregsX.AX)
 END IF
 ' check signed bit.
 IF OutregsX.DX < 0 THEN
    High = CDBL(OutregsX.DX + 65536)
 ELSE
    High = CDBL(OutregsX.DX)
 END IF
 ' calculate file length.
 FileLength = High * &H10000 + Low
 RETURN

' close all files.
CloseAllFiles:
 FOR Var = 1 TO NumberFiles
    Handle = File(Var).Handle
    GOSUB CloseFile
 NEXT
 RETURN

' close file.
CloseFile:
 InregsX.AX = &H3E00
 InregsX.BX = Handle
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' open file based on windows or dos loaded.
'   read file attribute,
'      reset read-only bit,
'   create file if nonexistent,
'   append nul byte to new file,
'   reopen file.
' return ValidFile=True if open successful.
OpenFile:
 IF Windows.Detected THEN
    GOSUB OpenFile1
 ELSE
    GOSUB OpenFile2
 END IF
 RETURN

' open Windows file.
OpenFile1:
 ValidFile = False
 FileAttribute = False
 GOSUB GetWINAttribute
 ' can't read attribute of devices.
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    ' check file nonexistent.
    IF (OutregsX.AX) <> 2 THEN
       RETURN
    END IF
 END IF
 FileAttribute = OutregsX.CX
 ' reset read-only bit before opening file for read-write.
 IF (FileAttribute AND ReadOnlyBit) = ReadOnlyBit THEN
    GOSUB SetWINAttribute
 END IF
 GOSUB OpenWINFile
 IF (OutregsX.Flags AND &H1) = &H0 THEN
    ValidFile = True
    RETURN
 END IF
 ' check file nonexistent.
 IF (OutregsX.AX) <> 2 THEN
    RETURN
 END IF
 GOSUB GetFilename
 GOSUB CreateWinFile
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    RETURN
 END IF
 GOSUB AppendFile
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    RETURN
 END IF
 GOSUB CloseFile
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    RETURN
 END IF
 GOSUB OpenWINFile
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    RETURN
 END IF
 FileAttribute = False
 ValidFile = True
 GOSUB ParseNetPath
 GOSUB ShortFilename
 RETURN

' open DOS file.
OpenFile2:
 ValidFile = False
 FileAttribute = False
 GOSUB GetDOSAttribute
 ' can't read attribute of devices.
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    ' check file nonexistent.
    IF (OutregsX.AX) <> 2 THEN
       RETURN
    END IF
 END IF
 FileAttribute = OutregsX.CX
 ' reset read-only bit before opening file for read-write.
 IF (FileAttribute AND ReadOnlyBit) = ReadOnlyBit THEN
    GOSUB SetDOSAttribute
 END IF
 GOSUB OpenDOSFile
 IF (OutregsX.Flags AND &H1) = &H0 THEN
    ValidFile = True
    RETURN
 END IF
 ' check file nonexistent.
 IF (OutregsX.AX) <> 2 THEN
    RETURN
 END IF
 GOSUB GetFilename
 GOSUB CreateDOSFile
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    RETURN
 END IF
 GOSUB AppendFile
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    RETURN
 END IF
 GOSUB CloseFile
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    RETURN
 END IF
 GOSUB OpenDOSFile
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    RETURN
 END IF
 FileAttribute = False
 ValidFile = True
 GOSUB ParseNetPath
 RETURN

' check command line and create filename.
GetFilename:
 IF LEFT$(Filename, 2) <> "\\" THEN
    IF LEFT$(Filename, 1) = "\" THEN
       ASCIIZ = LEFT$(CURDIR$, 2) + RTRIM$(Filename) + CHR$(0)
    ELSE
       IF MID$(Filename, 2, 1) <> ":" THEN
          ASCIIZ = CURDIR$ + "\" + RTRIM$(Filename) + CHR$(0)
       END IF
    END IF
 END IF
 RETURN

' open file in windows.
OpenWINFile:
 InregsX.AX = &H716C
 InregsX.BX = &H2
 InregsX.CX = FileAttribute
 InregsX.DX = &H1
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.SI = VARPTR(ASCIIZ)
 InregsX.DI = &H1
 CALL InterruptX(&H21, InregsX, OutregsX)
 Handle = OutregsX.AX
 RETURN

' get file attribute.
GetWINAttribute:
 InregsX.AX = &H7143
 InregsX.BX = &H0
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' reset read-only bit.
SetWINAttribute:
 Attribute = (FileAttribute AND NOT ReadOnlyBit)
 InregsX.AX = &H7143
 InregsX.BX = &H1
 InregsX.CX = Attribute
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' open dos file.
OpenDOSFile:
 InregsX.AX = &H3D42
 InregsX.CX = &H27
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)
 Handle = OutregsX.AX
 RETURN

' get file attribute.
GetDOSAttribute:
 InregsX.AX = &H4300
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' reset read-only bit.
SetDOSAttribute:
 Attribute = (FileAttribute AND NOT ReadOnlyBit)
 InregsX.AX = &H4301
 InregsX.CX = Attribute
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' create new file in windows.
CreateWinFile:
 InregsX.AX = &H716C
 InregsX.BX = &H2
 InregsX.CX = &H0
 InregsX.DX = &H10
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.SI = VARPTR(ASCIIZ)
 InregsX.DI = &H1
 CALL InterruptX(&H21, InregsX, OutregsX)
 Handle = OutregsX.AX
 RETURN

' create new dos file.
CreateDOSFile:
 InregsX.AX = &H3C00
 InregsX.CX = &H0
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)
 Handle = OutregsX.AX
 RETURN

' write a nul byte to file.
AppendFile:
 FileByte = CHR$(0)
 Call writefile
 RETURN

' write byte block to file.
WriteBlockFile:
 InregsX.AX = &H4000
 InregsX.BX = Handle
 InregsX.CX = 32767
 InregsX.DS = VARSEG(BlockByte)
 InregsX.DX = VARPTR(BlockByte)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' get netpath from filename
ParseNetPath: ' \\serv1\c\filename.ext
 Netpath$ = Nul
 IF LEFT$(Filename, 2) = "\\" THEN
    Net1 = INSTR(3, Filename, "\")
    IF Net1 THEN
       Net2 = INSTR(Net1 + 1, Filename, "\")
       IF Net2 THEN
          Netpath$ = LEFT$(Filename, Net2 - 1)
       END IF
    END IF
 END IF
 RETURN

' conanicalize filename for display purposes.
ShortFilename:
 ' read 8.3 filename.
 IF Windows.Detected THEN
    InregsX.AX = &H7160
    InregsX.CX = &H8001
    InregsX.DS = VARSEG(ASCIIZ)
    InregsX.SI = VARPTR(ASCIIZ)
    InregsX.ES = VARSEG(ASCIIZ2)
    InregsX.DI = VARPTR(ASCIIZ2)
    CALL InterruptX(&H21, InregsX, OutregsX)
 ELSE
    InregsX.AX = &H6000
    InregsX.DS = VARSEG(ASCIIZ)
    InregsX.SI = VARPTR(ASCIIZ)
    InregsX.ES = VARSEG(ASCIIZ2)
    InregsX.DI = VARPTR(ASCIIZ2)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF

 ' store filename.
 IF (OutregsX.Flags AND &H1) = &H0 THEN
    Filename = ASCIIZ2
    Imbedded = INSTR(Filename, CHR$(0))
    IF Imbedded THEN
       Filename = LEFT$(Filename, Imbedded - 1)
    END IF
 END IF

 ' store 64-byte filename.
 ShortFilename = Filename
 CurrentNetPath = NetPath$

 ' conanicalize 8.3 filename.
 Filename = Conanicalize$(Filename)
 RETURN

' restore all read-only attributes.
ResetAllAttributes:
 FOR Var = 1 TO NumberFiles
    ' reset file attribute.
    ASCIIZ = File(Var).ASCIIZ
    FileAttribute = File(Var).FileAttribute
    GOSUB ResetAttribute
 NEXT
 RETURN

' restore read-only attribute.
ResetAttribute:
 IF (FileAttribute AND ReadOnlyBit) = ReadOnlyBit THEN
    IF Windows.Detected THEN
       GOSUB ResetWINAttribute
    ELSE
       GOSUB ResetDOSAttribute
    END IF
 END IF
 RETURN

' restore windows read-only attribute.
ResetWINAttribute:
 InregsX.AX = &H7143
 InregsX.BX = &H1
 InregsX.CX = FileAttribute
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' restore DOS read-only attribute.
ResetDOSAttribute:
 InregsX.AX = &H4301
 InregsX.CX = FileAttribute
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' run DOS command in shell.
DoDOSCommand:
 Call clearstatus
 PRINTf "Enter DOS command: "
 LINE INPUT InputString$
 IF LEN(InputString$) THEN
    CALL MultiFileFunction(2)
    CALL DosCommand(InputString$)
    ScreenDrawn = True
    CALL DisplayScreen
    GOSUB RestoreCurrentFile
    GOSUB RedrawScreen2
    Call restorehilightbytes
 END IF
 RETURN

REM Mouse routines follow:

' move mouse cursor for mouseover.
MoveMouse:
 ' check mouse boundaries.
 IF Mouse.Row = 1 THEN
    NewMenuSelection = False
    SELECT CASE Mouse.Column
    CASE 6 TO 9 ' File
       NewMenuSelection = 1
    CASE 16 TO 21 ' Charts
       If FileLength Then
          NewMenuSelection = 2
       End if
    CASE 26 TO 29 ' Dump
       If FileLength Then
          NewMenuSelection = 3
       End if
    CASE 36 TO 39 ' Edit
       If FileLength Then
          NewMenuSelection = 4
       End if
    CASE 46 TO 49 ' Jump
       If FileLength Then
          NewMenuSelection = 5
       End if
    CASE 56 TO 60 ' Print
       If FileLength Then
          NewMenuSelection = 6
       End if
    CASE 64 TO 69 ' Search
       If FileLength Then
          NewMenuSelection = 7
       End if
    END SELECT
    IF NewMenuSelection > False THEN
       IF NewMenuSelection <> CurrentMenu THEN
          IF CurrentMenu > False THEN
             ' remove hilight menu tab.
             CALL HMouse
             COLORf2 White, 0
             CALL DisplayTab(CurrentMenu)
             CALL SMouse
          END IF
       END IF
       CurrentMenu = NewMenuSelection
       CurrentMenuSelection = 1
    END IF
    ' hilight menu tab.
    IF CurrentMenu > False THEN
       CALL HMouse
       COLORf2 White, 1
       CALL DisplayTab(CurrentMenu)
       CALL SMouse
    END IF
    Call locatecursor2
    RETURN
 END IF
 ' check mouse position in screen editing area.
 IF Mouse.Row > 3 AND Mouse.Row < 20 THEN
    IF Mouse.Column > 5 AND Mouse.Column < 50 THEN
       ' check screen character.
       VarX = SCREEN(Mouse.Row, Mouse.Column)
       ' reset position and return.
       IF VarX = 32 THEN ' at a space.
          GOSUB RestorePosition
          RETURN
       END IF
       ' get new position and reset there.
       IF VarX <> 32 THEN ' not a space.
          IF Old.Mouse.Row > False AND Old.Mouse.Column > False THEN
             Old.Value = False
             IF Old.Mouse.Row = PageRow + 3 THEN
                IF Old.Mouse.Column = Column + 5 OR Old.Mouse.Column = Column + 6 THEN
                   Old.Value = True
                END IF
             END IF
             IF Old.Value = False THEN
                GOSUB MoveOldPosition
             ELSE
                GOSUB RestoreOldPosition
             END IF
          END IF
          GOSUB MoveNewPosition
          RETURN
       END IF
    END IF
    ' check boundary edges.
    IF Mouse.Column = 5 OR Mouse.Column = 50 THEN
       GOSUB RestorePosition
       RETURN
    END IF
 END IF
 ' restore position.
 GOSUB RestorePosition
 Call locatecursor2
 RETURN

' restores old mouse position.
MoveOldPosition:
 NewPosition = CalculatePosition4#
 TempPosition3 = NewPosition
 CALL CalculatePosition2
 Column2 = CalculateColumn2
 GOSUB CheckMousePosition
 IF MouseArea = False THEN
    CALL HMouse
    COLORf White
    LOCATEf PageRow2 + 3, Column2 + 5, 0
    VarX = SCREEN(PageRow2 + 3, Column2 + 5)
    PRINTf CHR$(VarX)
    LOCATEf PageRow2 + 3, Column2 + 6, 0
    VarX = SCREEN(PageRow2 + 3, Column2 + 6)
    PRINTf CHR$(VarX)
    CALL SMouse
 END IF
 COLORf2 Plain, 0
 RETURN

' restores original mouse position.
RestoreOldPosition:
 SeekPosition = FilePosition
 Call lseekfile
 Call readfile
 FileByte = Buffer
 ByteValue = ASC(FileByte)
 Column = CalculateColumn
 GOSUB CheckMousePosition2
 IF MouseArea = False THEN
    CALL HMouse
    COLORf Yellow
    LOCATEf PageRow + 3, Column + 5, 0
    PRINTf RIGHT$("00" + HEX$(ByteValue), 2)
    CALL SMouse
 END IF
 COLORf Plain
 RETURN

' moves to new mouse position.
MoveNewPosition:
 NewPosition = CalculatePosition3#
 FilePosition2 = NewPosition
 TempPosition3 = NewPosition
 CALL CalculatePosition2
 Column2 = CalculateColumn2
 GOSUB CheckMousePosition
 IF MouseArea = False THEN
    CALL HMouse
    COLORf2 White, 1
    LOCATEf PageRow2 + 3, Column2 + 5, 0
    VarX = SCREEN(PageRow2 + 3, Column2 + 5)
    PRINTf CHR$(VarX)
    LOCATEf PageRow2 + 3, Column2 + 6, 0
    VarY = SCREEN(PageRow2 + 3, Column2 + 6)
    PRINTf CHR$(VarY)
    CALL SMouse
 END IF
 COLORf2 Plain, 0
 IF Mouse.Row > 3 AND Mouse.Row < 20 THEN
    IF Mouse.Column > 5 AND Mouse.Column < 50 THEN
       Old.Mouse.Row = Mouse.Row
       Old.Mouse.Column = Mouse.Column
    END IF
 END IF
 AsciiValue2 = VAL("&H" + CHR$(VarX) + CHR$(VarY))

 ' store old values.
 StoreValue1# = FilePosition
 StoreValue2% = AsciiValue2
 ' reset to mouseover values.
 FilePosition = FilePosition2
 AsciiValue = AsciiValue2
 ' display mouseover position.
 Call displayfilename
 ' restore old values.
 FilePosition = StoreValue1#
 AsciiValue = StoreValue2%
 RETURN

' restore screen position.
RestorePosition:
 IF Old.Mouse.Row > 3 AND Old.Mouse.Row < 20 THEN
    IF Old.Mouse.Column > 5 AND Old.Mouse.Column < 50 THEN
       VarX = SCREEN(Old.Mouse.Row, Old.Mouse.Column)
       IF VarX <> 32 THEN
          NewPosition = CalculatePosition4#
          TempPosition3 = NewPosition
          CALL CalculatePosition2
          Column2 = CalculateColumn2
          IF CopyPositionStart = False THEN
             GOTO RestoreMouseByte
          END IF
          IF CopyPositionStart > False THEN
             IF NewPosition >= CopyPositionStart THEN
                IF NewPosition <= CopyPositionEnd THEN
                   RETURN
                END IF
             END IF
          END IF
          GOTO RestoreMouseByte
       END IF
    END IF
 END IF
 RETURN

' check mouse position in hilighted area.
CheckMousePosition:
 MouseArea = False
 IF CopyPositionStart > False THEN
    IF TempPosition3 >= CopyPositionStart THEN
       IF TempPosition3 <= CopyPositionEnd THEN
          MouseArea = True
       END IF
    END IF
 END IF
 RETURN

' check mouse position in hilighted area.
CheckMousePosition2:
 MouseArea = False
 IF CopyPositionStart > False THEN
    IF FilePosition >= CopyPositionStart THEN
       IF TempPosition3 <= CopyPositionEnd THEN
          MouseArea = True
       END IF
    END IF
 END IF
 RETURN

' display hilighted mouse position byte.
RestoreMouseByte:
 CALL HMouse
 COLORf2 White, 1
 LOCATEf PageRow2 + 3, Column2 + 5, 0
 VarX = SCREEN(PageRow2 + 3, Column2 + 5)
 PRINTf CHR$(VarX)
 LOCATEf PageRow2 + 3, Column2 + 6, 0
 VarY = SCREEN(PageRow2 + 3, Column2 + 6)
 PRINTf CHR$(VarY)
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' process left mouse button click.
MouseButton1:
 ' stop program.
 IF Mouse.Row = 3 AND Mouse.Column = 77 THEN
    CALL HMouse
    GOTO StopLabel
 END IF
 ' help screen.
 IF Mouse.Row = 4 AND Mouse.Column = 77 THEN
    GOSUB DisplayHelp
    RETURN
 END IF
 ' page up.
 IF Mouse.Row = 4 AND Mouse.Column = 52 THEN
    IF FileLength THEN
       GOSUB PageUp
    END IF
    RETURN
 END IF
 ' page down.
 IF Mouse.Row = 20 AND Mouse.Column = 52 THEN
    IF FileLength THEN
       GOSUB PageDown
    END IF
    RETURN
 END IF
 ' line up.
 IF Mouse.Row = 5 AND Mouse.Column = 52 THEN
    IF FileLength THEN
       GOSUB CursorUp
    END IF
    RETURN
 END IF
 ' line down.
 IF Mouse.Row = 19 AND Mouse.Column = 52 THEN
    IF FileLength THEN
       GOSUB CursorDown
    END IF
    RETURN
 END IF
 ' select drop down menu.
 IF Mouse.Row = 1 THEN
    SELECT CASE Mouse.Column
    CASE 6 TO 9 ' File
       NewMenuSelection = 1
    CASE 16 TO 21 ' Charts
       NewMenuSelection = 2
    CASE 26 TO 29 ' Dump
       NewMenuSelection = 3
    CASE 36 TO 39 ' Edit
       NewMenuSelection = 4
    CASE 46 TO 49 ' Jump
       NewMenuSelection = 5
    CASE 56 TO 60 ' Print
       NewMenuSelection = 6
    CASE 64 TO 69 ' Search
       NewMenuSelection = 7
    CASE ELSE
       RETURN
    END SELECT
    IF NewMenuSelection <> CurrentMenu THEN
       IF CurrentMenu > False THEN
          CALL HMouse
          ' remove hilight menu tab.
          COLORf2 White, 0
          CALL DisplayTab(CurrentMenu)
          CALL SMouse
       END IF
    END IF
    CurrentMenu = NewMenuSelection
    CurrentMenuSelection = 1
    CALL HMouse
    ' hilight menu tab.
    COLORf2 White, 1
    CALL DisplayTab(CurrentMenu)
    CALL SMouse
    ' check file.
    IF FileLength = False THEN
       IF CurrentMenu > 1 THEN
          RETURN
       END IF
    END IF
    ' jump to file menu.
    CALL HMouse
    GOTO Menu2
 END IF
 ' move to new byte.
 IF Mouse.Row > 3 AND Mouse.Row < 20 THEN
    IF Mouse.Column > 5 AND Mouse.Column < 50 THEN
       VarX = SCREEN(Mouse.Row, Mouse.Column)
       IF VarX = 32 THEN
          GOSUB RestorePosition
          RETURN
       END IF
       IF VarX <> 32 THEN
          NewPosition = CalculatePosition3#
          Call clearpagebyte
          FilePosition = NewPosition
          CALL CalculatePosition1
          Call displaypagebyte
          Call displayfilename
          RETURN
       END IF
    END IF
 END IF
 RETURN

' process right mouse button.
MouseButton2:
 ' move to new byte and edit.
 IF Mouse.Row > 3 AND Mouse.Row < 20 THEN
    IF Mouse.Column > 5 AND Mouse.Column < 50 THEN
       VarX = SCREEN(Mouse.Row, Mouse.Column)
       IF VarX = 32 THEN
          GOSUB RestorePosition
          RETURN
       END IF
       IF VarX <> 32 THEN
          NewPosition = CalculatePosition3#
          Call clearpagebyte
          FilePosition = NewPosition
          CALL CalculatePosition1
          Call displaypagebyte
          Call displayfilename
          GOSUB ChangeHexValue
          RETURN
       END IF
    END IF
 END IF
 RETURN

' reset hilight bytes for mouse.
ResetMouseBytes:
 IF CopyPositionStart = False THEN
    Call locatecursor2
    RETURN
 END IF
 Call resetbytes
 Call clearpagebyte
 Call displaypagebyte
 RETURN

' critical error trap.
Error.Routine:
 ' check error return type.
 ErrorTrap = ERR
 IF Check.Disk THEN
    Disk.Ready = ERR
    RESUME NEXT
 END IF
 ' check screen.
 IF ScreenDrawn THEN
    CLS
 END IF
 ScreenDrawn = False
 ' display error message.
 COLORf White
 LOCATEf Csrlin, 1, 0
 PRINTf "Hex Editor Main " + Version + " " + Release + " critical error trap:"
 ' display error.
 COLORf Yellow
 LOCATEf Csrlin+1, 1, 0
 CALL DisplayCriticalError(ErrorTrap)
 ' display error prompt.
 COLORf Green
 LOCATEf Csrlin+1, 1, 0
 PRINTf "Press R(etry), C(ontinue), Q(uit), A(bort):"
 LOCATEf Csrlin, 44, 1
 ' get keypress.
 DO
    ErrorRespond$ = Nul
    DO
       ErrorRespond$ = INKEY$
       IF LEN(ErrorRespond$) THEN
          EXIT DO
       END IF
    LOOP
    ' parse key.
    SELECT CASE LCASE$(ErrorRespond$)
    CASE "r"
       PRINTf "r"
       LOCATEf Csrlin+1, 1, 0
       RESUME
    CASE "c"
       PRINTf "c"
       LOCATEf Csrlin+1, 1, 0
       RESUME NEXT
    CASE "q"
       PRINTf "q"
       LOCATEf Csrlin+1, 1, 0
       IF CurrentFile = False THEN
          GOSUB RedrawScreen
          RESUME NEXT
       END IF
       RESUME TopProgram
    CASE "a"
       PRINTf "a"
       LOCATEf Csrlin+1, 1, 0
       EXIT DO
    END SELECT
 LOOP

 ' end of program.
 GOSUB CloseAllFiles
 GOSUB ResetAllAttributes

' anything goes here stops program.
StopProgram:
 COLORf2 7, 0

 ' restore current drive.
 InregsX.AX = &HE00
 InregsX.DX = Drive.Number ' 0=a, 1=b, ..
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' check windows dos.
 IF Windows.Detected THEN
    ' restore current directory.
    InregsX.AX = &H713B
    InregsX.DS = VARSEG(Directory.ASCIIZ)
    InregsX.DX = VARPTR(Directory.ASCIIZ)
    CALL InterruptX(&H21, InregsX, OutregsX)
 ELSE
    ' restore current directory.
    InregsX.AX = &H3B00
    InregsX.DS = VARSEG(Directory.ASCIIZ)
    InregsX.DX = VARPTR(Directory.ASCIIZ)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 END

' terminal error exits here.
Error.Exit:
 ' display error.
 COLORf2 White, 0
 CLS
 PRINTf "Hex Editor " + Version + " " + Release + " critical error trap:"
 ' display error and exit.
 COLORf Yellow
 LOCATEf Csrlin+1, 1, 0
 CALL DisplayCriticalError(ErrorTrap)
 COLORf Green
 LOCATEf Csrlin+1, 1, 0
 PRINTf "Close Hexedit processes, Check TEMP variables, .CFG file,"
 LOCATEf Csrlin+1, 1, 0
 PRINTf "or DOS file handles, then restart."
 COLORf Plain
 END

 REM End-of-subprogram. I want 2 black siamese cats.
