.model tiny
.186
.code
org 100h

start:      mov   ax, 13h           ; set video mode 13h (320x200x256)
            int   10h

            mov   ds, ax            ; seed random number with clock timer,
            xchg  bx, ax            ; also set bx to 13h which is a small
            mov   ax, ds:[033Ch]    ; enough value that the loop below will
                                    ; cover almost the whole screen
            mov   dx, cs            ; ds = segment of the working buffer
            add   dh, 10h           ; here we use the 64K segment immediately
            mov   ds, dx            ; following the code segment

            push  0A000h            ; es = video memory (at 0A000h)
            pop   es
                                    ; random number generation loop:
rand:       imul  ax, 9421          ;  generate random number using linear
            inc   ax                ;  congruential formula 9421*n+1
            xor   [bx], ah          ;  xor into this byte in the buffer, then
            inc   bx                ;  loop back to do next byte
            jnz   rand              ;  bits other than the low bit are set,
                                    ;  but this will only mess up the screen
                                    ;  for the first few frames

            lea   di, [si-322]      ; di = si - 322, it doesn't matter what
                                    ; si contains because this is a byte loop

life:       xor   ah, ah            ; pixel counting loop:
            mov   bx, 3             ; 3 iterations
count:      add   ah, [di+bx]       ;  add in the top pixel in this column,
            add   ah, [si+bx-2]     ;  then the middle one, and finally
            add   ah, [si+bx+318]   ;  the bottom pixel; then move to the
            dec   bx                ;  next column and loop until bx is zero
            jnz   count

            mov   al, [si]          ; al = this pixel
            stosb                   ; write this pixel to the screen
                                    ; it doesn't matter that di <> si

            and   ah, 7Fh           ; mask off high bit
            cmp   ax, 0401h         ; 4 neighbors + itself = stay
            je    cset
            cmp   ah, 3             ; 3 neighbors + itself = birth
            jne   cdone             ; all others = die

cset:       or    byte ptr [si], 80h; new pixel value = 1
cdone:      shr   byte ptr [di], 7  ; clear previous pixel
            inc   si                ; move to the next pixel, and loop
            jnz   life              ; jump fails once each frame...

            mov   ah, 1             ; check for keypress
            int   16h
            jz    life              ; loop while no key has been pressed

            mov   ax, 3             ; restore text mode
            int   10h
            ret                     ; return to dos

end start
