.model tiny
.186
.code
org 100h

start:      mov   ax, 13h           ; set video mode 13h (320x200x256)
            int   10h

            mov   ds, ax            ; seed random number with clock timer,
            xchg  bx, ax            ; also set bx to 13h which is a small
            mov   ax, ds:[033Ch]    ; enough value that the loop below will
                                    ; cover almost the whole screen
            mov   dx, cs            ; ds = segment of the working buffer
            add   dh, 10h           ; here we use the 64K segment immediately
            mov   ds, dx            ; following the code segment

            push  0A000h            ; es = video memory (at 0A000h)
            pop   es
                                    ; random number generation loop:
rand:       imul  ax, 9421          ;  generate random number using linear
            inc   ax                ;  congruential formula 9421*n+1
            xor   [bx], ah          ;  xor into this byte in the buffer, then
            inc   bx                ;  loop back to do next byte
            jnz   rand

; The clearing loop comes first, so only the high bit from the random numbers
; will be used.

life:       xor   si, si            ; si, di = 0
            xor   di, di
                                    ; clearing loop:
clear:      mov   al, [si]          ;  load this byte
            shr   al, 7             ;  shift down, setting new pixel value
            mov   [si], al          ;  store in buffer
            stosb                   ;  write to screen
            inc   si                ;  loop back to do next byte
            jnz   clear
                                    ; calculation loop:
calc:       xor   al, al            ;  pixel counting loop:
            mov   bx, 3             ;  3 iterations
count:      add   al, [si+bx-322]   ;   add in the top pixel in this column,
            add   al, [si+bx-2]     ;   then the middle one, and finally
            add   al, [si+bx+318]   ;   the bottom pixel; then move to the
            dec   bx                ;   next column and loop until bx is zero
            jnz   count

            and   al, 7Fh           ;  mask off high bit
            cmp   al, 4             ;  4 neighbors + itself = stay
            je    stay
            cmp   al, 3             ;  3 neighbors + itself = birth
            jne   cdone             ;  all others = die

birth:      mov   al, 80h           ;  new pixel value = 1
            jmp   cset

stay:       mov   al, [si]          ;  new pixel value = old pixel value
            shl   al, 7

cset:       or    [si], al          ;  set new pixel value
cdone:      inc   si                ;  loop back to do next byte
            jnz   calc

            mov   ah, 1             ; check for keypress
            int   16h
            jz    life              ; loop while no key has been pressed

            mov   ax, 3             ; restore text mode
            int   10h
            ret                     ; return to dos

end start
