
{ Input and Output procedures follow.  Interface to standard I/O included. }

TYPE 
     regpack = record    { used for Standard I/O DOS calls }
                    ax,bx,cx,dx,bp,si,di,ds,es,flg : integer
               end ;
     ary = byte;
     xpt = record
               case integer of
                     1: (ptx : ^ary) ;
                     2: (qq,rr :integer)
                  end;
     maxstr = string[255];
VAR
 register : regpack;
 xx : ary;
 here : xpt;
 b: byte;           

procedure putstdout(wr: byte);

{  Procedure to put the next byte of Standard Output out to
   MS DOS 2.x Standard Output file. }

   begin
     here.ptx := addr(xx);
     xx  := wr;
     register.ds := here.rr;
     register.dx := here.qq;
     register.cx := 1;
     register.bx := 1;
     register.ax := $4000;
     intr($21,register);
   end;

procedure getstdin(var ip: byte);
{
    Procedure to get next byte of input from DOS 2.0, 2.1
    Standard Input file.  This filter uses only ascii characters
    (maximum decimal value 127) so 255 was chosen as the
    end-of-input flag.
}
begin
     here.ptx := addr(xx);
     register.ds := here.rr;
     register.dx := here.qq;
     register.cx := 1;
     register.bx := 0;
     register.ax := $3F00;
     intr($21,register);
     if register.ax = 0 then ip:= 255;
     if register.ax <>0 then ip:= xx;
end;

function getline(var lin: maxstr): boolean;
{
    Reads a line from the Standard Input file and loads it
    into the string LIN.  The end of line identifier ENDSTR
    is appended to each line.  Unprintable characters are
    ignored.
}
begin
    getline:=false;
    lin:='';
    repeat
       getstdin(b);
       case b of
               32..125: if length(lin)<254 then lin:=lin+chr(b);
               eof_num: exit;
           end; {case}
    until b=eoln1_num;
    lin:=lin+ENDSTR;
    getline:=true;
end;

procedure putline(lin: maxstr);
{
   Feeds a line to Standard Output byte by byte, adding
   <carrage return> <line feed> at the end.
}
var i: integer;
begin
     i:=1;
     while lin[i]<>ENDSTR do
       begin
          putstdout( ord(lin[i]) );
          i:=i+1;
       end;
     putstdout(eoln1_num);
     putstdout(eoln2_num);
end;

function getarg(var arg: maxstr) : boolean;
{
   Command line parameters are returned in string ARG.
   Spaces within the Regular Expression pattern are
   preserved, but the Turbo parameter functions ignore
   leading and trailing spaces.
}
var i, arg_num: integer;
begin
  getarg:=false;  arg:='';  arg_num:=paramcount;
  if arg_num=0 then exit
      else
        for i:=1 to arg_num do
          begin                   
            arg:=arg+paramstr(i); 
            if (arg_num>1) and (i<arg_num) then arg:=arg+' ';
          end;
  getarg:=true;
end;
