*AUTHLBL.PRG - Program to print labels for all authors who have 
*               articles in a given issue, suppressing duplicates.

* establish environment
SET TALK OFF            && don't echo status changes to screen
SET SAFETY OFF          && overwrite temp files, don't ask user if ok
SET PRINT OFF           && make sure printer is off
SET UNIQUE OFF          && index creation allows duplicate entries
MVOL=0                  && preset memory variables: volume and number
MNUM=0

DO WHILE .T.    && loop here if unknown issue or user wants to repeat
  CLEAR                 && clear screen, get volume, number from user
  @ 10,10 SAY "Enter Volume and Number for labels (0,0 to quit):"
  @ 12,20 SAY "Volume" GET MVOL PICTURE "9"
  @ 12,COL()+4 SAY "Number" GET MNUM PICTURE "99"
  READ                  && collect the data from the GETs

  IF MVOL+MNUM=0        && user entered zeros to quit
    EXIT
  ENDIF

  @ 15,10 SAY "Sorting the author names and culling duplicates."
  SELECT 1              && display comfort message; open article file
  USE ARTICLE INDEX ARTICLE             && index is volume and number 
  SEEK STR(MVOL,1,0)+STR(MNUM,2,0)      && position to start of issue

  IF .NOT. FOUND()                      && no such issue, get another
    @ 15,10 SAY "Cannot find issue. Please reenter volume and number."
    WAIT                		&& pause for read of message
    LOOP
  ENDIF

  *  Copy the primary author names to temp1.dbf  (this is very fast
  *  because the SEEK got us to first record immediately, and the 
  *  COPY will stop as soon as the issue number changes.
  COPY TO TEMP1 REST FIELDS AUTHOR_LN, AUTHOR_FN WHILE MNUM=NUMBER
  SEEK STR(MVOL,1,0)+STR(MNUM,2,0)     && Position to start of issue

  *  Now get the coauthors (if any) to temp2.  Use delimited format 
  *  so we can append names to temp1 without conflict in field names
  COPY TO TEMP2 REST FIELDS COAUTHORLN, COAUTHORFN WHILE MNUM=NUMBER ;
    FOR LEN(TRIM(COAUTHORLN+COAUTHORFN)) > 0 DELIMITED

  *  Get all the authors together by appending the coauthors to temp1.
  USE TEMP1                     &&  open temp1 in work area 1
  APPEND FROM TEMP2 DELIMITED   &&  add in the coauthors

  *  Create a unique index.  This will eliminate duplicate labels.
  INDEX ON UPPER(AUTHOR_LN+AUTHOR_FN) TO TEMP1 UNIQUE
  SELECT 2                   && open the author file in work area 2
  USE AUTHOR INDEX AUTHOR    && key is uppercase last+first name
  SELECT 1                   && set relationship into author file key
  SET RELATION TO UPPER(AUTHOR_LN+AUTHOR_FN) INTO AUTHOR

  * Now print the labels.  The parameter "SAMPLE" prints labels of
  * asterisks for alignment. The label generation form looks up
  * all data (author name and address) from the author file.  The
  * temp1 file of uppercase names simply selects and points to the 
  * appropriate author record for the label. Label form contents are:
  *   Line 1:  author->AUTHOR_FN, author->AUTHOR_LN
  *   Line 2:  author->ADDRESS
  *   Line 3:  TRIM(author->CITY) + ",", author->STATE, author->ZIP
  * dBASE III PLUS automatically suppresses blank lines within a label 
  * and formats to the number of lines on the specified label size.  
  * A comma between fields on a label line causes dBASE to trim the 
  * first field of trailing blanks and insert one blank between fields.
  * A sample label:
  *             John Brown
  *             3559 South 24 St.
  *             Stanleyford, IN 76828
  *
  LABEL FORM ARTLABEL SAMPLE TO PRINT

ENDDO   && back for another issue.  
CLOSE DATA
RETURN
