program mdp6;

{Program to accompany article in issue #10 of the Pascal NewsLetter.       }
{Author: Mitch Davis, (3:634/384.6) +61-3-890-2062.                        }

{After reading the file specified on the command line, this program will   }
{instantly jump to any line (up to a VERY large number) you choose.        }
{Note that this program uses the BigArray unit featured elsewhere in this  }
{issue of PNL.  This is how it can access such HUGE files.  It uses the    }
{same "array of offsets" techniques that previous programs have.           }

{$R-,S-,N+,M 16384,0,0}

uses Crt, Textutl2, DosMem, BigArray;

const TBuffSize = 20; {k}
      ScreenLen = 24;
      LineCount:word = 0;

type TBuffPtr  = ^TBuffType; {Text buffer stuff}
     TBuffType = array [1..TBuffSize*1024] of byte; {20k text buffer}

var MaxLines:longint;
    LineBank:BigArray.BigDOSArray; {This is the array object that holds}
                                   {the offsets to the start of lines  }
    TBuff:TBuffPtr;
    LinePtr:^longint; {The linebank object will set this with a pointer to}
                      {where that object is stored.                       }
    Buffer:string;
    Loop,LNum:word;
    f:text;

procedure PrLn (var s:string);

begin
  writeln (copy (s,1,79));
end;

begin
  {Set up text buffer}
  TBuff := ptr (DosMem.Alloc (TBuffSize * 64),0); { * 64 turns K into paras}
  {Initialise the line arrays}
  with linebank do begin
    SetElemSize (sizeof (longint));
    MaxLines := GetMaxSize;
    writeln ('There''s room for ',MaxLines,' lines in memory.');
    Init (MaxLines);
  end;
  writeln ('Reading...');
  assign (f,paramstr (1)); SetTextBuf (f,TBuff^); reset (f);
  LineCount := 0;
  while not (eof (f) or (LineCount = MaxLines)) do begin
    inc (LineCount);
    write (LineCount,#13);
    LinePtr := LineBank.Elem (LineCount);
    LinePtr^ := TextFilePos (f);
    readln (f);
  end;
  writeln;

  clrscr;
  repeat
    if Linecount = 0 then begin
      writeln ('File is empty.');
      DosMem.Free (seg(TBuff^)); {not really needed, but here for looks.}
      LineBank.Done;
      halt;
    end;
    write ('Enter a line number (1-',LineCount,', 0 to quit): ');
    readln (lnum);
    if (lnum > 0) and (lnum <= LineCount) then begin
      clrscr;
      LinePtr := LineBank.Elem (Lnum);
      TextSeek (f,LinePtr^);
      loop := 0;
      repeat
        readln (f,buffer);
        prLn (buffer);
        inc (loop);
      until (loop = ScreenLen) or eof (f);
      repeat until keypressed;
    end;
  until lnum = 0;
  close (f);
  DosMem.Free (seg(TBuff^));
  LineBank.Done;
end.

