/*
	misc.c -- Random stuff

  Poor Man's Packet (PMP)
  Copyright (c) 1991 by Andrew C. Payne    All Rights Reserved.

  Permission to use, copy, modify, and distribute this software and its
  documentation without fee for NON-COMMERCIAL AMATEUR RADIO USE ONLY is hereby
  granted, provided that the above copyright notice appear in all copies.
  The author makes no representations about the suitability of this software
  for any purpose.  It is provided "as is" without express or implied warranty.

	April, 1990
	Andrew C. Payne
*/

/* ---- Includes ----- */
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "pmp.h"

/* ----- String Subroutines ----- */
/* sob(p)
	Given a character pointer, returns a pointer with blanks skipped.
*/
char *sob(char *s)
{
	while(*s && isspace(*s))
		s++;

	return s;
}

/* extract(s,p)
	Extracts from S into P, converts to lowercase.
*/
char *extract(char *s, char *p)
{
/* copy until hit a comma, end of string, or whitespace */
	while(*s && !isspace(*s) && *s != ',')
		*p++ = tolower(*s++);

	*p = '\0';

/* skip over commas */
	while(*s == ',')
		s++;

	return sob(s);
}

/* convert(dest, src)
	Given a string in the form:  "testing^M", copies the string to the
	destination, converting all control characters to their ASCII
	representations.

	Returns TRUE if error.
*/
int convert(char *dest, char *src)
{
	int	c;

	while(*src && *src != '\n') {
		if(*src != '^')
			*dest++ = *src++;
		else {
			if(src[1] == '^')
				c = '^';
			else {
				c = toupper(src[1]) - '@';
				if(c < 0 || c > ' ')
					return TRUE;
			}
			*dest++ = c;
			src += 2;
		}
	}
	*dest = '\0';
	return FALSE;
}

/* trim(s)
	Trims trailing white space (including newlines) from a string.
*/
void trim(char *s)
{
	char *p;

/* find end of string */
	p = s;
	while(*p)
		p++;

/* move backwards */
	while(p > s && isspace(p[-1]))
		p--;

	*p = '\0';
}

/* ----- Command Dispatcher ----- */

/* dispatch(s, funcs)
	Given a command string and a list of functions, dispatches to
	function handler with the remainder of the string.

	Returns FAIL if not found.
*/
int dispatch(char *s, struct param_cmd *pcmds)
{
	char	*p;
	char	c[80];

	p = extract(s,c);
	while(pcmds->cmd != NULL) {
		if(!strcmp(pcmds->cmd,c))
			return (pcmds->handler)(p);
		pcmds++;
	}
	return FAIL;
}

/* ----- EOL Converstion ----- */

/* eol_out(conv,s,l)
	Given a EOL convention code, a string and a length, converts a '\n'
	termintated string to the appropriate convention.
*/
void eol_out(int conv, char *s, int l)
{
	switch(conv) {
		case EOL_CR:
			while(l--) {
				if(*s == '\n')
					*s = '\r';
				s++;
			}
		case EOL_LF:
		default:
			/* no conversion */
			return;
	}
}

/* eol_in(conv,s,l)
	Given a EOL convention code, a string and a length, converts a string
	with the appropriate EOL convention to a '\n' terminated string.
*/
void eol_in(int conv, char *s, int l)
{
	switch(conv) {
		case EOL_CR:
			while(l--) {
				if(*s == '\r')
					*s = '\n';
				s++;
			}
		case EOL_LF:
		default:
			/* no conversion */
			return;
	}
}
