/*
	level2tx.c -- Level 2 transmit routines for PMP

  Poor Man's Packet (PMP)
  Copyright (c) 1991 by Andrew C. Payne    All Rights Reserved.

  Permission to use, copy, modify, and distribute this software and its
  documentation without fee for NON-COMMERCIAL AMATEUR RADIO USE ONLY is hereby
  granted, provided that the above copyright notice appear in all copies.
  The author makes no representations about the suitability of this software
  for any purpose.  It is provided "as is" without express or implied warranty.

	Andrew C. Payne
*/
/* ----- Includes ------ */
#include <stdio.h>
#include <alloc.h>
#include <mem.h>
#include "pmp.h"

/* SendAX25(packet)
	Given an AX25 packet, puts converts it to a byte stream and
	puts it into the TXQueue.

	Returns TRUE if error.
*/
int SendAX25(struct ax25_packet *p)
{
	struct ax25_level1	*t;		/* byte stream */
	byte	*q;				/* temp pointer */
	int	i;				/* counter */
	int	data;

/* compute length of byte stream and allocate space */
	i = sizeof(struct ax25_addr)*2
			+ 3 + p->ndigis * 7 + p->dlen;

/* find frame type */
	switch(FrameType(p->cont)) {
		case I:
		case UI:
			data = TRUE;
			i++;			/* needs PID byte */
			break;
		default:
			data = FALSE;
	}

	t = malloc(i + sizeof(struct ax25_level1));
	t->len = i;

/* copy destination and source addresses into packet */
	memcpy(q = t->data,&p->dest,sizeof(struct ax25_addr));
	memcpy(q += sizeof(struct ax25_addr),&p->source,sizeof(struct ax25_addr));

/* set command/response mode */
	if(p->cmdresp == COMMAND)
		t->data[MAXCLEN] |= 0x80;
	else
		t->data[MAXCLEN + sizeof(struct ax25_addr)] |= 0x80;

/* copy digipeater path in, if necessary */
	q += sizeof(struct ax25_addr);
	if(p->ndigis) {
		for(i=0; i<p->ndigis; i++) {
			memcpy(q,&p->digis[i],sizeof(struct ax25_addr));
			q += sizeof(struct ax25_addr);
		}
	}

/* set the address extension bit on the last address byte */
	q[-1] |= 1;

/* copy in the control */
	*q++ = p->cont;

/* copy in the PID & data field, if I or UI packet */
	if(data) {
		*q++ = p->pid;
		memcpy(q,p->data,p->dlen);
	}

/* add the packet to the TX Queue */
	return TXQAdd(t);
}
