/* tagchange.c -- translator for use with Charon
	Copyright (C) 1992 Brad K. Clements, Clarkson University
	       All Rights Reserved.


*/

#include <ctype.h> 
#include <time.h>
#include <string.h>
#define	STANDALONE	0
#include "callback.h"
#include "tagvalue.h"

char	*stackinfo="$STACKSIZE:1024";

/* Usage:

	set a loadstring as follows:

	       	loadstring "[<tagname> [operation] <value>] ..."


	where tagname is a valid tag string from tagvalue.h

	operation is:

	       	= 	sets to value
		|	or's in numeric value
		&	ands's numeric value
		+	increment
		-	decrement

*/

int
main(int argc, char *argv[])
{
	int 	rc;
	char		ibuffer[128], *tagname, *tagvalue, *value, *op1;
	enum		Mode { TAG, OP1, VALUE, WORKING } mode;
	unsigned	long	nvalue, opvalue;

	mode = TAG;
	for(rc=1; rc < argc; rc++) {
	       	switch (mode) {
		       	int	ok = 1;

		   	case TAG :
				tagname = argv[rc];
			 	mode = OP1;
				break;
			case OP1 :		/* get operation */
				op1 = argv[rc];
			 	mode = VALUE;
				break;
			case VALUE :
			       	value = argv[rc];
			 	mode = WORKING;
			case WORKING :		/* fall through */
			       	tagvalue = getenv(tagname);
				if(tagvalue)
				       	nvalue = atol(tagvalue);
				else {
				       	nvalue = 0;
					fprintf(STDERR,"Unknown TagName %s\n",tagname);
				}
				opvalue = atol(value);

				switch (*op1) {
					case '=' :
					       	nvalue = opvalue;
					       	break;
					case '|' :
					       	nvalue |= opvalue;
					       	break;
					case '+' :
					       	nvalue += opvalue;
					       	break;
					case '&' :
					       	nvalue &= opvalue;
					       	break;
					default :
					        fprintf(STDERR,"Unknown Opcode %c\n",*op1);
					 	ok = 0;
				 }	/* end switch op */
				if(ok) {
					sprintf(ibuffer,"%s=%ld",tagname, nvalue);
					setenv(ibuffer);
				}
				mode = TAG;
	        }	/* end switch */
	}	/* end for */

      	return(RT_CHANGED_TAGS);	/* even if we didn't change the text, don't do banners */
}

