
/****************************************************************************
*   Function:    int sockoa(char *service, char *protocol, void (*func)())  *
*   Operation:   to open a sock, then listen for a connection from a client *
*   Returns:     the number of an accepted client socket, else -1 for error *
*   Parameters:  service, the name of a specific service                    *
*                protocol, the name of a specific protocol (tcp/udp)        *
*                func, the name of a local function to execute on accept    *
****************************************************************************/

void exit(int);
void sockoa_child_status();

#include <stdio.h>
#include <string.h>
#include <io.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <errno.h>
#include "sock_tk.h"

extern int errno;

/* library globals; available to calling program, if desired */

struct sockaddr_in sock_srvr_addr;
struct servent sock_srvr_info;
struct hostent sock_host_info;
int sockoa_fd = -1;

/* local globals; not available to calling program */

static int fd = -1, id = -1;

#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

void sockoa_dead_end()
{
  if( fd > 0 )
    close(fd);
  if( sockoa_fd > 0 )
    close(sockoa_fd);
  exit(1);
}

int sockoa(service, protocol, func)
  char *service, *protocol;
  void (*func) ();
{
  char msg[81];
  unsigned int i, len;
  int ch;
  struct servent *sp;
  struct hostent *hp;
  struct protoent *pp;

  signal(SIGINT, sockoa_dead_end);
  signal(SIGTERM, sockoa_dead_end);

  for (i = 0; i <= strlen(service); i++)	/* remove newlines */
    if (service[i] == '\n')
      service[i] = 0;
  for (i = 0; i <= strlen(protocol); i++)	/* remove newlines */
    if (protocol[i] == '\n')
      protocol[i] = 0;
  if ((sp = getservbyname(service, protocol)) == NULL) {
    sprintf(msg, "sockoa(): unknown service: %s/%s", service, protocol);
    socke(msg);
    return (-1);
  }
  sock_srvr_addr.sin_addr.s_addr = INADDR_ANY;
  sock_srvr_addr.sin_port = sp->s_port;

  pp = getprotobyname(protocol);
  if (protocol[0] == 't') {
    fd = socket(AF_INET, SOCK_STREAM, (int) pp->p_proto);
  } else {
    fd = socket(AF_INET, SOCK_DGRAM, (int) pp->p_proto);
  }
  if (fd < 0) {
    sprintf(msg, "sockoa(): can't create %s socket", protocol);
    socke(msg);
    return (-1);
  }
  if (bind(fd, (struct sockaddr_in *) & sock_srvr_addr,
	   sizeof(sock_srvr_addr)) < 0) {
    sprintf(msg, "sockoa(): can't connect to server");
    socke(msg);
    close(fd);
    return (-1);
  }
  if (listen(fd, 5) < 0) {
    sprintf(msg, "sockoa(): error received from listen() in server");
    socke(msg);
    sockoa_dead_end();
  }
  while (1) {
    len = sizeof(sock_srvr_addr);
    if ((sockoa_fd = accept(fd, (struct sockaddr_in *) & sock_srvr_addr,
			    &len)) < 0) {
      if( kbhit() ) {
        ch = getch();
        if( ch == 27 ) {
          sockoa_dead_end();
        }
      }
      if( errno == EINTR )
	continue;
      sprintf(msg, "sockoa(): error received from accept() in server");
      socke(msg);
      sockoa_dead_end();
    }
    (*func)();          /* these two lines alone are used */
    sockoa_dead_end();  /* by msdos instead of forking */
  }
}
