;;*****************************************************************************
;;                             if.inc           if.inc
;;*****************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;****************************************************************************
;;
;; if.inc is a module that describes in INTERFACE (IF).  An interface 
;; basicly is a description of a network card that is reasonably card
;; independant
;;
;; if.inc is the dispatcher for the if object.  Basicly all this module does
;; is look up the name in its database, and based on its name, call the 
;; correct routine for that card type (WD .. )
;;
;;****************************************************************************
;;
;; The functions provided by this file are
;;
;;   IF_DECLARE name, real_if, type
;;      IF_DECLARE makes the association between the IF object 'name' and
;;      the object 'real_if' which acutally supplies the routines.  'type'
;;      is the prefix for the real if (eg.  WD)
;;   
;;   IF_R_ACCESS_out_BX_CX_ES interface, no_packet
;;       IF_R_ACCESS waits for the next packet to come from the the board
;;       associated with 'interface' and returns a pointer to the begining of 
;;       an ethernet packet in BX:ES.  If there is no packet to read in, 
;;       this function jumps to 'no_packet'
;;       
;;   IF_R_FREE_const_BX_CX_BP_SI_DI_ES interface
;;       After the client is through processing the packet returned by 
;;       IF_R_ACCESS, IF_R_FREE must be called to inform 'interface' that the 
;;       memory that the packet was in can be reused for future packets.
;;
;;   IF_R_CONT_in_BX_CX_ES_const_BX_CX_DX_BP_SI_DI_ES name, ok
;;       IF_R_CONT determines if the packet returned by R_READ in BX:ES
;;       of length CX is continuous.  If it is it jumps to 'ok' otherwise
;;       it just returns
;;
;;   IF_W_ACCESS_in_CX_out_DI_ES_const_BX_CX_BP interface, no_buffer
;;       IF_W_ACCESS returns a pointer to an output buffer for a packet.  The 
;;       pointer is returned in DI:ES.  If the ouptut buffer is busy, this 
;;       routine jump to 'no_buffer'.  the output buffer is guarenteed to
;;       be at least min (CX, 1514) (the MTU for Ethernet - 4 byte checksum) 
;;       bytes long.
;;
;;   IF_W_WRITE_in_CX_const_BX_BP_ES interface
;;       IF_W_WRITE actually signals the ethernet board to write a packet to 
;;       the ethernet.  The packet is assumed to be in the buffer returned by 
;;       IF_W_ACCESS. CX is the length of the packet to send.  
;;
;;   IF_SET_ADDRESS_in_SI_const_BX_CX_BP_DI_ES interface
;;       IF_SET_ADDRESS_in_SI sets the hardware address to be the value
;;       pointed to by SI.  Note this function may be a no-op if the
;;       hardware address cannot be set (ETHERNET for example)
;;
;;   IF_COPY_in_CX_SI_DI_ES_out_SI_DI_const_BX_BP_ES interface
;;      IF_COPY_in_CX_SI_DI_ES copys a packet from the input buffer (pointed 
;;      to by SI and the segement register given in IF_DECLARE) to an output 
;;      buffer (pointed to by DI and dest_reg) of length CX.   It assumes the
;;      output buffer is contiguous.  (and the caller shouldn't care if the 
;;      input buffer is contiguous)  COPY updates the pointers SI and DI
;;      to the end of the packet, and COPY could be called again if CX is not
;;      the total packet length (Note that CX MUST be even if you care about
;;      SI, and DI being updated properly)
;;
;;  The variable provided by this module are (READ ONLY!!!)
;;
;;      if_&name&_address               ;; the hardware address
;;      if_&name&_mtu                   ;; the maximum transmition unit
;;
;;****************************************************************************

;;****************************************************************************
;; IF_DECLARE name, real_if, type
;;   
IF_DECLARE MACRO name, real_if, type

    if_&name&_name = real_if
    if_&name&_type equ <type>

    if name ne real_if
        if_&name&_address = if_&real_if&_address
        if_&name&_mtu = if_&real_if&_mtu
    endif
ENDM

;;******************************************************************************
;;   IF_R_ACCESS_out_BX_CX_ES name, no_packet
;;       
IF_R_ACCESS_out_BX_CX_ES MACRO name, no_packet
    HELPER macro myname, type, myno_packet
        type&&_IF_R_ACCESS_out_BX_CX_ES myname, myno_packet
    ENDM

    HELPER  %if_&name&_name, %if_&name&_type, no_packet
ENDM

;;******************************************************************************
;;   IF_R_FREE name
;;
IF_R_FREE_const_BX_CX_BP_SI_DI_ES MACRO name
    HELPER macro myname, type
        type&&_IF_R_FREE_const_BX_CX_BP_SI_DI_ES myname
    ENDM

    HELPER  %if_&name&_name, %if_&name&_type
ENDM

;;******************************************************************************
;; IF_R_CONT_in_BX_CX_ES name, ok
;;
IF_R_CONT_in_BX_CX_ES_const_BX_CX_DX_BP_SI_DI_ES MACRO name, ok
    HELPER macro myname, type, myok
        type&&_IF_R_CONT_in_BX_CX_ES_const_BX_CX_DX_BP_SI_DI_ES myname, myok
    ENDM

    HELPER  %if_&name&_name, %if_&name&_type, ok
ENDM

;;******************************************************************************
;;   IF_W_ACCESS_in_CX_out_DI_ES name, no_buffer
;;
IF_W_ACCESS_in_CX_out_DI_ES_const_BX_CX_BP MACRO name, no_buffer
    HELPER macro myname, type, myno_buffer
        type&&_IF_W_ACCESS_in_CX_out_DI_ES_const_BX_CX_BP myname, myno_buffer
    ENDM

    HELPER  %if_&name&_name, %if_&name&_type, no_buffer
ENDM

;;******************************************************************************
;;   IF_W_WRITE_in_CX interface
;;
IF_W_WRITE_in_CX_const_BX_BP_ES MACRO name
    HELPER macro myname, type
        type&&_IF_W_WRITE_in_CX_const_BX_BP_ES myname
    ENDM

    HELPER  %if_&name&_name, %if_&name&_type
ENDM

;;******************************************************************************
;;   IF_SET_ADDRESS_in_SI interface
;;
IF_SET_ADDRESS_in_SI_const_BX_CX_BP_DI_ES MACRO name
    HELPER macro myname, type
        type&&_IF_SET_ADDRESS_in_SI_const_BX_CX_BP_DI myname
    ENDM

    HELPER  %if_&name&_name, %if_&name&_type
ENDM

;;******************************************************************************
;;   IF_COPY_in_CX_SI_DI_ES_out_SI_DI interface
;;
IF_COPY_in_CX_SI_DI_ES_out_SI_DI_const_BX_BP_ES MACRO name
    HELPER macro myname, type
        type&&_IF_COPY_in_CX_SI_DI_ES_out_SI_DI_const_BX_BP_ES myname
    ENDM

    HELPER  %if_&name&_name, %if_&name&_type
ENDM

