 /*********************************************************
 *                                                        *
 *                     VERB RETRY                         *
 *                   ( v r e t r y )                      *
 *                                                        *
 *   Function : Search for the RCB into the wait queue and*
 *              then pass it for proceed the processing.  *
 *                                                        *
 *   Input  : Pointer to the RCB, pointer to verb code.   *
 *   Output : If verb will be found pass it to the psconv.*
 *                                                        *
 *  CopyRight 1995. Nicholas Poljakov all rights reserved.*
 *                                                        *
 *********************************************************/
#include <stdio.h>
#include <rcb.h>
#include <psp.h>
#include <state1.h>
#include <string.h>

struct psp psp_ini;

/*
 *  Seek RCB in wait qeue.
 */
int sk_r_wt(p_rcb)
struct rcb *p_rcb;
{
    struct rcb *t_rcb;

    if ((t_rcb = psp_ini.wait_chain) == NULL) {
        return (-1);
    }
    while (t_rcb != NULL) {
        if (p_rcb == t_rcb) {
            return (0);
        }
        t_rcb = t_rcb -> next_w;
    }
    return (-1);
}
/*
 *  Insert the RCB into the wait queue.
 */
add_wait(p_rcb)
struct rcb *p_rcb;
{
    struct rcb *t_rcb;

    t_rcb = psp_ini.wait_chain;
    if (t_rcb == NULL) {
        psp_ini.wait_chain = p_rcb;
        p_rcb -> next_w = NULL;
        p_rcb -> prev_w = NULL;
        return (0);
    }
    while (t_rcb -> next_w != NULL) {
        t_rcb = t_rcb -> next_w;
    }
    t_rcb -> next_w = p_rcb;
    p_rcb -> prev_w = t_rcb;
    return (0);
}
/*
 *  Delete the RCB from the wait queue.
 */
del_wait(p_rcb)
struct rcb *p_rcb;
{
    struct rcb *t1_rcb;
    struct rcb *t2_rcb;

    if (sk_r_wt(p_rcb) == -1) {
        return (-1);
    }
    t1_rcb = p_rcb -> prev_w;
    t2_rcb = p_rcb -> next_w;
    if (t1_rcb == NULL) {
        psp_ini.wait_chain = NULL;
        return (0);
    }
    if (t2_rcb == NULL) {
        t1_rcb -> next_w = NULL;
        return (0);
    }
    p_rcb -> next_w = NULL;
    p_rcb -> prev_w = NULL;
    t1_rcb -> next_w = t2_rcb;
    t2_rcb -> prev_w = t1_rcb;
    return (0);
}
