/*
 *
 *             Send Block
 *         s u b r o u t i n e
 *
 * Function : Send block to LU type 0.
 * Input    : Send_Data structure.
 * Output   : Return code.  
 *
 *
 * CopyRight 1995. Nicholas Poljakov all rights reserved.
 * 
 */
#include <stdio.h>
#include <malloc.h>
#include <sendat.h>
#include <include.h>
#include <rcb.h>
#include <state1.h>

#define PRF_SIZ 31

#if OS_TYPE == 0 /* MS-DOS */
int sk_r_wt(void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);
#endif
extern short sem_no;

SendBlock(ps, p_rcb)
struct send_data *ps;
struct rcb *p_rcb;
{
        unsigned rc;
        int cnt;
	char *p;
	struct segprf *p_sp;
	struct rqb *p_rqb;

	rc = 0;
        cnt = ps -> data_lt;
#if OS_TYPE == 0 /* MS-DOS */
        if ((p_sp = cgetmem(1, (cnt + PRF_SIZ))) == NULL) {
#endif
#if OS_TYPE == 1 /* Unix V */
        if ((p_sp = calloc(1, (cnt + PRF_SIZ))) == NULL) {
#endif
           rc = 1;
           goto sb_exit;
        }
        p = (char *)p_sp + PRF_SIZ;
        memcpy(p, ps -> data_addr, cnt);
        p_sp -> len = cnt + 3; /* segment length (i.e. RU + RH)*/
        p_rqb = (char *)ps + 12;
        p_rqb -> th.ra.rparm.parm.parm2 = Send_data;
        p_rqb -> th.ra.wa.hh.hscb = p_rcb -> sess_corl;
	p_rqb -> th.ra.wa.rqba.rclass = cnt;
        p_rqb -> th.ra.stcb = APPL_CODE;
        p_rqb -> th.ra.code = p_rqb -> th.ra.code & 0xbf; /* TOP */
        p_rqb -> th.ra.wa.rqba.rsrlen = sem_no;
        p_rqb -> th.ra.rparm.parm.parm1 = 1; /* Send */

#if OS_TYPE == 1  /* Unix System V */
        pattach(p_rqb);
        free(p_sp);
#else             /* MS-DOS */
        call_appl(p_rqb);
#endif

sb_exit:
        return rc;
}
