 /**********************************************************
 *                                                         *
 *                      SENDHS                             *
 *                SEND record to HS                        *
 * This procedure requesting the HS for send processing    *
 * with appropriate parms.                                 *
 * The applicable parms are :                              *
 *                  - FMH;                                 *
 *                  - Send_data;                           *
 *                  - Confirm;                             *
 *                  - Confirmed;                           *
 *                  - Flash;                               *
 *                  - PREP_TO_RCV_FLUSH;                   *
 *                  - PREP_TO_RCV_CONFIRM_SH;              *
 *                  - PREP_TO_RCV_CONFIRM_LG;              *
 *                  - Req_to_send;                         *
 *                  - Deallocate_confirm;                  *
 *                  - Deallocate_flush;                    *
 *                  - Deallocate_abend;                    *
 *                                                         *
 * INPUT : type ( which describes the selected parm),      *
 *         pointer to RCB.                                 *
 *                                                         *
 * OUTPUT: - 0 - OK;                                       *
 *         - 1 - invalid request;                          *
 *         - 2 - return code in RPL.                       *
 *                                                         *
 *                                                         *
 * CopyRight 1995. Nicholas Poljakov all rights reserved.  *
 *                                                         *
 **********************************************************/
#include <stdio.h>
#include <malloc.h>
#include <rcb.h>
#include <scb.h>
#include <prefix.h>
#include <include.h>
#include <string.h>
#include <state1.h>

#define PRF_SIZ 31

#if OS_TYPE == 0 /* MS-DOS */
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);
#endif
int short sem_no;

sendhs(p_rcb)
struct rcb *p_rcb;
{
        struct scb *p_scb;
        struct prefix *p_prf;
        struct prefix *t_prf;
        struct prefix *tt_prf;
        struct segprf *p_sp;
        struct segprf *t_sp;
        struct rqb *p_rqb;
        char p1;
        char *p;
        unsigned int cnt;
        unsigned int cnt1;
        char *buff;
        int rc;
        unsigned char type;
        int i;
        unsigned char dsc;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;           /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "sendhs");
pnum = 1;
drec = p_rcb;
lenr = sizeof(struct rcb);
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

        rc = 0;
        cnt1 = 0;

        if (p_rcb -> p_scb == NULL) {
             rc = 2;
             goto sd_exit;
        }
        p_scb = p_rcb -> p_scb;
        p_prf = p_rcb -> first_out;
        if (p_prf == NULL) {
                rc = 1;
                goto sd_exit;
        }
        type = p_prf -> type;
        cnt = p_prf -> lt_text;
        if (cnt == 0) {
#if OS_TYPE == 0 /* MS-DOS */
            if ((p_rqb = cgetmem(1,16)) == NULL) {
#endif
#if OS_TYPE == 1 /* Unix V */
            if ((p_rqb = calloc(1,16)) == NULL) {
#endif
                rc = 1;
                goto sd_exit;
            }
            p_rqb -> th.ra.code = 0x80; /* RQB */
            tt_prf = p_prf -> prev;
            t_prf = p_prf;
            p_prf = p_prf -> next;
          /* Delete element from the output chain */
            if (p_prf != NULL) {
              p_prf -> prev = t_prf -> prev;
            }
            else
                  {
                      p_rcb -> first_out = NULL;
                  }
            if (tt_prf != NULL) {
                tt_prf -> next = p_prf;
            }
            free(t_prf);
        }
        else
                {
                      i = 0;
                      cnt1 = 0;
                      t_sp = NULL;

                      do {
                          dsc = p_prf -> dsc;
#if OS_TYPE == 0 /* MS-DOS */
                          if ((p_sp = cgetmem(1,(cnt + PRF_SIZ))) == NULL) {
#endif
#if OS_TYPE == 1 /* Unix V */
                          if ((p_sp = calloc(1,(cnt + PRF_SIZ))) == NULL) {
#endif
                              rc = 1;
                              goto sd_exit;
                          }
                          p = p_sp;
                          p_sp -> len = cnt + 3; /* the segment length (i.e. RU + RH)*/
                          if (i == 0) {
                              p_rqb = p + 12;
                              p_rqb -> th.ra.code = p_rqb -> th.ra.code & 0x7f; /*SEG*/
                          }
                          p += PRF_SIZ;
                          memcpy(p, p_prf -> text, cnt);
                          if (p_prf -> dsc == 0) {
                              if (p_sp != NULL) {
                                  p_sp -> link = NULL;
                              }
                          }
                          if (t_sp != NULL) {
                              t_sp -> link = p_sp;
                          }
                          i ++;
                          cnt1 += cnt;
                          t_sp = p_sp;
                          tt_prf = p_prf -> prev;
                          t_prf = p_prf;
                          p_prf = p_prf -> next;
                        /* Delete the element from an output chain */
                          free(t_prf -> text);
                          if (p_prf != NULL) {
                            p_prf -> prev = t_prf -> prev;
                            cnt = p_prf -> lt_text;
                          }
                          else
                                {
                                    p_rcb -> first_out = NULL;
                                }
                          if (tt_prf != NULL) {
                              tt_prf -> next = p_prf;
                          }
                          free(t_prf);
                      } while ((dsc != 0) && (p_prf -> lt_text != 0) && (p_prf != NULL));
                }

      /* Set the RQB fields and then call Pattach */

        p_rqb -> th.ra.rparm.parm.parm2 = type;
        p_rqb -> th.ra.wa.hh.hscb = p_rcb -> sess_corl;
        p_rqb -> th.ra.wa.rqba.rclass = cnt1;
        p_rqb -> th.ra.stcb = APPL_CODE;
        p_rqb -> th.ra.code = p_rqb -> th.ra.code & 0xbf; /* TOP */
        p_rqb -> th.ra.wa.rqba.rsrlen = sem_no;
        p_rqb -> th.ra.rparm.parm.parm1 = 1; /* Send */

#if OS_TYPE == 1
/***********************************/
rtype = GREC;
strcpy(pname, "sendhs");
pnum = 2;
if (p_rqb -> th.ra.code & 0x80) {
   drec = p_rqb;
   lenr = 16;
   gtf(rtype, pname, pnum, drec, lenr);
}
else {
       drec = p_sp;
       lenr = 31;
       gtf(rtype, pname, pnum, drec, lenr);
     }
/***********************************/
        pattach(p_rqb);
#else
        call_appl(p_rqb);
#endif
#if OS_TYPE == 1 /* Unix V */
        p1 = p_rqb -> th.ra.code & 0x80;
        if (p1 == 0x80) { /* RQB */
            free(p_rqb);
        }
        else
                {
                    free(p_sp);
                }
#endif

sd_exit:
         switch (rc) {
            case 0 :
                      {
                          p1 = RESET;
                          fsm_error(p1, p_rcb);
                          break;
                      }
            case 1 :
                      {
                          p1 = ALLOC_FAIL_RETRY;
                          fsm_error(p1, p_rcb);
                          break;
                      }
            case 2 :
                      {
                          p1 = ALLOC_FAIL_NO_RETRY;
                          fsm_error(p1, p_rcb);
                          break;
                      }
          }
         return (rc);
}
