


NOV 15 14:13 1990  /USR/INCLUDE/SGTTY.H PAGE 1
N                                       P
N                                       P


/*
 * STRUCTURE FOR STTY AND GTTY SYSTEM CALLS.
   S
   S
 */

STRUCT SGTTYB (
              -
        CHAR    SG_ISPEED;              /* INPUT SPEED */
        CHAR    SG_OSPEED;              /* OUTPUT SPEED */
        CHAR    SG_ERASE;               /* ERASE CHARACTER */
        CHAR    SG_KILL;                /* KILL CHARACTER */
        INT     SG_FLAGS;               /* MODE FLAGS */
        INT     SG_PAD;                 /* SPACE FOR OTHER INFO */
);
-

/*
 * LIST OF SPECIAL CHARACTERS
   L
   L
 */
STRUCT TCHARS (
              -
        CHAR    T_INTRC;        /* INTERRUPT */
        CHAR    T_QUITC;        /* QUIT */
        CHAR    T_STARTC;       /* START OUTPUT */
        CHAR    T_STOPC;        /* STOP OUTPUT */
        CHAR    T_EOFC;         /* END-OF-FILE */
        CHAR    T_BRKC;         /* INPUT DELIMITER (LIKE NL) */
);
-

/*
 * MODES
   M
   M
 */
#DEFINE TANDEM  01
        TANDEM
        TANDEM
#DEFINE CBREAK  02
        CBREAK
        CBREAK
#DEFINE LCASE   04
        LCASE
        LCASE
#DEFINE ECHO    010
        ECHO
        ECHO
#DEFINE CRMOD   020
        CRMOD
        CRMOD
#DEFINE RAW     040
        RAW
        RAW
#DEFINE ODDP    0100
        ODDP
        ODDP
#DEFINE EVENP   0200
        EVENP
        EVENP
#DEFINE ANYP    0300
        ANYP
        ANYP
#DEFINE NLDELAY 001400
        NLDELAY
        NLDELAY
#DEFINE TBDELAY 006000
        TBDELAY
        TBDELAY
#DEFINE XTABS   006000
        XTABS
        XTABS
#DEFINE CRDELAY 030000
        CRDELAY
        CRDELAY
#DEFINE VTDELAY 040000
        VTDELAY
        VTDELAY
#DEFINE ALLDELAY 077400
        ALLDELAY
        ALLDELAY
#DEFINE IDBL    0200000
        IDBL
        IDBL
#DEFINE ODBL    0400000
        ODBL
        ODBL
#DEFINE IGRAVE  01000000
        IGRAVE
        IGRAVE
#DEFINE OGRAVE  02000000
        OGRAVE
        OGRAVE
#DEFINE DEFCONS 04000000
        DEFCONS
        DEFCONS
#DEFINE UNHOLD  010000000
        UNHOLD
        UNHOLD
#DEFINE SAME    040000000
        SAME
        SAME

/*
 * DELAY ALGORITHMS
   D
   D
 */
#DEFINE CR0     0
        CR
        CR
#DEFINE CR1     010000
        CR
        CR







NOV 15 14:13 1990  /USR/INCLUDE/SGTTY.H PAGE 2
N                                       P
N                                       P


#DEFINE CR2     020000
        CR
        CR
#DEFINE CR3     030000
        CR
        CR
#DEFINE NL0     0
        NL
        NL
#DEFINE NL1     000400
        NL
        NL
#DEFINE NL2     001000
        NL
        NL
#DEFINE NL3     001400
        NL
        NL
#DEFINE TAB0    0
        TAB
        TAB
#DEFINE TAB1    002000
        TAB
        TAB
#DEFINE TAB2    004000
        TAB
        TAB
#DEFINE FF0     0
        FF
        FF
#DEFINE FF1     040000
        FF
        FF
#DEFINE BS0     0
        BS
        BS
#DEFINE BS1     0100000
        BS
        BS

/*
 * SPEEDS
   S
   S
 */
#DEFINE B0      0
        B
        B
#DEFINE B50     1
        B
        B
#DEFINE B75     2
        B
        B
#DEFINE B110    3
        B
        B
#DEFINE B134    4
        B
        B
#DEFINE B150    5
        B
        B
#DEFINE B200    6
        B
        B
#DEFINE B300    7
        B
        B
#DEFINE B600    8
        B
        B
#DEFINE B1200   9
        B
        B
#DEFINE B1800   10
        B
        B
#DEFINE B2400   11
        B
        B
#DEFINE B4800   12
        B
        B
#DEFINE B9600   13
        B
        B
#DEFINE EXTA    14
        EXTA
        EXTA
#DEFINE EXTB    15
        EXTB
        EXTB

/*
 * TTY IOCTL COMMANDS
 */
#DEFINE TIOCGETD        (('T'<<8)[0)
        TIOCGETD                 ]
        TIOCGETD
#DEFINE TIOCSETD        (('T'<<8)[1)
        TIOCSETD                 ]
        TIOCSETD
#DEFINE TIOCHPCL        (('T'<<8)[2)
        TIOCHPCL                 ]
        TIOCHPCL
#DEFINE TIOCMODG        (('T'<<8)[3)
        TIOCMODG                 ]
        TIOCMODG
#DEFINE TIOCMODS        (('T'<<8)[4)
        TIOCMODS                 ]
        TIOCMODS
#DEFINE TIOCGETP        (('T'<<8)[8)
        TIOCGETP                 ]
        TIOCGETP
#DEFINE TIOCSETP        (('T'<<8)[9)
        TIOCSETP                 ]
        TIOCSETP
#DEFINE TIOCSETN        (('T'<<8)[10)
        TIOCSETN                 ]
        TIOCSETN
#DEFINE TIOCPRNT        (('T'<<8)[11)
        TIOCPRNT                 ]
        TIOCPRNT
#DEFINE TIOCEXCL        (('T'<<8)[13)
        TIOCEXCL                 ]
        TIOCEXCL
#DEFINE TIOCNXCL        (('T'<<8)[14)
        TIOCNXCL                 ]
        TIOCNXCL
#DEFINE TIOCFLUSH       (('T'<<8)[16)
        TIOCFLUSH                ]
        TIOCFLUSH
#DEFINE TIOCSETC        (('T'<<8)[17)
        TIOCSETC                 ]
        TIOCSETC
#DEFINE TIOCGETC        (('T'<<8)[18)
        TIOCGETC                 ]
        TIOCGETC
#DEFINE TIOCSETT        (('T'<<8)[19)
        TIOCSETT                 ]
        TIOCSETT
#DEFINE TIOCGETT        (('T'<<8)[20)
        TIOCGETT                 ]
        TIOCGETT
#DEFINE DIOCLSTN        (('D'<<8)[1)
        DIOCLSTN                 ]
        DIOCLSTN
#DEFINE DIOCNTRL        (('D'<<8)[2)
        DIOCNTRL                 ]
        DIOCNTRL
#DEFINE DIOCMPX         (('D'<<8)[3)
        DIOCMPX                  ]
        DIOCMPX







NOV 15 14:13 1990  /USR/INCLUDE/SGTTY.H PAGE 3
N                                       P
N                                       P


#DEFINE DIOCNMPX        (('D'<<8)[4)
        DIOCNMPX                 ]
        DIOCNMPX
#DEFINE DIOCSCALL       (('D'<<8)[5)
        DIOCSCALL                ]
        DIOCSCALL
#DEFINE DIOCRCALL       (('D'<<8)[6)
        DIOCRCALL                ]
        DIOCRCALL
#DEFINE DIOCPGRP        (('D'<<8)[7)
        DIOCPGRP                 ]
        DIOCPGRP
#DEFINE DIOCGETP        (('D'<<8)[8)
        DIOCGETP                 ]
        DIOCGETP
#DEFINE DIOCSETP        (('D'<<8)[9)
        DIOCSETP                 ]
        DIOCSETP
#DEFINE DIOCLOSE        (('D'<<8)[10)
        DIOCLOSE                 ]
        DIOCLOSE
#DEFINE DIOCTIME        (('D'<<8)[11)
        DIOCTIME                 ]
        DIOCTIME
#DEFINE DIOCRESET       (('D'<<8)[12)
        DIOCRESET                ]
        DIOCRESET
#DEFINE FIOCLEX         (('F'<<8)[1)
        FIOCLEX                  ]
        FIOCLEX
#DEFINE FIONCLEX        (('F'<<8)[2)
        FIONCLEX                 ]
        FIONCLEX
#DEFINE MXLSTN          (('X'<<8)[1)
        MXLSTN                   ]
        MXLSTN
#DEFINE MXNBLK          (('X'<<8)[2)
        MXNBLK                   ]
        MXNBLK
#DEFINE TUBSETPF        (('3'<<8)[1)
        TUBSETPF                 ]
        TUBSETPF
#DEFINE TUBGETPF        (('3'<<8)[2)
        TUBGETPF                 ]
        TUBGETPF
#DEFINE TUBICMD         (('3'<<8)[3)
        TUBICMD                  ]
        TUBICMD
#DEFINE TUBOCMD         (('3'<<8)[4)
        TUBOCMD                  ]
        TUBOCMD
#DEFINE TUBWATTN        (('3'<<8)[5)
        TUBWATTN                 ]
        TUBWATTN
#DEFINE TUBNATTN        (('3'<<8)[6)
        TUBNATTN                 ]
        TUBNATTN
#DEFINE TUBGETI         (('3'<<8)[7)
        TUBGETI                  ]
        TUBGETI
#DEFINE TUBGETO         (('3'<<8)[8)
        TUBGETO                  ]
        TUBGETO
#DEFINE TUBRECLR        (('3'<<8)[9)
        TUBRECLR                 ]
        TUBRECLR
#DEFINE TUBMAPPF        (('3'<<8)[10)
        TUBMAPPF                 ]
        TUBMAPPF
#DEFINE TUBUNMAPPF      (('3'<<8)[11)
        TUBUNMAPPF               ]
        TUBUNMAPPF
#DEFINE TUBSETMOD       (('3'<<8)[12)
        TUBSETMOD                ]
        TUBSETMOD
#DEFINE TUBGETMOD       (('3'<<8)[13)
        TUBGETMOD                ]
        TUBGETMOD
#DEFINE TUB32772         1               /* EC7927 */
        TUB                                 EC
        TUB                                 EC
#DEFINE TUB32782         2               /* EC8566 */
        TUB                                 EC
        TUB                                 EC
#DEFINE TUB32783         3
        TUB
        TUB
#DEFINE TUB32784         4
        TUB
        TUB
#DEFINE TUB32785         5
        TUB
        TUB
#DEFINE TUB32792         6
        TUB
        TUB
#DEFINE TUB32793         7
        TUB
        TUB
#DEFINE TUB32782A        8
        TUB     A
        TUB     A
#DEFINE TUB7934          9               /* EC7934 */
        TUB                                 EC
        TUB                                 EC
#DEFINE TUB7910         12               /* EC7910 */
        TUB                                 EC
        TUB                                 EC

/* RAW TERMINAL */
#DEFINE RAWTRMWR        (('R'<<8)[1)    /* WRITE/READ */
        RAWTRMWR                 ]
        RAWTRMWR

/* PRINTER COMMANDS */
#DEFINE PIORAW          (('P'<<8)[1)    /* SET RAW MODE */
        PIORAW                   ]
        PIORAW
#DEFINE PIOCOOK         (('P'<<8)[2)    /* SET NORMAL MODE */
        PIOCOOK                  ]
        PIOCOOK
#DEFINE PIOFLUSH        (('P'<<8)[3)    /* FLUSH BUFFERS */
        PIOFLUSH                 ]
        PIOFLUSH
#DEFINE PIOMODEFF       (('P'<<8)[4)    /* SET "FORM FEED" MODE */
        PIOMODEFF                ]
        PIOMODEFF
#DEFINE PIOMODE_FF      (('P'<<8)[5)    /* RESET "FORM FEED" MODE */
        PIOMODE FF               ]
        PIOMODE FF
#DEFINE PIOMODELC       (('P'<<8)[6)    /* SET "LCASE" MODE */
        PIOMODELC                ]
        PIOMODELC
#DEFINE PIOMODE_LC      (('P'<<8)[7)    /* RESET "LCASE" MODE */
        PIOMODE LC               ]
        PIOMODE LC
#DEFINE PIOCONSTR       (('P'<<8)[8)    /* SET "CONSTRUCT" MODE */
        PIOCONSTR                ]
        PIOCONSTR
#DEFINE PIOUCSB         (('P'<<8)[9)    /* LOAD UCSB */
        PIOUCSB                  ]
        PIOUCSB
#DEFINE PIOFCB          (('P'<<8)[10)   /* LOAD FCB */
        PIOFCB                   ]
        PIOFCB
#DEFINE PIOREADY        (('P'<<8)[11)   /* TEST PRINTER READY */
        PIOREADY                 ]
        PIOREADY
#DEFINE PIOPURGE        (('P'<<8)[12)
        PIOPURGE                 ]
        PIOPURGE
#DEFINE PIOMODEEL       (('P'<<8)[13)   /* SET "EL" MODE */
        PIOMODEEL                ]
        PIOMODEEL
#DEFINE PIOMODE_EL      (('P'<<8)[14)   /* RESET "EL" MODE */
        PIOMODE EL               ]
        PIOMODE EL
#DEFINE PIOMODERL       (('P'<<8)[15)   /* SET "RL" MODE */
        PIOMODERL                ]
        PIOMODERL







NOV 15 14:13 1990  /USR/INCLUDE/SGTTY.H PAGE 4
N                                       P
N                                       P


#DEFINE PIOMODE_RL      (('P'<<8)[16)   /* RESET "RL" MODE */
        PIOMODE RL               ]
        PIOMODE RL

/* MAGNETIC TAPE COMMANDS */
#DEFINE TAPIO           (('M'<<8)[1)
        TAPIO                    ]
        TAPIO
#DEFINE TAPMOTION       (('M'<<8)[2)
        TAPMOTION                ]
        TAPMOTION
#DEFINE TAPMODE         (('M'<<8)[3)
        TAPMODE                  ]
        TAPMODE
#DEFINE TAPGTTY         (('M'<<8)[4)
        TAPGTTY                  ]
        TAPGTTY
#DEFINE TAPRING         (('M'<<8)[5)
        TAPRING                  ]
        TAPRING
#DEFINE TAPSENSE        (('M'<<8)[6)
        TAPSENSE                 ]
        TAPSENSE

/* FAST DISK DRIVER COMMANDS */
#DEFINE FASTFORM        (('E'<<8)[1)
        FASTFORM                 ]
        FASTFORM
#DEFINE FASTNORM        (('E'<<8)[2)
        FASTNORM                 ]
        FASTNORM
#DEFINE FASTSIZE        (('E'<<8)[3)
        FASTSIZE                 ]
        FASTSIZE
#DEFINE FASTDESC        (('E'<<8)[4)
        FASTDESC                 ]
        FASTDESC

/* RAW DASD DRIVER COMMANDS */
#DEFINE RAWDESC         (('R'<<8)[1)
        RAWDESC                  ]
        RAWDESC
#DEFINE RAWCYLS         (('R'<<8)[2)
        RAWCYLS                  ]
        RAWCYLS

/* MEMIO DRIVER COMMANDS */
#DEFINE MMLOAD          (('M'<<8)[1)
        MMLOAD             M     ]
        MMLOAD             M
#DEFINE MMUNLOAD        (('M'<<8)[2)
        MMUNLOAD           M     ]
        MMUNLOAD           M
#DEFINE MMLIST          (('M'<<8)[3)
        MMLIST             M     ]
        MMLIST             M

/* SMSG COMMAND */
   SMSG
   SMSG
#DEFINE SMSGUSER        (('S'<<8)[1)
        SMSGUSER           S     ]
        SMSGUSER           S

/* VMCF COMMANDS */
   VMCF
   VMCF
#DEFINE VMCUSER         (('V'<<8)[1)
        VMCUSER            V     ]
        VMCUSER            V
#DEFINE VMCPROT         (('V'<<8)[2)
        VMCPROT            V     ]
        VMCPROT            V
#DEFINE VMCIDENT        (('V'<<8)[3)
        VMCIDENT           V     ]
        VMCIDENT           V
/* VMCPROT VALUES */
   VMCPROT
   VMCPROT
#DEFINE VMC_P1  1       /* W=SEND, R=RECEIVE */
        VMC P                SEND    RECEIVE
        VMC P                SEND    RECEIVE
#DEFINE VMC_P2  2       /* W=SEND/RECV, R=MOVE DATA */
        VMC P                SEND RECV
        VMC P                SEND RECV
#DEFINE VMC_P3  3       /* W=REPLY, R=RECEIVE */
        VMC P                REPLY    RECEIVE
        VMC P                REPLY    RECEIVE
#DEFINE VMC_P4  4       /* W=SENDX, R=READ SENDX DATA */
        VMC P                SENDX         SENDX
        VMC P                SENDX         SENDX

/* PVM COMMANDS */
   PVM
   PVM
#DEFINE PVMGET          (('P'<<8)[1)
        PVMGET             P     ]
        PVMGET             P
#DEFINE PVMSET          (('P'<<8)[2)
        PVMSET             P     ]
        PVMSET             P

/* POLLING AND POKING FOR FS MODE TUBES AND LDEVS */
   P                      FS                LDEV
   P                      FS                LDEV
#DEFINE TIOPOLL         (('T'<<8)[1)
        TIOPOLL            T     ]
        TIOPOLL            T
#DEFINE TIOPOKE         (('T'<<8)[2)
        TIOPOKE            T     ]
        TIOPOKE            T
#DEFINE TIONPOKE        (('T'<<8)[3)
        TIONPOKE           T     ]
        TIONPOKE           T















