 /********************************************************
 *                                                       *
 *                   CHECK_END                           *
 *                                                       *
 *  Function : Checks if the processing of a verb is     *
 *             complete. If not, then place the RCB in   *
 *             the waiting queue.                        *
 *  Input  :  Pointer to the "common" struct. The first  *
 *            12 bytes of it contains the "repass"       *
 *            structure.                                 *
 *  Output :  If the verb processing is complete, then   *
 *            the RCB will be removed from wait queue;   *
 *            otherwise the RCB will be placed in the    *
 *            wait queue.                                *
 *                                                       *
 * CopyRight 1995. Nicholas Poljakov all rights reserved.*
 *                                                       *
 ********************************************************/
#include <alloc.h>
#include <attlu.h>
#include <common.h>
#include <conf.h>
#include <confd.h>
#include <dall.h>
#include <detach.h>
#include <flush.h>
#include <gatt.h>
#include <partner.h>
#include <post.h>
#include <preptrcv.h>
#include <rcb.h>
#include <recimmed.h>
#include <recwait.h>
#include <repass.h>
#include <rtsend.h>
#include <sendat.h>
#include <sender.h>
#include <state1.h>
#include <tcb.h>
#include <test.h>
#include <tps.h>
#include <string.h>

int asfd;    /* FiFo descriptor for AS */
extern int sw_retry[10];
#if OS_TYPE == 0
extern int ss_ptr;
#endif
int add_wait();
int del_wait();
int write();
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);
int add_wait(struct rcb *);
int waitst(void);
int del_wait(struct rcb *);

check_end(code, p_rep)
unsigned int code;
struct repass *p_rep;
{
    struct rcb *p_rcb;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;           /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "checked");
pnum = 1;
drec = p_rep;
lenr = 200;
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/

printf("LUPS...checkend...code = %x, p_rep = %x\n", code, p_rep);
#endif

    if (code == 0xffff) { /* error in getverb subr. */
        return (0);
    }
    if ((code == -1)||
        (code == FMHRCV)||(code == SESSINI)||
#if OS_TYPE == 0 /* MS-DOS */
        (code == DR) || (code == POSTOPEN) ||
#endif
        (code == CLSSESS)||(code == CLSSESS)) {
#if OS_TYPE == 1  /* Unix V */
        free(p_rep);
#endif
        return (0); /* Invalid POST or no need to response*/
    }
    if (p_rep -> complete == 0) {
#if OS_TYPE == 1
        FifoWrt(p_rep); /* Write response to Trans. Prog. FIFO */
        free(p_rep);
#endif
    }
    else {
            p_rcb = p_rep -> p_rcb;
            add_wait(p_rcb);
#if OS_TYPE == 0
            waitst();  /* wait events from low levels */
            del_wait(p_rcb);
            if (code != Allocate) {
                sw_retry[ss_ptr - 1] = YES;
            }
#endif
         }
    return (0);
}
#if OS_TYPE == 1  /* Unix - V */
FifoWrt(ptr)
struct com *ptr;
{
    struct repass *p_rep;
    struct rcb *p_rcb;
    struct tcb *p_tcb;
    struct rcwait *p_rw;
    struct recimmed *p_ri;
    int short tp_fd;
    int i;
    int rest;
#if DEBUG == 1
printf("LUPS...FifoWrt...code = %x, asfd = %d\n", ptr -> code, asfd);
#endif
    p_rep = ptr;
    switch (ptr -> code) {
        case Attach_lu:
                       {
                         i = write(asfd, ptr, sizeof(struct attach_lu));
printf("LUPS...checkend...after write i = %d, asfd = %d\n", i, asfd);
                         break;
                       }
        case Detach_lu:
                       {
#if DEBUG == 0
                         write(asfd, ptr, sizeof(struct detach));
#endif
                         break;
                       }
        case TP_STARTED:
                       {
#if DEBUG == 0
                         i = write(asfd, ptr, sizeof(struct tp_started));
printf("LUPS...checkend...after write i = %d, asfd = %d\n", i, asfd);
#endif
                         break;
                       }
        case Allocate:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
#if DEBUG == 0
                         i = write(tp_fd, ptr, sizeof(struct allocate));
printf("LUPS...checkend...after write i = %d, asfd = %d\n", i, asfd);
#endif
                         break;
                       }
        case Confirm:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
                         write(tp_fd, ptr, sizeof(struct confirm));
                         break;
                       }
        case COnfirmed:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
                         write(tp_fd, ptr, sizeof(struct confirmed));
                         break;
                       }
        case Deallocate:
                       {
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
#if DEBUG == 0
                         write(tp_fd, ptr, sizeof(struct deallocate));
#endif
                         break;
                       }
        case Flush:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
#if DEBUG == 0
                         write(tp_fd, ptr, sizeof(struct flush));
#endif
                         break;
                       }
        case Get_attributes:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
                         write(tp_fd, ptr, sizeof(struct get_attributes));
                         break;
                       }
        case Post_on_receipt:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
                         write(tp_fd, ptr, sizeof(struct post_rcpt));
                         break;
                       }
        case Prepare_to_receive:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
#if DEBUG == 0
                         write(tp_fd, ptr, sizeof(struct p_rcv));
#endif
                         break;
                       }
        case Receive_and_wait:
                       {
                         p_rw = ptr;
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
#if DEBUG == 0
                         write(tp_fd, ptr, sizeof(struct rcwait));
                         if ((i = p_rw -> data_lt) != 0) {
                            do {
                                if (i <= MAX_SEG) {
                                    rest = i;
                                    i = 0;
                                }
                                else
                                        {
                                            rest = MAX_SEG;
                                            i -= MAX_SEG;
                                        }
                                write(tp_fd, p_rw -> data_addr, rest);
                            } while (i != 0);
                            free(p_rw -> data_addr);
                         }
#endif
                         break;
                       }
        case Receive_immediate:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
#if DEBUG == 0
                         write(tp_fd, ptr, sizeof(struct recimmed));
                         if ((i = p_ri -> data_lt) != 0) {
                            do {
                                if (i <= MAX_SEG) {
                                    rest = i;
                                    i = 0;
                                }
                                else
                                        {
                                            rest = MAX_SEG;
                                            i -= MAX_SEG;
                                        }
                                write(tp_fd, p_ri -> data_addr, rest);
                            } while (i != 0);
                            free(p_ri -> data_addr);
                         }
#endif
                         break;
                       }
        case Request_to_send:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
#if DEBUG == 0
                         write(tp_fd, ptr, sizeof(struct rtsend));
#endif
                         break;
                       }
        case Send_data:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
#if DEBUG == 0
                         write(tp_fd, ptr, sizeof(struct send_data));
#endif
                         break;
                       }
        case Send_error:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
                         write(tp_fd, ptr, sizeof(struct send_error));
                         break;
                       }
        case Test:
                       {
                         p_rcb = p_rep -> p_rcb;
                         p_tcb = p_rcb -> p_tcb;
                         tp_fd = p_rep -> tp_fd;
                         if (tp_fd == 0) {
                            break; /* TP can't be identificated */
                         }
                         write(tp_fd, ptr, sizeof(struct test));
                         break;
                       }
        case FMHRCV:
        case SESSINI:
        case CLSSESP:
        case CLSSESS:
        case DR:
        case POSTOPEN:
                       break;

        default:
	               {
printf("LUPS...unexpected code...\n");
                          break;
                   }
     }
    return(0);
}
#endif
