/*
 *
 *                      OPNDST
 *
 * Function : This subroutine handle a VTAM style
 *            OPNDST request.
 * This function performs call the "pattach" subroutine
 * and use the following extern vars: - sem_no, pparm.
 *
 *  Input    :  "Port-m segment" with NIB inserted
 *               in RU.
 *  Output   :  Not applicated.
 *
 * CopyRight 1995. Nicholas Poljakov all rights reserved.
 *
 */
#include <include.h>
#include <stdio.h>
#include <malloc.h>
#include <rpl.h>
#include <nib.h>
#include <state1.h>
#include <string.h>
#if OS_TYPE == 1
#include <memory.h>
#endif

#define PR_SIZE 31

int short sem_no;
int gtf();
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);

opndst(p_rpl)
struct rpl *p_rpl;
{
    struct nib *p_nib;
    struct rqb *p_rqb;
    struct segprf *p_sp;
    char *p;
    int  i;
    int  rc; /* Return code from this proc. */

    rc = 0;
    /* Allocate a segment */
    if ((p = malloc(PR_SIZE + sizeof(struct nib))) == NULL) {
        return (-1);
    }
    p_sp = p;
    i = 0;
    memset(p, i, PR_SIZE + sizeof(struct nib));
    p_sp -> len = sizeof(struct nib);
    p_nib = p_rpl -> p_nib;
    memcpy(p + PR_SIZE, p_nib, sizeof(struct nib)); /*fill RU*/

    p_rqb = p + 12; /* sizeof(struct segprf)*/

  /* Set RQB fields and call Pattach */

    p_rqb -> th.ra.stcb = APPL_CODE;
    p_rqb -> th.ra.code = p_rqb -> th.ra.code & 0x3f;
                                 /* from = TOP, segment */
    p_rqb -> th.ra.wa.rqba.rsrlen = sem_no + ST_N;
    p_rqb -> th.ra.rparm.parm.parm1 = 0; /* OPNDST */
    for (i = 0; i < 4; i++) {
        p_rqb ->th.ra.wa.hh.rswa[i] = p_nib -> user[i];
    }

    if ((p = call_appl(p_rqb)) == NULL) {
        rc = -1;
    }
    free(p);
    return (rc);
}
