{MENUTIL.INC}
(*
  Copyright (C)  David P Kirschbaum  All Rights Reserved
*)

PROCEDURE RvsOn;
  {Turn reverse video on}
  BEGIN
    TextColor(0);
    TextBackGround(7);
  END;

PROCEDURE RvsOff;
  {Turn reverse video off}
  BEGIN
    TextColor(7);
    TextBackGround(0);
  END;


PROCEDURE Cursor (state : curs_cond);
  {Toggle cursor on or off}
  BEGIN
    WITH Regs DO BEGIN
      ax := $0100;                      {BIOS request to set cursor}
      CASE state OF
        on  : IF Color THEN cx := $0607
              ELSE cx :=  $0C0D;        { SET DEFAULT CURSOR TYPE }
        off : cx := $2000;              { SET CURSOR OFF }
      END;
    END;
    Intr($10,Regs);                     {CALL VIDEO INTERUPT}
  END;  {of Cursor}


FUNCTION Replicate (count : INTEGER; Ascii : CHAR ) : Str80;
  { Replicate Ascii count times, return as a string.}
  VAR  TStr : Str80;
  BEGIN
    FillChar(TStr[1],count,Ascii);     {fill with char}
    TStr[0] := CHR(count);             {force length}
    Replicate := TStr;                 {return string}
  END;  {of Replicate}


FUNCTION Centered (field_width : Byte; CenterStr : Str80 ) : Str80;            {* RETURN THE STRING         *

{ Centers CentrStr in a field field_width spaces long (by padding
  left with spaces, returns that string.  Does NOT pad to right.
}
  VAR
    TStr   : Str80;
    middle : Byte;
    len : INTEGER;
  BEGIN
    middle := field_width SHR 1;
    len := LENGTH(CenterStr);
    IF len > field_width
    THEN Centered := COPY(CenterStr,1,field_width) {truncate and return}
    ELSE BEGIN
      len := len SHR 1;
      TStr := Replicate(middle - len,' ')
              + CenterStr
              + Replicate(SUCC(middle - len),' ');
      Centered := COPY(TStr, 1, field_width)  {truncate to field_width chars}
      END;
   END;  {of Centered}


{BOX.INC, downloaded from Delaware OPUS 27 Feb 87
 Toad Hall
}

TYPE line = (single,double,hdouble,vdouble,nongraphic,blank);

FUNCTION screen_location: INTEGER;
  BEGIN
    IF MEM[$0000:$0449] = 7
    THEN BEGIN
      screen_location := $B000;
      Color := FALSE;
    END
    ELSE BEGIN
      screen_location :=  $B800;
      Color := TRUE;
    END;
  END;  {of screenLocation}


PROCEDURE Box(x1,y1,x2,y2,color: INTEGER; linetype: line);

(***************************************************************************

  This procedure Draws a box with coordinates x1,y1 and x2,y2 being the
  top left and bottom right corners of the box respectively.

  To print a box surrounding the entire screen using red double lines
  The calling procedure is:      BOX( 1, 1, 80, 25, RED, double);

  Note:
  This procedure will only run on IBM PC/XT/AT's & hardware compatibles.
  Prior to calling this procedure, two variables need to be set up in
  your program, these consist of:

      TYPE
        X_SCRN_TYPE = ARRAY[1..2000] OF INTEGER;
        Y_SCRN_TYPE = ARRAY[1..25,1..80] OF INTEGER;

      VAR
        x_scrn: ^X_SCRN_TYPE;
        y_scrn: ^Y_SCRN_TYPE;

  You should notice that the two variables defined are actually pointer
  types, and should thus be pointing to the screen area of the machine.
  This can be accomplished by a simple function call as follows:

       FUNCTION SCREENLOCATION: INTEGER;
       BEGIN
         IF MEM[$0000:$0449]=7 THEN SCREENLOCATION := $B000
           ELSE SCREENLOCATION := $B800;
         END;

       x_scrn := PTR(SCREENLOCATION,0);
       y_scrn := PTR(SCREENLOCATION,0);

  This sets both x_scrn and y_scrn to point at the screen buffer.  The
  reason for having both variables is that both variables through their
  corresponding structure are optimized for optimimum access times and
  code size.  As you will notice below, the procedure is really quite
  simple.  If it were not for Turbo's structure capabilities, this
  routine would have to go through several mathematical gymnastics to
  accomplish the same thing.
  ----------------------------------------------------------------------

  As with most of my other programs, this is meant to be more of an
  example and a utility so that others may benefit by work previously
  done.  For this reason, this code is hereby donated to Public Doman.


  written and donated by  DAVID W. TERRY               SEPT. 1, 1985
                          3036 PUTNAM CT.
                          WEST VALLEY CITY, UT 84120
**************************************************************************
*)

TYPE
  BoxType = RECORD
              SIDE,WID,TOP_LE,TOP_RI,BOT_LE,BOT_RI: INTEGER;
              END;

VAR
  BoxChar: BoxType;
  temp1,temp2,temp3,temp4,counter: INTEGER;

CONST
  AllBoxChar: ARRAY[single..blank] OF BoxType =
    ((SIDE:179; WID:196; TOP_LE:218; TOP_RI:191; BOT_LE:192; BOT_RI:217),
     (SIDE:186; WID:205; TOP_LE:201; TOP_RI:187; BOT_LE:200; BOT_RI:188),
     (SIDE:179; WID:205; TOP_LE:213; TOP_RI:184; BOT_LE:212; BOT_RI:190),
     (SIDE:186; WID:196; TOP_LE:214; TOP_RI:183; BOT_LE:211; BOT_RI:189),
     (SIDE:124; WID:045; TOP_LE:046; TOP_RI:046; BOT_LE:096; BOT_RI:039),
     (SIDE:32;  WID:32;  TOP_LE:32;  TOP_RI:32;  BOT_LE:32;  BOT_RI:32));

BEGIN { box }
  color := color ShL 8;
  BoxChar := AllBoxChar[linetype];
  WITH BoxChar DO BEGIN
    SIDE := SIDE+color;
    WID  := WID+color;
    TOP_LE := TOP_LE+color;
    TOP_RI := TOP_RI+color;
    BOT_LE := BOT_LE+color;
    BOT_RI := BOT_RI+color;

    temp1 := SUCC( PRED(y1)*80) ;
    temp2 := SUCC( PRED(y2)*80) ;
    temp3 := x2 + temp1 -2;
    temp4 := x2 + temp2 -2;

    y_scrn^[y1,x1]   :=   TOP_LE;       { corner }
    FOR counter := x1 + temp1 TO temp3 DO
      x_scrn^[counter] := WID;          { horiz  }
    y_scrn^[y1,x2] := TOP_RI;           { corner }
    FOR counter := SUCC(y1) TO PRED(y2) DO
      y_scrn^[counter,x2] := SIDE;      { vert   }
    y_scrn^[y2,x2] := BOT_RI;           { corner }
    FOR counter := x1 + temp2 TO temp4 DO
      x_scrn^[counter] := WID;          { horiz  }
    y_scrn^[y2,x1] := BOT_LE;           { corner }
    FOR counter := SUCC(y1) TO PRED(y2) DO
      y_scrn^[counter,x1] := SIDE;      { vert   }
    END;
  END;  {of Box}


PROCEDURE Update_CurrentDir;
  {Posts global CurrentDir string with the full pathname
   Disk:\subdir\etc.
  }
  BEGIN
    GetDir(0,CurrentDir);               {current drive}
    len := LENGTH(CurrentDir);
    IF CurrentDir[len] <> '\'           {if not just C:\}
    THEN Insert('\',CurrentDir,SUCC(len)); {..then add on the \}
  END;  {of Update_CurrDir}
