/*
 * MultiMail offline mail reader
 * QWK

 Copyright (c) 1997 John Zero <john@graphisoft.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#ifndef QWK_H
#define QWK_H

#include "mmail.h"

#define ndxRecLen 5
#define qmRecLen 128

#define getQfield(d, s, l) { strncpy(d, s, l); d[l] = '\0'; }

struct qwkmsg_header {
	char status;
	char msgnum[7];		// in ASCII
	char date[8];		// ASCII MM-DD-YY date
	char time[5];		// time in HH:MM ASCII
	char to[25];		// TO
	char from[25];		// FROM
	char subject[25];	// subject of message
	char password[12];	// message passw.
	char refnum[8];		// in ASCII
	char chunks[6];		// number of 128 byte chunks, incl. header
	char alive;		// msg is alive/killed
	unsigned char confLSB;
	unsigned char confMSB;
	char res[3];
};

class qheader {
 public:
	char from[26], to[26], subject[26], date[15];
	int msglen, msgnum, refnum, privat, origArea;
	//netaddress na;	// not yet used, but could be!

	int init(FILE *);
};

class qwkpack : public specific_driver
{
	struct AREAs {
		int num, nummsgs;
		char numA[6];
		char *name;
	} *areas;

	mmail *mm;
	FILE *msgdatFile, *ctrdatFile;
	struct bodytype **body;

	char *bodyString;
	int maxConf, ID, currentArea, currentLetter;

	void readControlDat();
	void readIndices();
	void initMessagesDat();
	unsigned long MSBINtolong(unsigned const char *);
	void init();
	void cleanup();
	int getYNum(int, unsigned long);
	char *nextLine();
 public:
	qwkpack(mmail *);
	~qwkpack();
	int getXNum(int);
	int getNoOfAreas();
	void resetAll();
	area_header *getNextArea();
	void selectArea(int);
	int getNoOfLetters();
	void resetLetters();
	letter_header *getNextLetter();
	char *getBody(int, int);
	int isCollection();
	int isReplyArea();
};

class qwkreply : public reply_driver
{
	struct upl_list {
		qheader qHead;
		char fname[50];
		upl_list *nextRecord;
	} *uplListHead, *uplListCurrent;
	
	mmail *mm;
	qwkpack *baseClass;

	char replyPacketName[9], *replyText;
	int currentLetter, noOfLetters, replyExists;
	
	void init();
	void cleanup();
	void uncompress();
	void readRep();
	void repFileName(const char *);
	int getRep1(FILE *, upl_list *);
	void addRep1(FILE *, upl_list *);
	int monthval(const char *);
 public:
	qwkreply(mmail *, specific_driver *);
	~qwkreply();
	int getNoOfAreas();
	void resetAll();
	area_header *getNextArea();
	void selectArea(int);
	int getNoOfLetters();
	void resetLetters();
	letter_header *getNextLetter();
	char *getBody(int, int);
	void enterLetter(letter_header *, char *, int);
	void killLetter(int);
	area_header *refreshArea();
	void makeReply();
	int isCollection();
	int isReplyArea();
};

#endif
