/*
 * MultiMail offline mail reader
 * miscellaneous routines (global)

 Copyright (c) 1996 Toth Istvan <stoty@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "mmail.h"

#include <dirent.h>

// takes off the spaces from the end of a string
char *cropesp(char *st)
{
	char *p;

	for (p = st + strlen(st) - 1; (p > st) && (*p == ' '); p--);
	*++p = '\0';
	return st;
}

char *strdupplus(const char *original)
{
	char *tmp;

	if (original) {
		tmp = new char[strlen(original) + 1];
		strcpy(tmp, original);
	} else
		tmp = NULL;

	return tmp;
};

char *findBaseName(const char *fileName)
{
	int c, d;
	static char tmp[13];

	for (c = 0; (fileName[c] != '.') && (fileName[c]); c++);

	for (d = 0; d < c; d++)
		tmp[d] = tolower(fileName[d]);
	tmp[d] = '\0';

	return tmp;
};

char *stripre(char *subject)
{
        if (!strncasecmp(subject, "re: ", 4))
                subject += 4;
	return subject;
}

void clearDirectory(const char *DirName)
{
	DIR *Dir;
	struct dirent *entry;

	if ((Dir = opendir(DirName))) {
		if (!mychdir(DirName))
			while ((entry = readdir(Dir)))
				if (entry->d_name[0] != '.')
					remove(entry->d_name);
	closedir(Dir);
	}
}

// get a little-endian short, return an int
unsigned getshort(const unsigned char *x)
{
	return ((unsigned) x[1] << 8) + (unsigned) x[0];
}

// get a little-endian long
unsigned long getlong(const unsigned char *x)
{
	return ((unsigned long) x[3] << 24) + ((unsigned long) x[2] << 16) +
		((unsigned long) x[1] << 8) + (unsigned long) x[0];
}

// put an int into a little-endian short
void putshort(unsigned char *dest, unsigned source)
{
	dest[0] = source & 0xff;
	dest[1] = (source & 0xff00) >> 8;
}

// put a long into a little-endian long
void putlong(unsigned char *dest, unsigned long source)
{
	dest[0] = source & 0xff;
	dest[1] = (source & 0xff00) >> 8;
	dest[2] = (source & 0xff0000) >> 16;
	dest[3] = (source & 0xff000000) >> 24;
}
