/*
 * MultiMail offline mail reader
 * driver_list

 Copyright (c) 1996 Toth Istvan <stoty@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>,
                    Robert Vukovic <vrobert@uns.ns.ac.yu>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "bw.h"
#include "qwk.h"

#define PM_QWK    0
#define PM_BW     1
#define PM_UNDEF 99

#define PERSONAL 1
#define TEARLINE 2

// ---------------------------------------------------------------------------
// DriverList methods
// ---------------------------------------------------------------------------

driver_list::driver_list(mmail *mm)
{
	int mode = PM_UNDEF;	// warning supression
	file_list *wl = mm->workList;

	// This is the new way to set the packet type
	if (wl->exists("control.dat") && wl->exists("messages.dat"))
		mode = PM_QWK;
	else {
		wl->gotoFile(0);
		if (wl->getNext(".inf"))
			mode = PM_BW;
		else
			fatalError("Packet type not recognized");
	}

	switch (mode) {
	case PM_BW:
		driverList[1].driver = new bluewave(mm);
		attributes = PERSONAL;
		break;
	case PM_QWK:
		driverList[1].driver = new qwkpack(mm);
		attributes = TEARLINE;
	default:;
	}

	driverList[1].read = new main_read_class(mm, driverList[1].driver);

	switch (mode) {
	case PM_BW:
		driverList[0].driver = new bwreply(mm);
		break;
	case PM_QWK:
		driverList[0].driver = new qwkreply(mm, driverList[1].driver);
	default:;
	}

	driverList[0].read = new reply_read_class(mm, driverList[0].driver);

	driverList[0].offset = REPLY_AREA;
	driverList[1].offset = REPLY_AREA + 1;

	noOfDrivers = 2;
};

driver_list::~driver_list()
{
	delete driverList[0].read;
	delete driverList[0].driver;
	delete driverList[1].read;
	delete driverList[1].driver;
};

int driver_list::getNoOfDrivers()
{
	return noOfDrivers;
};

specific_driver *driver_list::getDriver(int areaNo)
{
	int c = (areaNo != REPLY_AREA);
	return driverList[c].driver;
};

reply_driver *driver_list::getReplyDriver()
{
	return (reply_driver *) driverList[0].driver;
};

read_class *driver_list::getReadObject(specific_driver *driver)
{
	int c = (driver == driverList[1].driver);
	return driverList[c].read;
};

int driver_list::getOffset(specific_driver *driver)
{
	int c = (driver == driverList[1].driver);
	return driverList[c].offset;
};

int driver_list::hasPersonal()
{
	return attributes & PERSONAL;
}

int driver_list::useTearline()
{
	return attributes & TEARLINE;
}
