/*
 * MultiMail offline mail reader
 * tagline selection, editing

 Copyright (c) 1996 Kolossvary Tamas <thomas@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "interfac.h"

extern mmail		mm;
extern LetterWindow	letterwindow;
extern HelpWindow	helpwindow;
extern Interface	*interface;

tagline::tagline()
{
	next = NULL;
}

TaglineWindow::TaglineWindow(int no_draw)
{
	nodraw = no_draw;
	if (!nodraw) {
		srand((unsigned) time(NULL));

		list_max_y = LINES - 15;
		list = new InfoWin(LINES - 10, COLS - 2, 5, 1, C_TBBACK,
					0, 5, 1);
		mvwaddch(list->win, 0, 2, ACS_RTEE);
		mvwaddch(list->win, 0, 17, ACS_LTEE);

		wattrset(list->win, C_TTEXT);
		mvwaddstr(list->win, 0, 3, "Select tagline");
		mvwaddstr(list->win, LINES - 13, 59, " - Apply tagline");
		mvwaddstr(list->win, LINES - 13, 3, " - Don't apply tagline");
		mvwaddstr(list->win, LINES - 12, 3, " - Reread tagline file");
		mvwaddstr(list->win, LINES - 12, 28, " - Manual enter tagline");
		mvwaddstr(list->win, LINES - 13, 28,
			" - Random select tagline");
		wattrset(list->win, C_TKEYSTEXT);
		wmove(list->win, LINES - 14, 1);
		whline(list->win, ACS_HLINE, COLS - 4);
		mvwaddstr(list->win, LINES - 13, 54, "Enter");
		mvwaddch(list->win, LINES - 13, 2, 'Q');
		mvwaddch(list->win, LINES - 12, 2, 'F');
		mvwaddch(list->win, LINES - 12, 27, 'E');
		mvwaddch(list->win, LINES - 13, 27, 'R');
	}
	ReadFile();
	if (!nodraw) {
		// keyboard handling
		int c = 0;
		keyEnd = 0;
#ifdef SIGWINCH
		currTagw = this;
#endif
		do {
			Draw();
			doupdate();
			do
				c = wgetch(list->info);
			while (c == ERR);
			switch (c) {
			case 'q':
			case 'Q':
			case '\033':
			case '\r':
			case '\n':
				keyEnd = 1;
				break;
			case 'e':
			case 'E':
				EnterTagline();
				break;
			case 'f':
			case 'F':
				ReadFile();
				break;
			case 'r':
			case 'R':
				RandomTagline();
				break;
			case '+':
			case KEY_DOWN:
			case KEY_RIGHT:
				Move(DOWN);
				break;
			case '-':
			case KEY_UP:
			case KEY_LEFT:
				Move(UP);
				break;
			case 'b':
			case 'B':
			case KEY_PPAGE:
				Move(PGUP);
				break;
			case ' ':
			case KEY_NPAGE:
				Move(PGDN);
				break;
			case KEY_HOME:
				Move(HOME);
				break;
			case KEY_END:
				Move(END);
				break;
			}
		} while (!keyEnd);
#ifdef SIGWINCH
		currTagw = NULL;
#endif
		if (((c == '\n') || (c == '\r')) && (NumOfTaglines > 0))
			letterwindow.set_Tagline(getTextOf(active));
		this->~TaglineWindow();
	}
}

TaglineWindow::~TaglineWindow()
{
	DestroyChain();
	delete list;
	interface->screentouch();
	switch (interface->active()) {
	case arealist:
	case letterlist:
		interface->activeList()->ReDraw();
		helpwindow.redraw();
		break;
	case letter:
		letterwindow.ReDraw();
	default:;
	}
}

void TaglineWindow::RandomTagline()
{
	int i, j;

	i = rand() / (RAND_MAX / NumOfTaglines);
	Move(HOME);
	for (j = 1; j <= i; j++)
		Move(DOWN);
	Draw();
}

void TaglineWindow::EnterTagline(char *tag)
{
	int y;
	char newtagline[TAGLINE_LENGTH + 1];
	FILE *fd;

	Move(END);
	if (NumOfTaglines >= list_max_y) {
		y = list_max_y;
		position++;
	} else
		y = NumOfTaglines + 1;
	active++;
	if (!nodraw)
		Draw();
	else {
		list = new InfoWin(5, COLS - 2, 10, 1, C_TBBACK);
		wattrset(list->win, C_TTEXT);
		mvwaddstr(list->win, 1, 1, "Enter new tagline:");
		wrefresh(list->win);
	}

	if (tag)
		strcpy(newtagline, tag);
	else
		newtagline[0] = '\0';

	if (list->getstring((nodraw) ? 2 : y, 1, newtagline,
		TAGLINE_LENGTH, C_TENTER, C_TENTERGET)) {

		char *p;
		for (p = &newtagline[strlen(newtagline) - 1];
		     (p > newtagline) && (*p == ' '); p--);	//crop spaces

		*++p = '\0';

		if (newtagline[0]) {
			tagline *curr = &head;
			//check dupes
			while (curr && strcmp(newtagline, curr->text))
				curr = curr->next;
			if (!curr)
				if ((fd = fopen(mm.resourceObject->
				get(TaglineFile), "at"))) {
					fputs(newtagline, fd);
					fputc('\n', fd);
					fclose(fd);
				}
			ReadFile();
		}
	}
	Move(END);
	if (!nodraw) {
		Draw();
		doupdate();
	} else
		wrefresh(list->win);
}

void TaglineWindow::ReadFile()
{
	FILE *fd;
	tagline *curr;

	NumOfTaglines = 0;
	DestroyChain();
	if ((fd = fopen(mm.resourceObject->get(TaglineFile), "rt"))) {
		position = 0;
		active = 0;
		curr = &head;
		while (fgets(curr->text, TAGLINE_LENGTH, fd)) {
			//cut the \n down
			if (curr->text[strlen(curr->text) - 1] == '\n')
				curr->text[strlen(curr->text) - 1] = '\0';
			curr->next = new tagline;
			curr = curr->next;
			NumOfTaglines++;
		}
	}
}

void TaglineWindow::DestroyChain()
{
	tagline *curr, *tmp;

	curr = head.next;
	while (curr) {
		tmp = curr;
		curr = curr->next;
		delete tmp;
	}
	head.next = NULL;
}

void TaglineWindow::oneLine(int i)
{
	int j;

	wattrset(list->info, C_TLINES);
	if (position + i == active)
		wattron(list->info, A_REVERSE);
	wmove(list->info, i, 0);
	if (position + i > NumOfTaglines)
		for (j = 0; j < TAGLINE_LENGTH; j++)
			waddch(list->info, ' ');
	else
		wprintw(list->info, "%-76s", getTextOf(position + i));
}

void TaglineWindow::ReDraw()
{
	wnoutrefresh(list->win);
	wnoutrefresh(list->info);
	doupdate();
}

int TaglineWindow::NumOfItems()
{
	return NumOfTaglines;
}

const char *TaglineWindow::getTextOf(int num)
{
	int i;
	tagline *curr;

	curr = &head;
	for (i = 1; (i <= num) && (i < NumOfTaglines); i++)
		curr = curr->next;
	return curr->text;
}

#ifdef SIGWINCH
void TaglineWindow::sigwinch()
{
	keyEnd = 1;
	interface->sigwinch();
}
#endif
