{$A+,B-,D-,E-,F-,I-,L-,N-,O-,R+,S+,V-}
{$M 16384,0,655360}

program mailto;

{
  A quick and dirty mail utility by Peter Summers
  <U5533129@ucsvc.ucs.unimelb.edu.au>

  Uses code from a variety of sources.

  Free distributable.
}

uses dos,crt,novell;

const   months   : array[1..12] of string = ('Jan','Feb','Mar','Apr','May',
                     'Jun','Jul','Aug','Sep','Oct','Nov','Dec');
        ver = 'v1.01';

var     target   : string;
        subject  : string;
        message  : string;
        filename : string;
        infile   : text;
        outfile  : text;
        station  : integer;
        sender   : string;
        hexid    : string;
        retcode  : integer;
        i        : integer;
        year     : integer;
        month    : integer;
        day      : integer;
        hour     : integer;
        minute   : integer;
        second   : integer;
        dow      : integer;
        version  : string;
        c : char;


function apiavailable : boolean;
{ double check to see if we are logged in to a server }
begin
  apiavailable := false;
  get_server_version(version);
  if (version <> '') then
    apiavailable := true;
end;


function zstr(numb:integer):string;
  var   temp     : string;

  begin
    str(numb,temp);
    if numb<10 then zstr:='0'+temp else zstr:=temp;
  end;


begin { mailto main }

  if paramcount<2 then
    begin
      writeln('Simple Pegasus-compatible file mailer. - Peter Summers, 23 Sep 93');
      writeln('USAGE: MAILTO <user> <file> [<subject>]');
      halt(1);
    end;

  getstation(station,retcode);
  if not apiavailable or (station=0) then
    begin
      writeln('You MUST be logged in to a Novell server to send messages.');
      halt(2);
    end;
  getuser(station,sender,retcode);

  target:=paramstr(1);
  gethexid(target,hexid,retcode);
  if retcode<>0 then
    begin
      writeln('No user ',target,' found on this server.');
      writeln('This utility can only send messages to known users on your default server.');
      halt(3);
    end;

  get_server_datetime(year,month,day,hour,minute,second,dow);

  subject:=paramstr(3);
  for i:=4 to paramcount do
    subject:=subject+' '+paramstr(i);

  assign(infile,paramstr(2));
  reset(infile);
  if IOresult<>0 then
    begin
      writeln('Can''t read file ',paramstr(2));
      halt(4);
    end;

  randomize;
  filename:='SYS:MAIL\'+hexid+'\';
  for i:=1 to 8 do
    filename:=filename+chr(ord('A')+random(26));
  filename:=filename+'.CNM';
  assign(outfile,filename);
  rewrite(outfile);
  if IOresult<>0 then
    begin
      writeln('Can''t write file '+filename);
      halt(5);
    end;
  writeln(outfile,'From:     '+sender);
  writeln(outfile,'To:       '+target);
  writeln(outfile,'Date:     ',day,' ',months[month],' ',zstr(year),' '
    ,zstr(hour),':',zstr(minute),':',zstr(second));
  writeln(outfile,'Subject:  '+subject);
  writeln(outfile,'X-Mailer:  MAILTO ',ver);
  writeln(outfile);
  repeat
    readln(infile,message);
    writeln(outfile,message);
  until (IOresult<>0) or eof(infile);
  close(outfile);

  send_message_to_username(target,'Mail from '+sender+', '+
    zstr(hour)+':'+zstr(minute)+': "'+subject+'"',retcode);
  writeln;
  if retcode=0 then
    writeln(paramstr(2)+' sent to '+target+'.')
  else
    writeln(paramstr(2)+' left for '+target+'.');
  delay(500);
end.
