/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPUDUMP.C
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: Functions to select a Dispatcher Filter
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPUFILT.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPU/VCS/DPUFILT.C_V  $
**              
**                 Rev 1.0   25 Oct 1990 15:27:12   etstjan
**              Initial revision.
*************************************************************************/
#include <stdarg.h>                         /* for (,...) */
#include <stdio.h>                          /* for NULL */
#include <power3.h>
#include <dp.h>
#include "dpu.h"                            /* main include file */

#define NROW        0

static int FiltElem = 0;
#ifdef MULTIFILTERS
static DPFILT *AddFilt(int srow, int scol);
static int ProcSelectFiltList(PWWIN *pWin, int action, int element);
static int FiltListElem = 0;
static int nFiltList;
static DPFILT **FiltArray;
#endif

#ifdef MULTIFILTERS
static DPFILT *AddFilt(int srow, int scol)
{
    if (pw_select(srow, scol, NROW, 12, "Filter", ProcSelectFilt, &FiltElem) != PWK_ESC)
        return DpFiltAvailable[FiltElem];
    else
        return (DPFILT *)0;
}
#endif

static int ProcSelectFiltList(PWWIN *pWin, int action, int element)
{
/*    int i; */
/*    DPFILT *pFilt; */

    switch (action)
    {
    case PWA_INIT:
        pw_shade(pWin);
        pw_keyinfo(pWin, NULL, "Ins=Add  Del=Delete  Enter=Accept");
        break;
    case PWA_COUNT:
        element = 0;
        while (DpFiltAvailable[element])
            element++;
        element++;                          /* for none */
/* nFiltList = element */
        break;
    case PWA_DISPLAY:
        if (DpFiltAvailable[element])
            pw_puts(pWin, DpFiltAvailable[element]->Name);
        else
            pw_puts(pWin, "None");
        break;
    case PWA_FIRSTCHAR:
        element = (DpFiltAvailable[element]) ? *(DpFiltAvailable[element]->Name) : 'N';
        break;
#ifdef MULTIFILTERS
    case PWA_INSERT:
        if (nFiltList < DPMAXFILT-1)
        {
            if (pFilt = AddFilt(pw_winsrow(pWin), pw_winscol(pWin)+pw_winncol(pWin)+2))
            {
                i = 0;
                while ((DpFiltAvailable[i]) && (DpFiltAvailable[i] != pFilt))
                    i++;
                if (!DpFiltAvailable[i])
                {
                    for (i=nFiltList; i>element; i--)
                        DpFiltAvailable[i] = DpFiltAvailable[i-1];
                    DpFiltAvailable[element] = pFilt;
                    DpFiltAvailable[++nFiltList] = (DPFILT *)0;
                }
            }
        }
        break;
    case PWA_DELETE:
        if (nFiltList)
        {
            nFiltList--;
            for (i=element; i<nFiltList; i++)
                DpFiltAvailable[i] = DpFiltAvailable[i+1];
            DpFiltAvailable[nFiltList] = (DPFILT *)0;
        }
        break;
#endif
    case PWA_ENTER:
        if (DpFiltAvailable[element])
            DpFiltStart(DpFiltAvailable[element]);
        element = -1;
        break;
    }
    return element;
}

#ifdef MULTIFILTERS
void DpuSelectFilt(int srow, int scol, DPFILT **FilterArray)
{
    FiltArray = FilterArray;
    pw_select(srow, scol, 10, 12, "Filter list", ProcSelectFiltList, &FiltListElem);
}
#else
/************************************************************************
** NAME:        DpuSelectFilt
** SYNOPSIS:    void DpuSelectFilt(srow, scol, pFilt)
**              int srow,scol       Window position
**              DPFILT **pFilt      Ptr to filter array
** DESCRIPTION: Let the user select a Dispatcher Filter
** RETURNS:     void
**                The 'pFilt' variable will hold the ptr to
**                the selected Dispatcher Filter.
*************************************************************************/
void DpuSelectFilt(srow, scol, pFilt)
int srow;
int scol;
DPFILT **pFilt;
{
    int FiltElem = 0;

    while ((DpFiltAvailable[FiltElem]) && (DpFiltAvailable[FiltElem] != *pFilt))
        FiltElem++;
    if (*pFilt)
        DpFiltStop(*pFilt);
    if (pw_select(srow, scol, NROW, 12, "Filter", ProcSelectFiltList, &FiltElem) != PWK_ESC)
        *pFilt = DpFiltAvailable[FiltElem];
}
#endif

