/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dprec.c
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.1
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: Dispatcher's packet receive function
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   DPREC.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/NPD/DP/VCS/DPREC.C_V  $
**              
**                 Rev 1.1   01 Feb 1991 14:20:54   etstjan
**              
**                 Rev 1.0   26 Oct 1990 12:27:44   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/NPD/DP/VCS/DPREC.C_V   1.1   01 Feb 1991 14:20:54   etstjan  $";
#endif
#include <stdio.h>                          /* for memcpy() */
#include <memory.h>                         /* for memcpy() */
#include <dos.h>                            /* for _enable, _disable */
#include <error.h>
#include "dpinc.h"


extern DPBUF *pFirstFreeSmall;             /* used in dpbuf.c   JvO */ 
extern DPBUF *pFirstFreeLarge;             /* used in dpbuf.c   JvO */
extern DPBUF *pTailQueue;                /* used in dpbuf.c   JvO */

static DPBUF *pStatBufTable[DPMAXDEV];


/**************************************************************
** NAME:        DpDevGetBuf
** SYNOPSIS:    byte far * pascal far DpDevGetBuf(Dev, len)
**              int Dev;
**              unsigned len;
** DESCRIPTION: Called by packet driver to request a pointer
**              to a buffer.
** RETURNS:     NULL, no buffers left.
**              else pointer to buffer.
**************************************************************/
unsigned char far * pascal far DpDevGetBuf(int Dev, unsigned len)
{
    long ReceiveTime;          /* Store time first */
    DPBUF *pStatBuf = NULL;

    TRACECOUNT(1+Dev,75);
    _disable();
    ReceiveTime = clock_us();
    DpDevActive[Dev].Stat.TotalPackets++;   /* AK Added global counters */
    DpDevActive[Dev].Stat.TotalBytes+=len;
    if (len <= DpInitTable.SmallSize)
    {
        pStatBuf = pFirstFreeSmall;
        if (pFirstFreeSmall != NULL)
            pFirstFreeSmall = pFirstFreeSmall->pNext;
    }  
    else
        if (len <= DpInitTable.LargeSize)
        {
            pStatBuf = pFirstFreeLarge;
            if (pFirstFreeLarge != NULL)
                pFirstFreeLarge = pFirstFreeLarge->pNext;
        }
    _enable();
    if (pStatBuf!=NULL)
    {
        pStatBufTable[Dev] = pStatBuf;
        pStatBuf->ClockMs = ReceiveTime;    
        pStatBuf->Dev  = Dev;
        pStatBuf->Size = len;
        pStatBuf->pNext = NULL;
        return pStatBuf->pBuf;
    }
    else
    {
        pStatBufTable[Dev] = NULL;
        DpDevActive[Dev].Stat.MissedPackets++;
        DpDevActive[Dev].Stat.MissedBytes += len;
        return NULL;                 /* Should be NULL, but packet is prob. wrong */
    }
}


/**************************************************************
** NAME:        DpDevBufready
** SYNOPSIS:    void pascal far DpDevBufready(int Dev)
** DESCRIPTION: Called by packet driver when buffer is filled
**              with a complete packet.
** RETURNS:     void
**************************************************************/
void pascal far DpDevBufready(int Dev)
{
    _disable();
    if (pStatBufTable[Dev])
    {
        pTailQueue->pNext = pStatBufTable[Dev];
        pTailQueue = pStatBufTable[Dev];
        TRACECOUNT(1+Dev,76);
    }
    _enable();
}



