#ifndef ERROR
#define ERROR

#define ERR_INI ErrIni
#define ERR_ERR ErrError
#define ERR_DEB ErrDebug

/* Time Critical Debug Statements... */
#define ERR_DEB1 if (DebugLevel>=1) ErrDebug
#define ERR_DEB2 if (DebugLevel>=2) ErrDebug
#define ERR_DEB3 if (DebugLevel>=3) ErrDebug
#define ERR_DEB4 if (DebugLevel>=4) ErrDebug
#define ERR_DEB5 if (DebugLevel>=5) ErrDebug
#define ERR_DEB6 if (DebugLevel>=6) ErrDebug
#define ERR_DEB7 if (DebugLevel>=7) ErrDebug

#ifdef TRACE_ON
/* Fast Screen Tracer */
typedef struct
{
    unsigned char Data;
    unsigned char Attrib;
} ScreenType[25][80];

extern ScreenType far *Screen;
#define TRACESCREEN(r,c,l) ((*Screen)[r][c].Data=(unsigned char)(l))
#define TRACECOUNT(r,c)    ((*Screen)[r][c].Data++)
#else
#define TRACESCREEN(r,c,l) 
#define TRACECOUNT(r,c)    
#endif

extern int DebugLevel;

/* ERR_LEVEL */
#define ERR_MESSAGE     0
#define ERR_WARNING     1
#define ERR_CRITICAL    2
#define ERR_FATAL       3   

/* ERR_ID */
#define ERR_MIB         0
#define ERR_AGT         1
#define ERR_MGT         2
#define ERR_DPA         3
#define ERR_PWA         4
#define ERR_NPD         5 
#define ERR_BUF         6 
#define ERR_MAT         7 
#define ERR_SDM         8 
#define ERR_PCA         9

int
    ErrIni
    (
        void
    );

void
    ErrDebug
    (
        int     Id,
        int     Level,
        char    *Format,
        ...
    );

void
    ErrError
    (
        int     Id,
        int     Level,
        char    *Format,
        ...
    );

#endif
