/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       load.c
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1
**     CREATION DATE:       1991/1/14
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   LOAD.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/LOAD/VCS/LOAD.C_V  $
**              
**                 Rev 1.0   31 Jan 1991 16:47:02   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/LOAD/VCS/LOAD.C_V   1.0   31 Jan 1991 16:47:02   etstjan  $";
#endif

#define IPS_DOS

#include <stdio.h>
#include <beholder.h>
#include <power3.h>
#include <bufm.h>
#include <snmp.h>
#include <mib2.h>
#include <ml.h>


#define LOADOJIDEV    AgtSck.SckOjiLen + 4
#define LOADOJIIND    AgtSck.SckOjiLen + 5
#define LOADOJILEN    AgtSck.SckOjiLen + 6 

typedef struct _LOADSIZE
{
    unsigned long       Packets;
    unsigned long       Bytes;
    unsigned long       Time;
    unsigned long       Last;
}   LOADSIZE;
typedef struct _LOADTYPE
{
    unsigned int        Type;
    unsigned long       Packets;
    unsigned long       Bytes;
    unsigned long       Time;
    unsigned long       Last;
    struct _LOADTYPE    *Next;
}   LOADTYPE;

static int  ProcessEvent (DPEVENT Event);
static void ReceivePkt (void);
static void Reset (void);
static void Start (void);
static void Stop (void);
static void FreeTime (void);
static void Show (void);
static void Hide (void);
static void KeyPressed (void);


static int              LoadInit = 0;
static int              LoadVisible = 0;
static int              LoadDevCount;
static int              LoadDevFocus = 0;
static PWWIN            *LoadWinLoad;
static PWWIN            *LoadWinSize;
static PWWIN            *LoadWinType;
static PWWIN            *LoadWinStat;
static pkt_obj          LoadTrapObj;

DPSTAT           *LoadStat [DPMAXDEV];
unsigned long    LoadTime [DPMAXDEV];
LOADSIZE         LoadSize [DPMAXDEV][21];
LOADTYPE         *LoadType [DPMAXDEV] = {NULL, NULL, NULL, NULL};


DPAPPS DpaLoad = {
    "Load",
    ProcessEvent,
    0,                                     
    DPE_START | DPE_STOP | DPE_SHOW | DPE_HIDE |DPE_RESET | DPE_RECEIVEPKT | DPE_FREETIME | DPE_KEYPRESSED,
    DPE_START | DPE_RESET | DPE_SHOW,
    0,
    -1,
    0,
    0,
    0,
    0,                                      /* Count of active filters      */
    {0}                                     /* List of active Filters       */
};


static char *LoadBarLarge[21]=
{/*  123456789012345678901 */
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",  
    "",  
    "",  
    "",  
    "",  
    "",  
    "",  
    "",  
    "",  
    ""
};



static char *LoadBarSmall[]=
{
    "          ",/* 0  */
    "         ",/* 1  */
    "         ",/* 2  */
    "        ",/* 3  */
    "        ",/* 4  */
    "       ",/* 5  */
    "       ",/* 6  */
    "      ",/* 7  */
    "      ",/* 8  */
    "     ",/* 9  */
    "     ",/* 10 */
    "    ",/* 11 */
    "    ",/* 12 */
    "   ",/* 13 */
    "   ",/* 14 */
    "  ",/* 15 */
    "  ",/* 16 */
    " ",/* 17 */
    " ",/* 18 */
    "",/* 19 */
    "" /* 20 */
  /* 1234567890 */
};     



static int ProcessEvent (DPEVENT Event)
{
    switch (Event)
    {
        case DPE_RECEIVEPKT:    ReceivePkt();   break;
        case DPE_RESET:         Reset ();       break;
        case DPE_START:         Start ();       break;
        case DPE_STOP:          Stop ();        break;
        case DPE_FREETIME:      FreeTime ();    break;
        case DPE_SHOW:          Show ();        break;
        case DPE_HIDE:          Hide ();        break;
        case DPE_KEYPRESSED:    KeyPressed ();  break;
    }
    return 0;
}



static void KeyPressed (void)
{
    unsigned Dev = DpGetKey () - '0';

    if (Dev >= (unsigned) LoadDevCount)
        return;
    LoadDevFocus = Dev;
    if (!LoadVisible)
        return;
    Hide ();
    Show ();
}

static void Show (void)
{
    int Ind;
    
    LoadWinStat = pw_open (2, 1, 2, 57, "Stat", PWM_NOSHADE, PWW_HELP);
                                    /*          1         2         3         4         5         */
                                    /*01234567890123456789012345678901234567890123456789012345678 */
    pw_printfat (LoadWinStat, -1, 0, "PacketsBytesSecondsDevice");
    pw_printfat (LoadWinStat,  0, 0, "Total                     Up           Name%8.8s", DpDevGetName (LoadDevFocus));
    pw_printfat (LoadWinStat,  1, 0, "Missed                    Rec          Intr%8d"  , DpDevGetIntr (LoadDevFocus));
    pw_printfat (LoadWinStat,  2, 0, "");
    LoadWinLoad = pw_open (6, 1, 17, 37, "Load", PWM_NOSHADE, PWW_DATA);
    pw_printfat (LoadWinLoad, 17, 0, "");
    pw_printfat (LoadWinLoad, -1, 0, "PktsBytesPerc");
    LoadWinType = pw_open (6, 39, 17, 19, "Type", PWM_NOSHADE, PWW_NORMAL);
    pw_printfat (LoadWinType, 17, 0, "");
    pw_printfat (LoadWinType, -1, 0, "TypePerc");
    for (Ind=0;Ind<17;Ind++)                    
        pw_printfat(LoadWinType, Ind, 4, "");
    LoadWinSize = pw_open (2, 60, 21, 19, "Size", PWM_NOSHADE, PWW_SPECIAL);
    pw_printfat (LoadWinSize, 21, 0, "");
    pw_printfat (LoadWinSize, -1, 0, "SizePerc");
    for (Ind=0;Ind<20;Ind++)
        pw_printfat(LoadWinSize, Ind, 0, "%4u",(Ind+1) * 75);
    pw_printfat(LoadWinSize, 20, 0, "");
    LoadVisible = 1;
}

static void Hide (void)
{
    pw_close (LoadWinLoad);
    pw_close (LoadWinSize);
    pw_close (LoadWinType);
    pw_close (LoadWinStat);
    LoadVisible = 0;
}



static void Reset (void)
{
    int         Dev;
    int         Ind;
    LOADTYPE    *Ptr;
    LOADTYPE    *Old;
    
    for (Dev=0; Dev<LoadDevCount; Dev++)
    {
        LoadTime[Dev] = 0;
        for (Ind=0; Ind<21; Ind++)
        {
            LoadSize[Dev][Ind].Packets = 0;
            LoadSize[Dev][Ind].Bytes = 0;
            LoadSize[Dev][Ind].Time = 0;
            LoadSize[Dev][Ind].Last = 0;
        }
        Ptr = LoadType[Dev];
        while (Ptr != NULL)
        {
            Old = Ptr; 
            Ptr = Ptr->Next;
            IPBufFree(Old);
        }
        LoadType[Dev] = NULL;
    }
}

static void Start (void)
{
    int Len, Dev;
    
    if (LoadInit == 0)
    {
        LoadDevCount = DpDevGetCount();
        Len = AgtSck.SckOjiLen;
        memcpy (LoadTrapObj.ObjOji, AgtSck.SckOji, Len * sizeof(int));  /* Dr.Ik 220391 -> sizeof(int) */
        LoadTrapObj.ObjOji [Len+0]=2;
        LoadTrapObj.ObjOji [Len+1]=3;
        LoadTrapObj.ObjOji [Len+2]=1;
        LoadTrapObj.ObjOji [Len+3]=1;
        LoadTrapObj.ObjOjiLen = Len+6;
        LoadTrapObj.ObjTag = PKT_INTEGER;
        for (Dev=0;Dev<LoadDevCount;Dev++)
            LoadStat[Dev]=DpDevGetStatistics (Dev);
        LoadInit = 1;
    }
}

static void Stop (void)
{
        return;
}



static void ReceivePkt (void)
{
    DPBUF               *Buf;
    int                 Dev;
    int                 Ind;
    unsigned            Length;
    unsigned            Type;
    long unsigned       Time;
    LOADTYPE            **Ptr, *New;

    Buf = DpReceivePkt ();
    Dev = Buf->Dev;
    Length = MLGetLength (Buf);
    Type = MLGetProtocol (Buf);
    Time = clock_ms () / 10;
    
    LoadTime[Dev] = Time;
    
    if ((Ind = Length / 75) > 20)
        Ind = 20;
    LoadSize[Dev][Ind].Packets++;
    LoadSize[Dev][Ind].Bytes += Length;
    LoadSize[Dev][Ind].Time = Time;
    
    for (Ptr=&LoadType[Dev];
        (*Ptr!=NULL && (*Ptr)->Type<Type);
        Ptr=&(*Ptr)->Next);           
    if ((*Ptr)->Type == Type)       /* Found Exact match */
    {
        (*Ptr)->Packets++;
        (*Ptr)->Bytes += Length;
        (*Ptr)->Time = Time;
    }
    else                            /* Not found!! */
    {
        if ((New = IPBufGet (sizeof (LOADTYPE))) == NULL)
            return;
        New->Type = Type;
        New->Packets = 1;             
        New->Bytes = Length;
        New->Time = Time;
        New->Last = 0;
        New->Next = *Ptr;
        *Ptr = New;
        LoadTrapObj.ObjOji[LOADOJIDEV] = Dev; 
        LoadTrapObj.ObjOji[LOADOJIIND] = Type; 
        LoadTrapObj.ObjSyn.SynLngInt = Type; 
        AgtSndTrp (PKT_ENTSPECIFIC, 0, &LoadTrapObj, 1);
    }
}

static void FreeTime (void)
{
    static unsigned long LastLoadBytes = 0;
    static unsigned long LastLoadPackets = 0;
    static unsigned long LastSizePackets = 0;
    static unsigned long LastTypePackets = 0;
    static unsigned long LastLoadClock = 0;
    static unsigned long LastSizeClock = 0;
    static unsigned long LastTypeClock = 0;
    static unsigned long LastStatClock = 0;
    unsigned long DeltaClock;
    unsigned long DeltaPackets;
    unsigned long DeltaBytes;
    unsigned long DeltaSizePackets;
    unsigned long DeltaTypePackets;
    unsigned long Clock;
    unsigned long Packets;
    unsigned long Bytes;
    unsigned Promille;
    int Ind;
    LOADSIZE *Size;
    LOADTYPE *Type;

    if (!LoadVisible)
        return;
    Clock=clock_ms();
    Packets=LoadStat[LoadDevFocus]->TotalPackets;
    Bytes=LoadStat[LoadDevFocus]->TotalBytes;
    DeltaClock = (Clock - LastLoadClock)/1000;
    if (DeltaClock>=1)
    {
        DeltaPackets=(Packets-LastLoadPackets)/DeltaClock;
        DeltaBytes=(Bytes-LastLoadBytes)/DeltaClock;
        Promille=(unsigned)((DeltaPackets*96L+DeltaBytes*8L+5000L)/10000L);
        if (Promille>999)
            Promille=999;
        if (DeltaPackets>9999)
            DeltaPackets=9999;
        if (DeltaBytes>9999999)
            DeltaBytes=9999999;
        pw_printf(LoadWinLoad, "\n%4lu%7lu%2u.%1u%s",
            DeltaPackets, DeltaBytes, Promille/10, Promille%10,
            LoadBarLarge[(Promille+49)/50]);
        LastLoadPackets = Packets;
        LastLoadBytes = Bytes;
        LastLoadClock = Clock;
    }
    DeltaClock = (Clock - LastSizeClock)/1000;
    if (DeltaClock>=2)
    {
        DeltaPackets=Packets-LastSizePackets;
        if (DeltaPackets==0)
            DeltaPackets=1;
        Size = LoadSize[LoadDevFocus];
        for (Ind=0;Ind<21;Ind++)
        {
            DeltaSizePackets = Size->Packets - Size->Last;
            Promille=(unsigned)(DeltaSizePackets*1000L/DeltaPackets);
            if (Promille>999)
                Promille=999;
            pw_printfat (LoadWinSize, Ind, 5, "%2u.%1u%s",
                         Promille/10,
                         Promille%10,
                         LoadBarSmall[(Promille+49)/50]);
            Size->Last = Size->Packets;
            Size++;
        }
        LastSizePackets = Packets;
        LastSizeClock = Clock;
    }
    DeltaClock = (Clock - LastTypeClock)/1000;
    if (DeltaClock>=2)
    {
        DeltaPackets=Packets-LastTypePackets;
        if (DeltaPackets==0)
            DeltaPackets=1;
        Type = LoadType[LoadDevFocus];
        for (Ind=0;Ind<17 && Type!=NULL;Ind++)
        {
            DeltaTypePackets = Type->Packets - Type->Last;
            Promille=(unsigned)(DeltaTypePackets*1000L/DeltaPackets);
            if (Promille>999)
                Promille=999;
            pw_printfat (LoadWinType, Ind, 0, "%04x%2u.%1u%s",
                         Type->Type,
                         Promille/10, Promille%10,
                         LoadBarSmall[(Promille+49)/50]);
            Type->Last = Type->Packets;
            Type = Type->Next;
        }
        LastTypePackets= Packets;
        LastTypeClock = Clock;
    }
    DeltaClock = (Clock - LastStatClock)/1000;
    if (DeltaClock>=1)
    {
        pw_printfat (LoadWinStat,0, 7,"%10lu",LoadStat[LoadDevFocus]->TotalPackets);          
        pw_printfat (LoadWinStat,1, 7,"%10lu",LoadStat[LoadDevFocus]->MissedPackets);          
        pw_printfat (LoadWinStat,0,18,"%10lu",LoadStat[LoadDevFocus]->TotalBytes);          
        pw_printfat (LoadWinStat,1,18,"%10lu",LoadStat[LoadDevFocus]->MissedBytes);          
        pw_printfat (LoadWinStat,0,33,"%10lu",Clock/1000);          
        pw_printfat (LoadWinStat,1,33,"%10lu",LoadTime[LoadDevFocus]/100);          
        LastStatClock = Clock;
    }
}

