{$I-}   {File error checking must be off.}

{    Program to monitor the log file from QL2FAX and set the error level
     appropriately.  -  Peter Summers  24 Apr 94 }

program checklog;

uses crt;

const
  logfilename : string = 'simpsndo.his';

var
  logfile        : text;
  goodline,line  : string;
  index          : integer;

begin
  if paramcount>0 then
    if paramstr(1)='/?' then begin
      writeln('CHECKLOG: checks a SIMPSNDO log file to appear and then sets');
      writeln('          the DOS errorlevel according to the result - 6 Feb 1995.');
      writeln('  by Peter Summers <peter@cardiology.medrmh.unimelb.edu.au>');
      writeln;
      writeln('SYNTAX: CHECKLOG [<logfilename>]');
      halt(2);
    end else
      logfilename:=paramstr(1);

  assign(logfile,logfilename);
  reset(logfile);
  repeat
    readln(logfile,line);
    if (IOResult<>0) then begin
      writeln('Can''t read from '+logfilename+'.');
      halt(3);
    end;
    if length(line)>0 then goodline := line;
  until eof(logfile);

  writeln(goodline);

  for index := 1 to length(goodline) do
    if goodline[index] = '-' then break;

  if index = length(goodline) then begin
    writeln('Bad entry at end of log file.');
    halt(4);
  end;

  if goodline[index+3]='f' then begin
    writeln('Fax log indicates error in sending fax.');
    halt(1);
  end else begin
    writeln('Fax log indicates fax sent correctly.');
    halt(0);
  end;

end.