/*****************************************************************************
* Definitions for the Poly3D-H program:                                      *
*****************************************************************************/

#ifndef POLY_3D_H_H
#define POLY_3D_H_H

#include "irit_sm.h"
#include "genmat.h"
#include "iritprsr.h"
#include "cagd_lib.h"

#ifdef  EPSILON
#undef  EPSILON
#endif  /* EPSILON */
#define EPSILON	1e-4  /* Make it smaller if you changed to double precision. */

#define  EDGE_HASH_TABLE_SIZE	500 /* Number of entries in edge hash table. */
#define  EDGE_HASH_TABLE_SIZE1	499		     /* One below the above. */
#define  EDGE_HASH_TABLE_SIZE2	250			   /* Half of above. */
#define  POLY_HASH_TABLE_SIZE	500 /* Number of entries in poly hash table. */
#define  POLY_HASH_TABLE_SIZE1	499		     /* One below the above. */
#define  POLY_HASH_TABLE_SIZE2	250			   /* Half of above. */

#ifdef __MSDOS__
#define  HIDDEN_COLOR	YELLOW	        /* Color to draw hidden line result. */
#else
#define  HIDDEN_COLOR	14	        /* Color to draw hidden line result. */
#endif /* __MSDOS__ */

#define  DEFAULT_FINENESS	4	  /* Default fineness of srf subdiv. */

typedef struct EdgeStruct {
    struct EdgeStruct *Pnext;
    IPVertexStruct *Vertex[2];			   /* The two edge vertices. */
    unsigned char Internal;	       /* If edge is Internal (IRIT output). */
} EdgeStruct;

/* The following are global setable variables (via config file poly3d-h.cfg) */
extern int GlblMore, GlblNumEdge, GlblBackFacing, GlblInternal;

extern int NumOfPolygons;	      /* Total number of polygons to handle. */

/* Global transformation matrix: */
extern MatrixType GlblViewMat;		   /* Current view/persp. of object. */

/* Data structures used by the hidden line modules: */
extern int EdgeCount;
extern EdgeStruct *EdgeHashTable[];
extern IPPolygonStruct *PolyHashTable[];

/* And finally the prototypes of the Poly3D-H.c module: */
VoidPtr MyMalloc(unsigned size);
void MyFree(VoidPtr p);
void MyExit(int ExitCode);

/* Prototypes of the PrepData.c module: */
void PrepareViewData(IPObjectStruct *Objects);
int CrossProd(RealType Pt1[3], RealType Pt2[3], RealType Pt3[3]);

/* Prototypes of the Out-Edge.c module: */
void OutVisibleEdges(void);

#endif /* POLY_3D_H_H */
