/* MT.C - Magnetic tape ioctl's command line interface
   $Author:   Phlash  $
   $Date:   04 Nov 1994 21:49:56  $
   $Revision:   1.0  $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include "ioctl.h"
#include "qic_drv.h"

void main(int argc, char **argv)
{
int df, rv;
qicDrvIoctl_t ioc;

   if(argc < 3)
   {
      puts("usage: mt <device file> <stat|retension|erase|complete|debug> [value]");
      return;
   }
   df = open(argv[1], O_RDWR | O_BINARY);
   if(df < 0)
   {
      perror("opening device");
      return;
   }

   if(ioctl(df, CIORDCNTRL(sizeof(ioc)), &ioc))
   {
      fprintf(stderr, "Error code 0x%X reading device configuration\n", rv);
      return;
   }
   if(strncmp(ioc.chk, QIC_CHK_VALUE, 4))
   {
      fprintf(stderr, "Invalid device check string %.4s\n", ioc.chk);
      return;
   }
   switch(argv[2][0])
   {
   case 's':
   case 'S':
      printf("Device name=%s, check value=%.4s, debug=%d, async=%s\n",
         argv[1], ioc.chk, ioc.debug, (ioc.async) ? "true" : "false");
      break;
   case 'r':
   case 'R':
      ioc.command = QIC_RETENSION;
      ioctl(df, CIOWRCNTRL(sizeof(ioc)), &ioc);
      break;
   case 'e':
   case 'E':
      ioc.command = QIC_ERASE;
      ioctl(df, CIOWRCNTRL(sizeof(ioc)), &ioc);
      break;
   case 'c':
   case 'C':
      ioc.command = QIC_COMPLETE;
      ioctl(df, CIOWRCNTRL(sizeof(ioc)), &ioc);
      printf("Wait returned %d\n", ioc.command);
      break;
   case 'd':
   case 'D':
      if(argc > 3)
      {
         ioc.debug = atoi(argv[3]);
         ioctl(df, CIOWRCNTRL(sizeof(ioc)), &ioc);
      }
      printf("Debugging level: %d\n", ioc.debug);
      break;
   }
   close(df);
}

