; IOCTL.ASM - Implements MS-DOS ioctl() function

; Notes:
;     This implementation always returns 0 on success, non-zero on failure,
;     positive return codes are MS-DOS error codes, -1 is a parameter error.

;     The size of the buffer pointed to by the third argument is stored in
;     the upper byte of the second argument. This limits the buffer size to
;     255 bytes (0xFF). Beware!

PUBLIC _ioctl

_TEXT SEGMENT PUBLIC WORD 'CODE'
         ASSUME CS:_TEXT

_ioctl   PROC  FAR

         PUSH BP
         MOV BP,SP
         PUSH DS
         MOV BX,[BP+06]
         MOV AX,[BP+08]
         XOR CH,CH
         MOV CL,AH
         MOV AH,44h
         LDS DX,[BP+10]
         CMP AL,0
         JZ  __getDevInfo
         CMP AL,1
         JZ  __setDevInfo
         CMP AL,5
         JG  __error

__doDevIoctl:
         INT 21h
         JC  __done
         XOR AX,AX
         JMP __done

__getDevInfo:
         CMP CL,2
         JB  __error
         MOV CX,DX
         INT 21h
         JC  __done
         XCHG CX,SI
         MOV [SI],DX
         XCHG CX,SI
         XOR AX,AX
         JMP __done

__setDevInfo:
         CMP CL,2
         JB  __error
         MOV CX,DX
         XCHG CX,SI
         MOV DX,[SI]
         XCHG CX,SI
         INT 21h
         JC  __done
         XOR AX,AX
         JMP __done

__error:
         MOV AX,0FFFFh
__done:
         POP DS
         POP BP
         RET

_ioctl ENDP

_TEXT ENDS

END
