/* DOS_DRV.H - Structures for MS-DOS device drivers */

/* Basic types */
typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

/* Interface structures */
#pragma pack(1)
typedef struct dhTag {
            struct dhTag far *next;
            WORD attributes;
            WORD Strategy;
            WORD Interrupt;
            char name[8];
            } DevHeader_t;

typedef struct {
            BYTE length;
            BYTE unit;
            BYTE command;
            WORD status;
            BYTE resv[8];
            BYTE media;
            BYTE far *address;
            WORD count;
            WORD sector;
            } ReqHeader_t;
#pragma pack()

/* Declare external pointers (in DOS_DRV.ASM) */
extern DevHeader_t far *DHPtr;
extern ReqHeader_t far *RHPtr;

/* Declare routines in DOS_DRV.ASM */
extern int near BIOSChr(char c);

/* End */
