{**************************************************************************

16550 - A TPBoard Sysop Utility
by Jon Schneider & Rick Petersen

This program will toggle the state of a 16550 UART's FIFO buffer.
It only seems to work with the Fossil driver X00.SYS version 1.09b.
By toggling the buffer on, even 4.77 Mhz PC's are able to receive
files at a fixed rate of 19,200 baud without error.

The code uses portions of the 'Turbo Professional' library. It
will not compile without it.

v1.1 Oh yeah?
     Toad Hall Tweak, 19 Apr 90
  - Wrote the single stupid string-uppercasing function
    that required the "Turbo Professional" library.
  - Tightened up the code.
  - Replaced "original" variable names with more "usual" ones
    (like argc).
  - Changed source case to my preferred standards.
  - This code makes NO attempt to confirm if you have a 16550 UART or not.
    (Heck, I donno HOW to make such a test.)
    If you run this on your good old 8550 or whatever .. who know WHAT'll
    happen, ne?
v1.2 Another minor tweak.
v1.3 29 Mar 91:
    Finally found a UART-identifying function (FIDO Assembly Language Echo).
    Integrating that code (tweaked, of course).

    David Kirschbaum
    Toad Hall

**************************************************************************}

{$R-}    {Range checking off}
{$B-}    {Boolean complete evaluation off}
{$S-}    {Stack checking off}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M $4000, $4000, $A0000}


PROGRAM a16550;

TYPE
  uarttype = (u_unk,u8250,u16450,u16550,u16550A);  {v1.3}
  Str6 = STRING[6];

CONST
  UartStr : ARRAY[uarttype] OF Str6 =     {v1.3}
            ('??????','  8250',' 16450',' 16550','16550A');

VAR
   State : STRING;
   comport : Word;
   i,code : INTEGER;

PROCEDURE Usage;
BEGIN
   WRITELN;
   WRITELN('16550 - A TPBoard utility for toggling the 16550''s FIFO buffer');
   WRITELN;
   WRITELN('USAGE:  16550 [1-4] [on/off/?]');
   WRITELN;
   WRITELN('Where ''1'' thru ''4'' is the COM port,  ''on'' or ''off'' will toggle');
   WRITELN('the FIFO buffer''s state, and ''?'' will show its status. Turning');
   WRITELN('the buffered mode on is guaranteed to lock up your system if you');
   WRITELN('are using OpusCom, and may cause problems with other programs.');
   WRITELN('It WILL work with X00 version 1.09b, TPBoard, and ProComm Plus.');
   WRITELN;
   HALT
END;


FUNCTION StUpcase(S : STRING) : STRING;
  {v1.1 Return S uppercased}
  VAR i : INTEGER;
  BEGIN
    FOR i := 1 TO LENGTH(S) DO
      S[i] := Upcase(S[i]);
    StUpcase := S;  {return the function}
  END;   {of StUpcase}


FUNCTION Type_Uart(comport : INTEGER) : uarttype;
  {v1.03 Return type UART}
  VAR
    xbyte2,xbyte3 : BYTE;
    temp : INTEGER;
    u : uarttype;
    p2,p7 : word;
   BEGIN
    p2 := comport+2;
    p7 := comport+7;
    xbyte2 := Port[p2];
    Port[p2] := $C1;
    FOR temp := 1 TO 2 DO;           {delay a tick}
    xbyte3 := Port[p2];
    Port[p2] := xbyte2;
    CASE ((xbyte3 AND $C0) ShR 6) OF
      0: BEGIN
           xbyte2 := Port[p7];
           Port[p7] := $FA;
           FOR temp := 1 TO 2 DO;
           IF Port[p7] = $FA THEN BEGIN
             Port[p7] := $AF;
             FOR temp := 1 TO 2 DO;
             IF Port[p7] = $AF THEN BEGIN
                Port[p7] := xbyte2;
               u := u16450;
             END
             ELSE u := u8250;
           END
           ELSE u := u8250;
         END;
      1: u := u_unk;
      2: u := u16550;
      3: u := u16550A;
    END;  {case}
    Writeln('UART type:  ',UartStr[u]);  {say something clever}
    Type_Uart := u;  {return function}
  END;  {of Type_Uart}


BEGIN  { 16550 }
   IF ParamCount < 2       {need 2 parms v1.2}
   THEN Usage;             {dummy v1.2}

(* Old code
   State := ParamStr(1);   {v1.2}
   Ch := State[1];         {can't do this to ParamStr(),
                            but CHAR comparisons are SO much faster v1.2}
   IF      Ch = '1' THEN comport := $3fa
   ELSE IF Ch = '2' THEN comport := $2fa
   ELSE IF Ch = '3' THEN comport := $3ea
   ELSE IF Ch = '4' THEN comport := $2ea
   ELSE Usage;
*)
   {v1.2, v1.3: new code}
   Val(ParamStr(1),i,code);       {Pick up 1..4}
   IF (code <> 0)                 {not a number}
   OR NOT (i IN [1..4])           {not in range COM1..COM4}
   THEN Usage;                    {dummy}

   comport := MemW[$40 : Pred(i) ShL 1 ];  {40:00 = COM1,
                                            40:02 = COM2, etc.}

   IF NOT (Type_Uart(comport) IN [u16550,u16550A])
   THEN BEGIN
     Writeln('Sorry: FIFO buffer only in the 16550 family');
     Halt(1);
   END;

   State := StUpcase(ParamStr(2));
   IF      State = 'ON'  THEN Port[comport] := $07
   ELSE IF State = 'OFF' THEN Port[comport] := $00
   ELSE IF State = '?' THEN BEGIN
       {v1.1 New code}
       WRITE('FIFO buffer is turned ');
       IF (Port[comport] AND $C0) = $C0
       THEN WRITELN('ON.')
       ELSE WRITELN('OFF.');
   END
   ELSE Usage;
END.
