
/*

           - MPATCH LIB HEADER -

	(C) Copyright 1995/96 Maurizio Giunti


      For any info please contact me:

        Internet: giunti@kagi.com
                  giunti@abeline.it
                  giunti@statsun.ds.unifi.it
         Fidonet: 2:332/102.3


*/




#ifndef _MPTLIB_H_
#define _MPTLIB_H_

/* MDF - Algorithm version: 1.50 */


/* *.MDF header info structure */
struct MDF_header_info
    {
     char alg_ver[4];          /* Algorithm version */
     char oldfilename[256];    /* Old file name stored in MDF */
     char newfilename[256];    /* New file name stored in MDF */
     char registeredto[256];   /* Registered to */
     char comment[2048];       /* Comment stored in MDF */
     unsigned long oldfilecrc; /* Old file CRC-32 */
     short chunk_len;          /* Chunk length */
     unsigned long n_chunks;   /* Number of chunks */
     short password;	       /* 0=No, 1=yes */
};


/* Functions */

short MDF_ReadHead(char *fn,struct MDF_header_info *hi);
/*
  Reads header from a .mdf file
   Returns:
     0 = File not found
     1 = OK
    -1 = Not a MDIFF file
    -2 = Wrong MDF version
*/

short MDF_Patch(char *diffile, char *oldfile, char *newfile);
/*
  Applies the patch file named diffile to the old file
  named oldfile to create a brand new newfile

  Returns:
  -1     "Can't run more than one patch at a time!"
   0     "OK!"
   1     "Out of memory!"
   2     "Can't open MDF file!"
   3     "Invalid MDF file!"
   4     "MDF file version mismatch!"
   5     "UNREGISTERED!"
   6     "Incorrect OLD file!"
   7     "Can't open OLD file!"
   8     "Can't create NEW file!"
   9     "General failure: NEW file corrupted!"
  10     "OLD and NEW can't be the same file!"
  11     "NEW file was already patched!"
  12     "Wrong password!"
*/

char *MDF_LastError(void);
/*
  Gets the description of the last error occurred
*/

char *MDF_Error(short e);
/*
  Gets the description of the error number e
*/

void MDF_SetIdle(void (*idl)(void),short rate);
/*
  Set idl() as the current idle function
  idl() will be called each rate chunks applied
  when working on a patch (MDF_Patch())
*/

void MDF_SetPassword(char *a);
/*
  Set the password to use to decrypt the next patch
*/

unsigned long FileCrc32(char *fn);
/*
  Computes Crc 32 bit of the file named fn
*/

unsigned long StrCrc32(char *a);
/*
  Computes Crc 32 bit of the string a
*/


#endif
