procedure show_time;
begin
  status_color;
  gotoxy(66,status_line);
  write(' ',date,' ',time);
  gotoxy(xin,yin);
end;

procedure disp_time;
begin
  if time <> old_time then
  begin
    old_time := time;
    show_time;
  end;
end;

procedure disp_xmt_wpm;
begin
  gotoxy(6,status_line);
  status_color;
  write(xmt_wpm:2);
  gotoxy(xin,yin);
end;

procedure disp_rcv_wpm;
begin
  gotoxy(16,status_line);
  status_color;
  write(rcv_wpm:2);
  gotoxy(xin,yin);
end;

procedure cw_status_line;
begin
  write('CW      xmt,      rcv ');
  disp_xmt_wpm;
  disp_rcv_wpm;
end;

procedure rtty_ascii_line;
begin
  write(baud_rate[baud]:3,' baud, ',rtty_shift[shift]:5,' shift ');
  gotoxy(55,status_line);
  case invert of
    TRUE          : write(' INVERT ');
    FALSE         : write(' NORMAL ');
  end;
  gotoxy(xin,yin);
end;

procedure rtty_status_line;
begin
  write('RTTY ');
  rtty_ascii_line;
end;

procedure ascii_status_line;
begin
  write('ASCII ');
  rtty_ascii_line;
end;

procedure packet_status_line;
begin
  case band of
    HF : write(' HF ');
    VHF : write('VHF ');
  end;
  write('PACKET');
  gotoxy(30,status_line);
  write('Call: ',PKCall);
end;

procedure sho_status;
begin
  gotoxy(1,status_line);
  status_color; ClrEol;
  case mode of
    CW    : cw_status_line;
    RTTY  : rtty_status_line;
    ASCII : ascii_status_line;
    PACKET: packet_status_line;
  end;
  if mode in [CW,RTTY,ASCII] then
  begin
    Gotoxy(33,status_line);
    case state of
      transmit      : write(' TRANSMIT ');
      receive       : write(' RECEIVE  ');
    end;
    case auto_switch of
      TRUE          : write('AUTO T/R ');
      FALSE         : write('MAN  T/R ');
    end;
  end;
  show_time;
  gotoxy(1,aux_line); aux_color; ClrEol;
  write('Msgs:',msg_file_name:14);
  if (capture = TRUE) then
  begin
    gotoxy(70,aux_line);
    write('CAPTURE ON');
  end;
  gotoxy(xin,yin);
end;

procedure check_if_in_help;
begin
  if viewing_help then
  begin
    restore_screen;
    viewing_help := FALSE;
  end;
end;

procedure new_rtty_baud;
begin
  check_if_in_help;
  baud := baud + 1;
  if baud = 9 then
    case mode of
      RTTY  : baud := 0;
      ASCII : baud := 5;
    end;
  set_rtty_baud;
  sho_status;
end;

procedure new_rtty_shift;
begin
  check_if_in_help;
  shift := shift + 1;
  if shift = 4 then shift := 0;
  set_rtty_shift;
  sho_status;
end;

procedure flip_invert;
begin
  mod_rtty_invert;
  sho_status;
end;

procedure change_speed;
var err, old_wpm: integer;
begin
  check_if_in_help;
  xmt_wpm := rcv_wpm;
  val(xmt_wpm, int_wpm, err);
  if err <> 0 then
  begin
    int_wpm := old_wpm;
    str(int_wpm, xmt_wpm);
  end;
  kam_xmt_wpm;
  sho_status;
end;

procedure set_speed;
begin
  check_if_in_help;
  prompt_color;
  {$I-}
  repeat
    gotoxy(5,status_line);
    write('    <==');
    gotoxy(6,status_line);
    read(int_wpm);
  until (IOresult = 0) AND (int_wpm > 4) and (int_wpm < 81);
  str(int_wpm,xmt_wpm);
  kam_xmt_wpm;
  sho_status;
end;

procedure clear_transmit_screen;
begin
  check_if_in_help;
  window(1,out_start_line,80,out_end_line);
  transmit_color; clrscr;
  full_window;
  xkbd := 1; ykbd := out_start_line;
  attr_pos := ((80*(yout - 1) + xout) SHL 1) - 1;
  halt_xmt;
end;

procedure clear_receive_screen;
begin
  check_if_in_help;
  window(1,inp_start_line,80,inp_end_line);
  receive_color;  clrscr;
  xin  := 1; yin  := inp_start_line;
  full_window;
end;

procedure clear_screen;
begin
  check_if_in_help;
  clear_receive_screen;
  clear_transmit_screen;
  sho_status;
  gotoxy(1,25); aux_color; ClrEol;
  case mode of
    CW           : write(
' ^P pause   AS %    AR +     <<< F1 for Help >>>    BT =   SK #   KN (  ^T T/R ');
    RTTY, ASCII  :write(
' ^P pause                    <<< F1 for Help >>>                        ^T T/R ');
    PACKET       : write(
' ALT <D>is<K>onnect  <L>calllist  <H>f <V>hf  <I>id  <Z>cmd  <X>exit  <F1> help');
    AMTOR        :write(
'                             <<< F1 for Help >>>                               ');
  end;
  gotoxy(xout,yout);
end;

procedure msg_load;
var i : integer;
    msgfile: text;
begin
  check_if_in_help;
  assign(msgfile,msg_file_name);
  {$I-}
  reset(msgfile);
  {$I+}
  if (IOresult = 0) then
  begin
    for i := 0 to 9 do
      readln(msgfile,msg[i]);
    close(msgfile);
  end
  else
  begin
    msg_file_name := '';
    for i := 0 to 9 do
      msg[i] := '';
  end;
end;

procedure save_buffer;
label save_fault;
var i : integer;
    rcv_file_name : file_type;
    rcvfile: text;
begin
  rcv_file_name := '';
  if state = transmit then halt_xmt;
  check_if_in_help;
  prompt_color;
  Set_PickWindow_To(10,5,25,22,SingleLine,'Files');
  SayGet(20,aux_line,'Receive (or ?) ',rcv_file_name,_S,24,1);
  WatchKeys := ['?'];
  ReadGets;
  if LastKey = '?' then rcv_file_name := PickFile('*.*');
  if (rcv_file_name <> '') then
  begin
    assign(rcvfile,rcv_file_name);
    {$I-}
    rewrite(rcvfile);
    if (IOresult = 0)
    then
      for i := 0 to max_rcv_buffers do
        begin
          if rcv_buffer[i]^[0] <> #0 then
            write(rcvfile,rcv_buffer[i]^);
          if (IOresult <> 0) then goto save_fault;
        end
    else
      begin
        gotoxy(20,aux_line); ClrEol;
        write('ERROR');
        delay(2000);
      end;
save_fault:
    close(rcvfile);
  end;
  sho_status;
end;

procedure view_modify_msgs;
var i : integer;
    nbr, index : integer;
    input_str : string[79];
    nbr_chr : char;
begin
  if state = transmit then halt_xmt;
  check_if_in_help;
  save_screen;
  transmit_color;
  clrscr;
  writeln('Contents of message file: ',msg_file_name);
  writeln;
  for i := 0 to 9 do
  begin
    writeln('Buffer # ',i:1);
    writeln;
  end;
  sayget(1,4,'',msg[0],_S,80,1);
  sayget(1,6,'',msg[1],_S,80,1);
  sayget(1,8,'',msg[2],_S,80,1);
  sayget(1,10,'',msg[3],_S,80,1);
  sayget(1,12,'',msg[4],_S,80,1);
  sayget(1,14,'',msg[5],_S,80,1);
  sayget(1,16,'',msg[6],_S,80,1);
  sayget(1,18,'',msg[7],_S,80,1);
  sayget(1,20,'',msg[8],_S,80,1);
  sayget(1,22,'',msg[9],_S,80,1);
  readgets;
  restore_screen;
end;

procedure load_messages;
begin
  if state = transmit then halt_xmt;
  check_if_in_help;
  prompt_color;
  Set_PickWindow_To(10,5,25,22,SingleLine,'Files');
  SayGet(20,aux_line,'Message File (or ?) ',msg_file_name,_S,24,1);
  WatchKeys := ['?'];
  ReadGets;
  if LastKey = '?' then msg_file_name := PickFile('*.*');
  if (msg_file_name <> '') then msg_load;
  sho_status;
end;

procedure save_messages;
label save_fault;
var i : integer;
    msgfile: text;
begin
  if state = transmit then halt_xmt;
  check_if_in_help;
  prompt_color;
  Set_PickWindow_To(10,5,25,22,SingleLine,'Files');
  SayGet(20,aux_line,'Message File (or ?) ',msg_file_name,_S,24,1);
  WatchKeys := ['?'];
  ReadGets;
  if LastKey = '?' then msg_file_name := PickFile('*.*');
  if (msg_file_name <> '') then
  begin
    assign(msgfile,msg_file_name);
    {$I-}
    rewrite(msgfile);
    if (IOresult = 0)
    then
      begin
        for i := 0 to 9 do
          begin
            writeln(msgfile,msg[i]);
            if (IOresult <> 0) then goto save_fault;
          end;
save_fault:
        close(msgfile);
      end
    else
      begin
        gotoxy(20,aux_line); ClrEol;
        write('ERROR');
        delay(2000);
      end;
  end;
  sho_status;
end;

procedure exit_request;
begin
  save_screen;
  prompt_color;
  window(6,6,29,8);
  clrscr;
  gotoxy(1,2);
  write('Exit to DOS <Y/N> ..');
  repeat key := readkey until key in ['y','n','Y','N'];
  if key in ['y','Y'] then
    quit_flag := true;
  restore_screen;
end;
