static char *header = "\n\
                                                                            \n\
/*                                                                          \n\
 *	rifs.c  --  Random Iterated Function System.                        \n\
 *	Theory from M. Barnsley 'Fractals Everywhere' (ISBN 0-12-079062-9). \n\
 *                                                                          \n\
 *	4 june 1989  Olle Olsson  (olle@ergodata.se).                       \n\
 */                                                                         \n\
                                                                            \n\
                                                                            \n\
";

#include <conio.h>
#include <process.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include "ifs.h"


/* max number of transforms */
#define NTRANSF 50

/* max group index */
#define MAXGROUP (NTRANSF/2)

/* global trace flag */
int trace;

/* the transformations */
static transform trf[NTRANSF];	/* (could have been a linked list...) */

/* the colors (palette) */
static rgb colors[MAXCOLORS + 1];

/* locals */
void usage( void );

void usage()
{
printf( "Usage:\n\trifs options\n\n" );
printf( "options are:\n" );
printf( "\t-l number\tlower limit for transformation count\n" );
printf( "\t-u number\tupper limit for transformation count\n" );
printf( "\t-d number\tdensity scaling factor (float)\n" );
printf( "\t-n\t\tshow number of currently active transformations\n" );
printf( "\nwhen running: space bar gives another ifs.\n" );
printf( "\n" );
}

void main( argc, argv )
int argc;
char *argv[];
{
ifsdes dd;			/* ifs descriptor */
int minsize = 2;		/* minimum number of transformations */
int maxsize = 8;		/* maximum number of transformations */
int size;			/* current number of transformations */
double cscale = 1;		/* count scale (density) */
long count;			/* iterations to do */
int shown = 0;			/* show number of transformations flag */
long tm;			/* time */
int running;			/* status */
rgb *rp;			/* tmp */
char buf[100];			/* tmp */
int i;				/* tmp */
int c;
char *ap, **p;			/* argument pointers */

/* advertise */
printf( header );
sleep( 1 );


/* initialize */
dd.tp = trf;
dd.maxsize = NTRANSF;
dd.colors = colors;
dd.clrsize = sizeof (colors) / sizeof (colors[0]);
dd.textcolor = dd.clrsize - 1;
dd.prrdens = 0;
dd.maxgroup = MAXGROUP;
dd.im = 0;

/* set text color */
rp = &dd.colors[dd.textcolor];
rp -> r = rp -> g = rp -> b = 2;

/* setup */
srand( time( &tm ));
initshow();

/* read arguments */
for (p = argv + 1, c = 1; c < argc; ++c)
	{
	if (trace) printf( "%s:\n", *p );
	ap = *p++;

	if (*ap == '-')	for (i = 1; ap[i]; ++i) switch (ap[i])
		{
		case 'd':
			if (++c >= argc)
				error( "-d: density factor missing");

			if ((cscale = atof( *p++ ) ) <= 0)
				error( "density %g is too low", cscale );

			continue;

		case 'l':
			if (++c >= argc)
				error(
			 "-l: lower limit for transformation count missing");

			if ((minsize = atoi( *p++ ) ) < 2)
				error( "low limit %d is too low", minsize );

			if (maxsize < minsize) maxsize = minsize;

			continue;

		case 'u':
			if (++c >= argc)
				error(
			 "-u: upper limit for transformation count missing");

			if ((maxsize = atoi( *p++ ) ) < 2)
				error( "upper limit %d is too low", maxsize );

			if (minsize > maxsize) minsize = maxsize;

			continue;

		case 't':
			trace++;
			continue;

		case 'n':
			shown++;
			continue;

		case 'i':
			dd.im++;
			continue;

		default:
			usage();
			error( "don't understand flag '-%c'", ap[i] );
		}
	else
		{
		usage();
		error( "don't understand argument '%s'", ap );
		}
	}

for (running = 1; running;)
	{
	setcolor( dd.textcolor );

	/* make a random ifs (area and transforms) */
	size = ifsrand( &dd, minsize, maxsize, trace );

	/* show trace printouts from ifsrand()  */
	if (trace) sleep( 5 );

	/* randrgb( &dd.colors[0] ); */
	/* black background */
	dd.colors[0].r = dd.colors[0].g = dd.colors[0].b = 0;

	/* clear & set colors */
	cleardevice();
	palsetup( &dd );

	/* show it */
	for (dd.size = minsize; dd.size <= size; ++dd.size)
		{
		if (shown)
			{
			/* show number of transforms */
			moveto( 0, 0 );
			sprintf( buf, "%d", dd.size );
			setcolor( dd.textcolor );
			gputs( buf );
			}

		count = 2000 * cscale;
		dd.density = ITER2DENS( count );
		ifsshow( &dd, kbhit, 1, putpixel, getpixel );

		/* stop ? */
		if (kbhit()) if (getch() != ' ')
			{
			running = 0;
			break;
			}
		}

	/* stop ? */
	if (kbhit()) if (getch() != ' ')
		running = 0;
	}

/* get any key (no echo) */
/*getch();*/

endshow();

exit( 0 );
}


void error( s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 )
char *s;
int v1, v2, v3, v4, v5, v6, v7, v8, v9, v10;
{
fprintf( stderr, "\nError:" );
fprintf( stderr, s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 );
fprintf( stderr, "\n" );

sleep( 5 );
/* this will clear the screen */
endshow();

exit( 2 );
}


