;****************************************************************************
;*
;* $ vfasm.asm 20/08/99 20:21 $
;* VFlat external assembly emulator functions. Revision 1.01
;*
;* Copyright (C) 1999  Dmitry Uvarov <mit@pc2o205a.pnpi.spb.ru>
;*
;* This program is free software; you can redistribute it and/or modify
;* it under the terms of the GNU General Public License as published by
;* the Free Software Foundation; either version 2 of the License, or
;* (at your option) any later version.
;*
;* This program is distributed in the hope that it will be useful,
;* but WITHOUT ANY WARRANTY; without even the implied warranty of
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;* GNU General Public License for more details.
;*
;* You should have received a copy of the GNU General Public License
;* along with this program; if not, write to the Free Software
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;*
;**************************************************************************

.386P
MODEL FLAT,C
IDEAL
JUMPS

VFLAT_START             = 0F0000000h  ;starting address of our virtual surface
VFLAT_END               = 0F03FFFFFh
PAGE_PRESENT    = 1
PAGE_NOTPRESENT = 0
PAGE_TABLE_ENTRY = 0A0000h + 110b ; entry for page table
vbeBankSwich    = 4F05h   ;vbe 1.2 function - bank swich

DATASEG

   ALIGN 4
PageDirectoryBase dd ?    ;pointer to page directory. Stored in CR3
Ring0CS           dw ?    ;selector to our ring0 page fault handler

LastPage          dd ?    ;pointer to last pages we mapped
VFlatPageTablePtr dd ?    ;pointer to our page table
OLDPageTablePtr   dd ?    ;stored pointer to modifyed page table
TableBufSel       dw ?    ;selector to allocated memory block

   ALIGN 4
OldINT14Descriptor dq ?   ;descriptor of old int14h handler

   LABEL INT14CallGate   FWORD   ;call gate to old int14h handler
OldINT14Offset    dd ?
OldINT14Selector  dw ?

; must be stored in code segment to get access to program's data from
; exception handler
ValidCS           dw ?    ;selector of out program
_Saved_DS         dw ?    ;saved data selector


CODESEG

PUBLIC InitVFlat, DoneVFlat, InitPageTable, DonePageTable
PUBLIC InstallVFHandler, RemoveVFHandler

INCLUDE "vfhnd.asm"    ; vflat handlers
PROC InitVFlat NEAR
USES ebx,edx,ecx
     mov     ax,cs             ; first check our access level
     and     ax,3
     jnz     @@err_exit1       ; we must be executed in ring0

     mov     eax,cr0
     test    eax,80000000h           ; is paging enabled?
     jz      @@err_exit2             ; we must run in paging mode

     mov     [ValidCS],cs   ;store selector of our program
     mov     [_Saved_DS],ds ;store data selector to access to data segment

     mov     eax,cr3                 ; load directory address
     and     eax,0FFFFF000h          ; directory always algned on 4K
     mov     [PageDirectoryBase],eax ; store it

     ; allocate memory for our page table
     mov     eax,0100h               ; DPMI DOS real memory allocate
     mov     ebx,8192/16             ; memory size in paragraphs
     int     31h                     ; allocate 8192 bytes (two pages)
     mov     [TableBufSel],dx        ; store selector to allocated memory
     and     eax,0FFFFh              ; get address of real memory block
     shl     eax,4                   ; eax have linear address of allocated memory
     add     eax,4095                ; align it on 4Kb
     and     eax,0FFFFF000h
     mov     [VFlatPageTablePtr],eax

     xor     eax,eax
     ret

@@err_exit1:
     mov     eax,1
     ret
@@err_exit2:
     mov     eax,2
     ret

ENDP InitVFlat

PROC DoneVFlat NEAR
USES eax,edx
     mov     dx,[TableBufSel]
     mov     ax,101h
     int     31h     ; DPMI call - free DOS memory
     ret
ENDP DoneVFlat

; Initiates paging. Install new page table.
PROC InitPageTable NEAR banksize:dword
USES eax,ebx,ecx,edx
     ; init our page table
     ; create valid page entry for 4MB of video memory
     ; 31-11 bits - page physical address. 1st bit - page present flag
     ; map all pages to video segment and mark them as non-present in memory
     mov    ecx,[banksize]
     mov    edx,64
     shl    edx,cl            ; calculate number of banks
     shr    ecx,2             ; calculate number of pages in bank
     mov    [banksize],ecx    ; store it back
     mov    eax,[VFlatPageTablePtr] ; load pointer to our page table
@@loop:
     mov    ecx,[banksize]
     mov    ebx,PAGE_TABLE_ENTRY
@@loop2:
     mov    [eax],ebx
     add    ebx,4096       ; next page physical address
     add    eax,4
     dec    ecx
     jnz    @@loop2

     dec    edx
     jnz    @@loop


     ; now store pointer to our page table in page directory
     mov     ebx,[PageDirectoryBase]   ; load address of page directory
     mov     edx,[VFlatPageTablePtr]   ; load pointer to our page table
     or      edx,111b                  ; set present / read\write / user bits

     mov     eax, VFLAT_START          ; load virtual flat start address
     shr     eax,22                    ; eax = offset in page directory
     mov     ecx,[ebx+eax*4]           ; store old page table address
     mov     [OLDPageTablePtr],ecx
     mov     [ebx+eax*4],edx           ; store pointer to our page table

     ; because we modify page table we must flush page cache
     mov     eax,cr3
     mov     cr3,eax   ; flush TLB cache

     ret
ENDP InitPageTable

PROC DonePageTable NEAR
USES eax,ebx,ecx,edx
     mov     ebx,[PageDirectoryBase]   ; load address of page directory
     mov     eax, VFLAT_START          ; load virtual flat start address
     shr     eax,22                    ; eax = offset in page table
     mov     edx,[OLDPageTablePtr]     ; load old page table address
     mov     [ebx+eax*4],edx           ; restore old page table

     ; because we modify page table we must flush page cache
     mov     eax,cr3
     mov     cr3,eax   ; flush TLB cache

     ret
ENDP DonePageTable

PROC InstallVFHandler NEAR banksize:dword
USES esi,ebx,ecx,edx,eax
     mov     eax,[VFlatPageTablePtr]
     mov     [LastPage],eax ;store pointer on last mapped pages

     sub     esp,6          ;allocate stack space for IDT pointer

     sidt    [FWORD ss:esp] ;store pointer to IDT table
     pop     ax             ;add esp,2 - remove idt limit from stack
     pop     eax            ;eax=absolute address of LDT table

     add     eax,14*8       ;point to Int 14h

     mov     ecx,[eax]      ;get cs and low 16bits of offset
     mov     edx,[eax+4]
     mov     [DWORD OldINT14Descriptor],ecx     ;store it
     mov     [DWORD OldINT14Descriptor+4],edx

     ; now prepare call gate for old int14h
     mov     edx,[eax+6]         ;get high 16 bits of offset in dx
     shl     edx,16
     mov     dx,cx               ;edx now has offset
     mov     [OldINT14Offset],edx       ;save offset
     shr     ecx,16
     mov     [OldINT14Selector],cx      ;save code selector of old handler
     ; now init new handler
     mov     [eax+2],cs     ;store new cs of handler
     mov     edx,offset VF_handler64k_Int10h   ;get offset of 64k handler
     cmp     [banksize],4
     jne     @@1
     mov     edx,offset VF_handler4K_Int10h    ;get offset of 4K handler
@@1:
     mov     [eax],dx       ;store low 16bits of offset
     shr     edx,16
     mov     [eax+6],dx     ;store high 16bits of offset

     ; here we must map our first bank on our page
     mov     eax,vbeBankSwich
     xor     ebx,ebx
     xor     edx,edx
     int     10h

     mov     ecx,[banksize] ;calculate amount of pages we must enable
     shr     ecx,2
     mov     esi,[VFlatPageTablePtr]
  @@loop:
     or      [DWORD esi],0000000001h     ; enable pages in first bank
     add     esi,4
     dec     ecx
     jnz     @@loop

     ; because we modify page table we must flush page cache
     mov     eax,cr3
     mov     cr3,eax   ; flush TLB cache
     ret
ENDP InstallVFHandler

; remove vflat handler
PROC RemoveVFHandler
USES esi,eax,edx,ecx
     sub     esp,6   ;allocate stack space for IDT pointer

     sidt    [FWORD ss:esp]
     pop     ax             ;add esp,2
     pop     eax            ;eax=address of IDT table
     add     eax,14*8       ;point to Int 14h

     mov     edx,[DWORD OldINT14Descriptor]
     mov     ecx,[DWORD OldINT14Descriptor+4]
     mov     [eax],edx      ;restore old int14h handler descriptor
     mov     [eax+4],edx

     mov     esi,[VFlatPageTablePtr]
     mov     ecx,1024
@@loop:
       and   [DWORD esi],00FFFFFFFEh   ;disable all pages
       add esi,4
       dec ecx
     jnz @@loop

     ; because we modify page table we must flush page cache
     mov     eax,cr3
     mov     cr3,eax   ; flush TLB cache
     ret
ENDP RemoveVFHandler

End