/* $ pmode.h 29/06/99 21:24 $
 * Protected mode DPMI functions. Revision 1.0
 *
 * Copyright (C) 1999  Dmitry Uvarov <mit@pc2o205a.pnpi.spb.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __PMODE_H__
#define __PMODE_H__

#include "bool.h"


/* macro to convert real mode pointer to linear offset */
#define RMToFlat(a)  (void*)(((unsigned)(a) & 0xFFFF) + ((((unsigned)(a) >> 16) & 0xFFFF) << 4))
/* macro to convert real mode segment to linear offset */
#define RMSegToFlat(a)  (void*)((unsigned)(a) << 4)

#pragma pack(1)
typedef struct {  /* real mode registers */
         dword edi;
         dword esi;
         dword ebp;
         dword esp;
         dword ebx;
         dword edx;
         dword ecx;
         dword eax;

         word   flags;
         word   es;
         word   ds;
         word   fs;
         word   gs;
         word   ip;
         word   cs;
         word   sp;
         word   ss;

         dword  reserved[20];
        } RMREGS;

typedef struct { /* free memory info structure returned by PM_GetFreeMemInfo() */
         dword  BytesAvaible;      /* largest free block in bytes        */
         dword  UnLockedPages;     /* pages avable if left unlocked      */
         dword  LockedPages;       /* pages avable if locked             */
         dword  TotalLinearPages;  /* linear address space size in pages */
         dword  TotalUnlockedPages;/* number of unlocked pages           */
         dword  TotalFreePages;    /* number of free pages               */
         dword  TotalPhysPages;    /* number of physical pages           */
         dword  FreeLinearPages;   /* free linear address space in pages */
         dword  TotalSwapPages;    /* size of page swapping file in pages*/
         dword  res[3];
        } PM_freeMemInfo;



#pragma pack();

#define PM_INT               0x31    /* DPMI services interrupt   */

word  PM_GetCS();
#pragma aux PM_GetCS = \
       " mov ax,cs "   \
       value [ax];
/*****************************/
word  PM_GetDS();
#pragma aux PM_GetDS = \
       " mov ax,ds "   \
       value [ax];

ibool PM_AllocateDOSMemory(int size, word *sel, word *seg);
ibool PM_FreeDOSMemory(int sel);
ibool PM_RealModeInt(int num, RMREGS *);
word  PM_AllocateDescriptors(int num);
ibool PM_FreeSelector(word sel);
ibool PM_SetSelectorBase(word sel, dword base);
ibool PM_SetSelectorLimit(word sel, dword limit);
ibool PM_CreateSelector(dword base, dword limit);
dword PM_MapPhysicalToLinear(dword base, dword limit);
ibool PM_FreePhysicalMapping(dword base);
ibool PM_LockLinearRegion(dword base, dword size);
ibool PM_UnLockLinearRegion(dword base, dword size);

ibool PM_CallRealModeFAR(RMREGS *);

ibool PM_GetFreeMemInfo(PM_freeMemInfo *);

#endif // __PMODE_H__