/*                        Sprite & Scrolling Engine                         */
/*        Copyright (c) Genesoft 1995-1996.  All rights reserved.           */

#include<conio.h>
#include<stdio.h>
#include<stdlib.h>
#include<malloc.h>

#include"sse.h"
#include"sseutil.h"
#include"ssecapt.h"

int main( int argc, char * argv[] )
{
   palRegister Pal[256];
   FILE * fp;
   pcxHeader ph;

   if( argc < 3 )
   {
      printf( "\nUsage: CAPT-PAL <input-pcx-name> <output-palette-name>\n\n" );
      exit( 1 );
   }

   fp = fopen( argv[1], "rb" );
   if( fp == NULL )
   {
      printf( "\nUnable to Open PCX File \"%s\"\n\n", argv[1] );
      exit( 1 );
   }
   pcxGetHeader( & ph, fp );
   if( ph.BitsPerPixel != 8 )
   {
      printf( "\nPCX File \"%s\" is not in 256 colors!\n\n", argv[1] );
      fclose( fp );
      exit( 1 );
   }
      
   pcxGetPalette( (char*)Pal, fp );

   fp = fopen( argv[2], "wb" );
   if( fp == NULL )
   {
      printf( "\n Error Opening File \"%s\"!\n\n", argv[2] );
      exit( 1 );
   }
   fwrite( Pal, 768, 1, fp );
   fclose( fp );
   return 0;
}
