/* header file for graphix.c applications.  Function prototypes & #defines */
/* copyright 1988 - 1992 Robert C. Becker, Lantern Systems */

#define		VIDEO		0x10	/* BIOS video int. */
#define		WRT_PIX		0x0c	/* BIOS write pixel request */
#define		SET_MODE	0	/* BIOS set video mode: al = video mode */
#define		VIDEO_STATE	0x0f	/* BIOS get video state */

#define		CRT		1	/* text CRT on HP systems, here just CRT */
#define		KBD		2	/* same as on HP systems */
#define		MOUSE		3	/* no previous definition */

#define		CGA_320x200	&hpc_320_200_hp		/* BIOS CGA 320x200, 4 color */
#define		CGA_640x200	&hpc_640_200_hp		/* BIOS CGA 640x200 BW */
#define		ATT_640x400	&hpa_640_400_hp		/* AT&T 640x400 BW, tiny type */
#define		ATTDEB_640x400	&hpa_640_400_hp		/* AT&T 640x400 BW, tiny type, 16 colors */
#define		HGC_720x348	&hph_720_348_hp		/* Hercules HGC and HGC+ 720x348 BW */
#define		EGA_320x200	&hpe_320_200_hp		/* IBM EGA low-res 320x200, 16 color */
#define		EGA_640x200	&hpe_640_200_hp		/* IBM EGA med-res 640x200, 16 color */
#define		MEGA_640x350	&hpem_640_350_hp	/* IBM EGA high-res 640x350, BW */
#define		EGA_640x350	&hpe_640_350_hp		/* IBM EGA high-res 640x350, 16 color */
#define		VGA_640x480	&hpv_640_480_hp		/* IBM VGA high-res 640x480, 16 color */
#define		VGA_320x200	&hpv_320_200_hp		/* IBM VGA lo-res 320x200, 256 color */
#define		MCGA_640x480	&hpm_640_480_hp		/* IBM MCGA high-res 640x480, BW */

#ifndef VID_PARAM_DEFT

#define		IBMPACKED	1	/* video bios # for CGA, MCGA, and VGA 256 color mode, ATT6300, Herc HGC & HCG+ */
#define		IBMPLANES	2	/* video bios # for EGA & VGA */
#define		VESABIOS	3	/* video bios # for VESA devices using BIOS I/O */

struct _vid_x_parm_		/* graphix init parameters */
	{
	unsigned max_xdot;	/* horizontal screens pixels - 1 */
	unsigned max_ydot;	/* vertical screen pixels - 1 */
	int max_pen;		/* # colors for this mode - 1 */
	unsigned char mode;	/* BIOS mode # for this mode */
	unsigned video_bios;	/* 0 -> using bios writes, != 0 -> not using bios for pixel writes */
	unsigned base_adr;	/* segment adr for video RAM */
	unsigned block_size;		/* # bytes in one block of video RAM */
	unsigned block_per_page;	/* # blocks needed to make one graphics screen */
	unsigned bytes_per_pixel;	/* =1 unless more than 8 bits/pixel */
	unsigned bits_per_pixel;	/* # bits used for a single pixel */
	unsigned pixels_per_byte;	/* # pixels/byte  (=1 if > 8 bits/pixel) */

	};

#define 	VID_PARAM_DEFT	/* video param structure defined */
#endif


#ifndef DSP_FN_DEFT

enum DFNON__OFF { DFN_OFF, DFN_ON };	/* definition for display fn's ON/OFF */

#define DSP_FN_DEFT
#endif


#ifndef VID_RTN_DEFT

struct video_display		/* returned structure for video_test () */
	{
	unsigned disp_a;
	struct _vid_x_parm_ *vid_mode_a;
	char *display_a;
	unsigned disp_b;
	struct _vid_x_parm_ *vid_mode_b;
	char *display_b;
	};
#define 	VID_RTN_DEFT	/* video_test return structure defined */
#endif

#ifndef Graphix_hdr_deft

extern struct _vid_x_parm_ hpc_320_200_hp;		/* BIOS CGA 320x200, 4 color */
extern struct _vid_x_parm_ hpc_640_200_hp;		/* BIOS CGA 640x200 BW */
extern struct _vid_x_parm_ hpa_640_400_hp;		/* AT&T 640x400 BW, tiny type */
extern struct _vid_x_parm_ hpad_640_400_hp;		/* AT&T 640x400 BW, tiny type, 16 colors */
extern struct _vid_x_parm_ hph_720_348_hp;		/* Hercules HGC and HGC+ 720x348 BW */
extern struct _vid_x_parm_ hpe_320_200_hp;		/* IBM EGA low-res 320x200, 16 color */
extern struct _vid_x_parm_ hpe_640_200_hp;		/* IBM EGA med-res 640x200, 16 color */
extern struct _vid_x_parm_ hpem_640_350_hp;		/* IBM EGA high-res 640x350, BW */
extern struct _vid_x_parm_ hpe_640_350_hp;		/* IBM EGA high-res 640x350, 16 color */
extern struct _vid_x_parm_ hpv_640_480_hp;		/* IBM VGA high-res 640x480, 16 color */
extern struct _vid_x_parm_ hpv_320_200_hp;		/* IBM VGA lo-res 320x200, 256 color */
extern struct _vid_x_parm_ hpm_640_480_hp;		/* IBM MCGA high-res 640x480, BW */

#define		Graphix_hdr_deft

#endif

#ifndef GR_CFG_DEFT

struct gr_config	/* defining structure for get_config (), set_config () */
	{
	int units, coupled, pen, pendown, degree, clip_type;
	int wht_color, pen_max, g_input, csize_units;
	int disp_fn, current_font;
	double hclip_xmin, hclip_xmax, hclip_ymin, hclip_ymax;
	double sclip_xmin, sclip_xmax, sclip_ymin, sclip_ymax;
	double clip_xmin, clip_xmax, clip_ymin, clip_ymax;
	double vport_xmin, vport_xmax, vport_ymin, vport_ymax;
	double uu_xfactor, uu_yfactor, uu_xoffset, uu_yoffset;
	double rpos_x, rpos_y, xpos, ypos, ldir_angle, cdir_angle;
	double pivot_cos, pivot_sin, pivot_x, pivot_y, p_cos, p_sin;
	double tilt, gdu, l_rpt, l_org, l_type, c_size;
	double x_factor, y_factor, x_offset, y_offset, xmax, ymax;
	double scr_xmin, scr_ymin;
	};

#define	GR_CFG_DEFT
#endif


#ifndef CHAR_STR_DEFT
struct char___deft
	{
	char *fontname;
	double ascender;
	double descender;
	double width;
	double base;
	double center;
	double top;
	double x_inc;
	double y_inc;
	};
#define		CHAR_STR_DEFT	/* char description struct defined */
#endif


#ifndef		SCR_PXLZ

struct scrn_pixel__
	{
	int xp, yp;
	};

#define		SCR_PXLZ	/* struct for pmap () defined */
#endif


void arc ( double, int, double, double );
void axes ( double, double, double, double, int, int, double );
void cdir ( double );
void char_xspace ( double, double );
void clip ( double, double, double, double );
void clip_off ( void );
void clip_on ( void );
void couple_pdir ( void );
void csize ( double, double, double );
void csize_gdu (void);
void csize_mm (void);
void csize_udu (void);
void deg ( void );
int  digitize ( double *, double * );
void disp_fns ( enum DFNON__OFF );
void draw ( double, double );
void frame ( void );
void gclear ( void );
void get_config ( struct gr_config * );
void g_init ( struct _vid_x_parm_ * );
int  graphics_input ( int );
void graphics_off ( void );
void grid ( double, double, double, double, int, int, double );
void idraw ( double, double );
void imove ( double, double );
void iplot ( double, double, int );
void labelf ( char *, ... );
void ldir ( double );
void limit ( double, double, double, double );
void line_type ( int, double );
void lorg ( int );
void move ( double, double );
void mscale ( double, double );
void pen ( int );
void penup ( void );
void pdir ( double );
void pivot ( double );
void plot ( double, double, int );
int pmap ( double, double, struct scrn_pixel__ _far * );
void rad ( void );
double ratio ( void );
void rdraw ( double, double );
void rectangle ( double, double, double, double );
int  read_locator ( double *, double * );
void rmove ( double, double );
void rplot ( double, double, int );
void show ( double, double, double, double );
void set_config ( struct gr_config * );
void setgu ( void );
void setuu ( void );
void track ( int );
void uncouple_pdir ( void );
void viewport ( double, double, double, double );
int  where ( double *, double * );
void window ( double, double, double, double );

struct char___deft *std_font ( void );	/* pointer to struct defining std char font */

