

pnmshear(1)                Unix Programmer's Manual                pnmshear(1)


NAME
     pnmshear - shear a portable anymap by some angle

SYNOPSIS
     pnmshear [-noantialias] angle [pnmfile]
                             -----  -------

DESCRIPTION
     Reads a portable anymap as input.  Shears it by the specified  angle  and
     produces a portable anymap as output.  If the input file is in color, the
     output will be too, otherwise it will be  grayscale.   The  angle  is  in
     degrees (floating point), and measures this:
         +-------+  +-------+
         |       |  |\       \
         |  OLD  |  | \  NEW  \
         |       |  |an\       \
         +-------+  |gle+-------+
     If the angle is negative, it shears the other way:
         +-------+  |-an+-------+
         |       |  |gl/       /
         |  OLD  |  |e/  NEW  /
         |       |  |/       /
         +-------+  +-------+
     The angle should not get too close to 90 or -90, or the resulting  anymap
     will be unreasonably wide.

     The shearing is  implemented  by  looping  over  the  source  pixels  and
     distributing  fractions  to  each of the destination pixels.  This has an
     "anti-aliasing" effect - it avoids jagged edges  and  similar  artifacts.
     However,  it  also  means  that the original colors or gray levels in the
     image are modified.  If you need  to  keep  precisely  the  same  set  of
     colors,  you  can  use  the -noantialias flag.  This does the shearing by
     moving pixels without changing their values.  If you  want  anti-aliasing
     and  don't  care  about  the  precise  colors,  but  still need a limited
     *number* of colors, you can run the result through ppmquant.
                                                        --------

     All flags can be abbreviated to their shortest unique prefix.

SEE ALSO
     pnmrotate(1), pnmflip(1), pnm(5), ppmquant(1)

AUTHOR
     Copyright (C) 1989, 1991 by Jef Poskanzer.
















                               12 January 1991                               1

