

pgmtexture(1)              Unix Programmer's Manual              pgmtexture(1)


NAME
     pgmtexture - calculate textural features on a portable graymap

SYNOPSIS
     pgmtexture [-d d] [pgmfile]
                    -   -------

DESCRIPTION
     Reads a portable graymap as input.  Calculates textural features based on
     spatial  dependence matrices at 0, 45, 90, and 135 degrees for a distance
     d (default = 1).  Textural features include:
     -

          (1) Angular Second Moment,
          (2) Contrast,
          (3) Correlation,
          (4) Variance,
          (5) Inverse Difference Moment,
          (6) Sum Average,
          (7) Sum Variance,
          (8) Sum Entropy,
          (9) Entropy,
          (10) Difference Variance,
          (11) Difference Entropy,
          (12, 13) Information Measures of Correlation, and
          (14) Maximal Correlation Coefficient.

     Algorithm taken from:
     Haralick, R.M., K. Shanmugam, and I. Dinstein.  1973.  Textural  features
     for   image  classification.  IEEE  Transactions  on  Systems,  Man,  and
                                   ----  ------------  --  -------   ---   ---
     Cybertinetics, SMC-3(6):610-621.
     -------------

BUGS
     The program can run incredibly slow for large images (larger  than  64  x
     64)  and  command  line options are limited.  The method for finding (14)
     the maximal correlation coefficient, which requires  finding  the  second
     largest eigenvalue of a matrix Q, does not always converge.

REFERENCES
     IEEE Transactions on Systems, Man, and Cybertinetics, SMC-3(6):610-621.
     ---- ------------ -- -------  ---  --- -------------

SEE ALSO
     pgm(5), pnmcut(1)

AUTHOR
     Copyright (C) 1991 by Texas Agricultural Experiment Station, employer for
     hire of James Darrell McCauley.













                                 22 Aug 1991                                 1

