

libpgm(3)                  Unix Programmer's Manual                  libpgm(3)


NAME
     libpgm - functions to support portable graymap programs

SYNOPSIS

     #include <pgm.h>
     cc ... libpgm.a libpbm.a


DESCRIPTION

     TYPES AND CONSTANTS

     typedef ... gray;
     #define PGM_MAXMAXVAL ...
     extern gray pgm_pbmmaxval;

     Each gray should contain only the values  between  0  and  PGM_MAXMAXVAL.
                                                                   -
     pgm_pbmmaxval  is  the  maxval  used when a PGM program reads a PBM file.
        -
     Normally it is 1; however, for some programs, a larger value gives better
     results.

     #define PGM_FORMAT ...
     #define RPGM_FORMAT ...
     #define PGM_TYPE PGM_FORMAT
     int PGM_FORMAT_TYPE( int format )

     For distinguishing different file formats and types.

     INITIALIZATION

     void pgm_init( int* argcP, char* argv[] )

     All PGM programs must call this routine.

     MEMORY MANAGEMENT

     gray** pgm_allocarray( int cols, int rows )

     Allocate an array of grays.

     gray* pgm_allocrow( int cols )
              -

     Allocate a row of the given number of grays.

     void pgm_freearray( gray** grays, int rows )
             -

     Free the array  allocated  with  pgm_allocarray()  containing  the  given
                                         -
     number of rows.

     void pgm_freerow( gray* grayrow )

     Free a row of grays.





                                                                             1



libpgm(3)                  Unix Programmer's Manual                  libpgm(3)


     READING FILES

     void pgm_readpgminit( FILE* fp, int* colsP, int*  rowsP,  gray*  maxvalP,
     int* formatP )

     Read the header from a PGM file, filling in the rows,  cols,  maxval  and
     format variables.

     void pgm_readpgmrow( FILE* fp, gray* grayrow, int cols, gray maxval,  int
             -
     format )

     Read a row of grays into the grayrow array.   Format,  cols,  and  maxval
     were filled in by pgm_readpgminit().
                          -

     gray** pgm_readpgm( FILE* fp, int* colsP, int* rowsP, gray* maxvalP )

     Read an entire graymap file into memory, returning  the  allocated  array
     and  filling  in  the  rows,  cols  and  maxval variables.  This function
     combines pgm_readpgminit(), pgm_allocarray() and pgm_readpgmrow().
                 -                  -                    -

     WRITING FILES

     void pgm_writepgminit( FILE* fp, int cols, int  rows,  gray  maxval,  int
     forceplain )

     Write the header for a portable graymap file.  The forceplain flag forces
     a plain-format file to be written, as opposed to a raw-format one.

     void pgm_writepgmrow( FILE* fp, gray* grayrow, int cols, gray maxval, int
             -
     forceplain )

     Write a row from a portable graymap.

     void pgm_writepgm( FILE* fp, gray**  grays,  int  cols,  int  rows,  gray
             -
     maxval, int forceplain )

     Write the header and all data for  a  portable  graymap.   This  function
     combines pgm_writepgminit() and pgm_writepgmrow().
                 -                      -

SEE ALSO
     libpbm(3), libppm(3), libpnm(3)

AUTHOR
     Copyright (C) 1989, 1991 by Tony Hansen and Jef Poskanzer.














                                                                             2

