/* ------------------------------------------------------------------------ */
/* Shp2Pog.c (C) CopyLeft Bill Buckels 1991-1999                            */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* If you don't agree, remove this source code from your computer now.      */
/*                                                                          */
/* Written by   : Bill Buckels                                              */
/*                589 Oxford Street                                         */
/*                Winnipeg, Manitoba, Canada R3M 3J2                        */
/*                                                                          */
/* Email: bbuckels@escape.ca                                                */
/* WebSite: http://www.escape.ca/~bbuckels                                  */
/*                                                                          */
/* Purpose      : Converts from "Old PrintMaster" to "New PrintShop"        */
/* Revision     : 2.0 Last Release                                          */
/* ------------------------------------------------------------------------ */
/* Written in Large Model Microsoft C Version 6.00a                         */
/* ------------------------------------------------------------------------ */

char poghead[8]={
    0x00,0x00,0x00,0x01,
    0x00,0x00,0x00,0x00};

unsigned target;

#include <fcntl.h>
#include <stdio.h>
#include <malloc.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>

unsigned char far *buffer;

unsigned csize = 572;
unsigned dsize = 577;

int SHP2POG(char *shpname, char *pogname)
{
  int fh,fh2;
  
#define S_IWRITE    0000200          /* write permission, owner   */
    
    if((fh2 = open(shpname, O_RDONLY | O_BINARY)) == - 1) {
    perror(shpname);
    return - 1;
  }
  
  
  if((fh = open(pogname, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IWRITE)) == - 1) {
    perror(pogname);
    close(fh2);
    return - 1;
  }
  
  /* write the new header */
  /* this is all that changes between the new and old style printshop */
  write(fh, poghead, 8);
  write(fh, (char *)&target, 2);
  
  buffer = _fmalloc(dsize);
  
  printf("INPUT FILE  : %s\n", shpname);
  printf("OUTPUT FILE : %s\n", pogname);
  
  while(read(fh2, buffer, dsize) == dsize)
    write(fh, (char *)&buffer[4], csize);
  
  close(fh);
  close(fh2);
  free(buffer);
  
  printf("Done !");
  return (0);
  
}


main(int argc, char **argv)
{
  int fh,fh2;
  FILE *fp;
  char *bptr;
  char c,d;
  
  char shopbuf1[66],shopbuf2[66],masterbuf1[66],masterbuf2[66];
  char tempbuf[66];
  
  puts("SHP2POG(C) v2.0 CopyLeft by Bill Buckels 1991-1999");
  puts("All Rights Reversed.");
  
  
  /* check for correct usage */
  switch(argc) {
    case 2 : break;
    
    default:
    
    puts("USAGE  is \"SHP2POG <filnam.shp>\"");
    puts("CONVERTS SHP files to POG files");
    exit(0);
    
  }
  
  /* make file names... the old printshop wanted a GR prefix */
  
  strcpy(tempbuf, argv[1]);
  bptr = strtok(tempbuf, " .\\:*");
  sprintf(masterbuf1, "%s.SHP", tempbuf);
  sprintf(masterbuf2, "%s.SDR", tempbuf);
  
  c = toupper(tempbuf[0]);
  d = toupper(tempbuf[1]);
  
  if(c == 'G' && d == 'R') {
    sprintf(shopbuf1, "%s.POG", tempbuf);
    sprintf(shopbuf2, "%s.PNM", tempbuf);
  }
  else {
    tempbuf[6] = 0;
    sprintf(shopbuf1, "GR%s.POG", tempbuf);
    sprintf(shopbuf2, "GR%s.PNM", tempbuf);
  }
  
  
  /* convert from old printmaster to new printshop */
  
  if((fp = fopen(shopbuf1, "rb")) != NULL) {
    fclose(fp);
    printf("%s already exists... cannot overwrite files\n", 
      shopbuf1);
    exit(0);
  }
  
  if((fp = fopen(masterbuf2, "rb")) == NULL) {
    perror(masterbuf2);
    exit(0);
  }
  
  /* get the total number of files in the name file */
  /* and write a new header file                    */
  target = (unsigned )(filelength(fileno(fp)) / 16);
  fclose(fp);
  
  sprintf(tempbuf, "COPY %s %s >nul", masterbuf2, shopbuf2);
  system(tempbuf);
  
  SHP2POG(masterbuf1, shopbuf1);
  
  
  
  exit(0);
  
}
