comment \

Program Name: bsvload.asm
Program Date: march 24, 1992
Author      : bill Buckels
Purpose     : command line loader for bsaved CGA text images

This program demonstrates how a command line argument is
parsed in a com file, how a file is opened and read, and how
bios calls and direct screen writes are performed.

This program also demonstrates a reasonable level of exception
processing and demonstrates how the equipment list is obtained
from the bios.

\

CODE_SEG  SEGMENT
          ASSUME CS:CODE_SEG, DS:CODE_SEG
          ORG 100H

HERCULES     EQU 0B000H
MONO         EQU 0A0BH
HEADERLENGTH EQU 7       ;length of Microsoft BSAVED descriptor

CR           EQU  0DH
LF           EQU  0AH

ENTRY:   JMP SHOWTIME ; jump past the data

  USAGE$    DB 'BSVLOAD(C) by bill buckels march 1992',CR,LF
            DB 'Usage is "BSVLOAD IMAGE.BSV"',CR,LF,CR,LF,'$'

  NOFILE$   DB 'Sorry... File ','$'
  NOTOO$    DB ' Not Found.',CR,LF,'$'
  NOGOOD$   DB ' Is Not A Valid Bsaved Image.',CR,LF,'$'

  RETCODE  DB 0           ; return code

  FRAME_BUFFER DW 0B800H
  CURROW       DW 607H

  COMMANDLINE  DW 81H

comment \ if bsvload is spawned then 81h is the beginning of the
          command tail. otherwise the command tail is at 82h.
\

  HANDLE     DW ?
  BUFFER     DB 7 DUP(?)


  ;standard header bytes
  HEADER     DB 0fdh, 000h, 0b8h , 000h, 000h, 0a0h, 00fh

SHOWTIME PROC NEAR
          PUSH    BP
          MOV     BP,SP

          CALL BOPEN
          CMP  AX,0            ;if nothing in ax don't do anything
          JE   HOMETIME
          CALL CHECKHEADER
          CMP  AX,0
          JE   HOMETIME

          CALL DISPLAYCHECK    ; check for CGA or MONO
          CALL BLOAD
          CALL BCLOSE
          CALL GETCH
HOMETIME:

         MOV     SP,BP
         POP     BP
         MOV     AH,04CH        ;terminate with return code
         MOV     AL,RETCODE
         INT     21H
SHOWTIME ENDP

DISPLAYCHECK PROC NEAR
      XOR AX,AX
      INT 11H
      AND AX,30H           ; get display type (bits 4 and 5 of ax)
      CMP AX,30H
      JB  GRFX
      MOV FRAME_BUFFER,HERCULES
      MOV CURROW,MONO
GRFX: RET
DISPLAYCHECK ENDP

LIST$ PROC NEAR
      PUSH AX
      MOV AH,9H ; call dos function 9H
      INT 21H
      POP AX
      RET
LIST$ ENDP

GETCH PROC NEAR
          MOV AH,1      ;cursor off
          MOV CX,2000H
          INT 10H

          XOR AX,AX     ;get keystroke
          INT 16H
          MOV RETCODE,AL

          MOV AH,1      ;cursor on
          MOV CX,CURROW
          INT 10H
          RET
GETCH ENDP


comment \
         open the file that was named on the command line
         parse The Command Line
         loop until we find a carriage return or whitespace
         replace the carriage return with a null
         try to open the file
         if there is a carry there was a problem
         so just complain and return nothing in AX
         if no error return with the handle in AX
\

BOPEN PROC NEAR

      XOR     DX,DX
      MOV     BX,COMMANDLINE ;command line argument address
      MOV     DL,BYTE PTR [BX]
      CMP     DL,32
      JNE     COUNTLOOP
      INC     BX
      MOV     COMMANDLINE,BX


COUNTLOOP:
      MOV     DL,BYTE PTR [BX]
      CMP     DL,13
      JE      ENDCOUNT
      CMP     DL,32
      JE      ENDCOUNT
      INC     BX
      JMP     COUNTLOOP
ENDCOUNT:
      MOV     BYTE PTR [BX],0 ;replace with a null


      MOV  DX, COMMANDLINE ;load the address into DX
      MOV  AL,0    ;al = access mode, 0 = read only
      MOV  AH,3DH
      INT  21H
      JNC  NOERROR

      LEA  DX,USAGE$
      CALL LIST$
      LEA  DX, NOFILE$ ;print error message
      CALL LIST$
      XOR  DX,DX
      MOV  BX,COMMANDLINE
COUNTTOO:
      MOV  DL,BYTE PTR [BX]
      CMP  DL,0
      JE   ENDTOO
      INC  BX
      JMP  COUNTTOO
ENDTOO:
      MOV  BYTE PTR [BX],'$' ;replace the terminator
      MOV  DX, COMMANDLINE   ;and load the address into DX
      CALL LIST$
      LEA  DX, NOTOO$
      CALL LIST$
      XOR  AX,AX
      RET

NOERROR:
      MOV HANDLE,AX       ;save the handle for subsequent operations
      RET                 ;return with the handle in AX
BOPEN ENDP

CHECKHEADER PROC NEAR

       XOR AX,AX
       MOV BX,HANDLE   ;copy handle to bx
       MOV CX,HEADERLENGTH
       LEA DX,BUFFER   ;read the header into the buffer
       MOV AH,3FH
       INT 21H

       MOV  AX,HANDLE  ;point to the first byte
       PUSH SI
       MOV  SI,0
DOAGAIN:
       MOV BH,BUFFER[SI]  ;and check the header
       MOV BL,HEADER[SI]
       CMP BH,BL
       JNE NOTVALID ;if not valid complain and return nothing
       INC SI
       CMP SI,HEADERLENGTH
       JE  ALLDONE
       JMP DOAGAIN

NOTVALID:
      CALL BCLOSE
      LEA  DX,USAGE$
      CALL LIST$
      LEA  DX, NOFILE$ ;print error message
      CALL LIST$
      XOR  DX,DX
      MOV  BX,COMMANDLINE
VALIDTOO:
      MOV  DL,BYTE PTR [BX]
      CMP  DL,0
      JE   ENDVALID
      INC  BX
      JMP  VALIDTOO
ENDVALID:
      MOV  BYTE PTR [BX],'$';replace the terminator
      MOV  DX, COMMANDLINE  ;and load the address into DX
      CALL LIST$
      LEA  DX, NOGOOD$
      CALL LIST$
      XOR  AX,AX

ALLDONE:
       POP SI
       RET
CHECKHEADER ENDP

BLOAD PROC NEAR
       XOR AX,AX
       MOV  BX,HANDLE       ;handle to bx
       MOV  CX,4000         ;number of bytes to cx
       PUSH DS
       MOV  AX,FRAME_BUFFER
       MOV  DS,AX
       XOR  AX,AX
       XOR  DX,DX
       MOV  AH,3FH          ;read function
       INT  21H
       POP  DS
       RET
BLOAD ENDP

BCLOSE PROC NEAR
       XOR  AX,AX           ;close the file
       MOV  AH,3EH
       MOV  BX,HANDLE
       INT  21H
       RET
BCLOSE ENDP

CODE_SEG ENDS
     END ENTRY
