/******************************************************************************
Fractal Infinity - FRACTAL GENERATION FUNCTIONS - fr_gen.c
This file Copyright (C) 1999 Graeme Fenwick- see documentation for details.
******************************************************************************/

#include "fr_gen.h"
#include "fr_hware.h"

#define  IT_MAX   1000                /* Maximum number of iterations tested */
#define  HUEB 50.0                  /* # of distinct bands within "spectrum" */

int iterations(long double fx, long double fy);

/********** IMAGE_GENERATE */

int image_generate(long double xc, long double yc, long double range)
{
   int           sxpos, sypos;
   long double   fx, fy;

   if (range < 0.0L)                         /* check that range is positive */
      return 0;                            
   for (sypos = 0; sypos < sydim - 16; ++sypos)
      for (sxpos = 0; sxpos < sxdim; ++sxpos) {
         fx = (sxpos - (sxdim / 2)) / (sxdim / range) + xc; /* fractal coord */
         fy = (sypos - (sydim - 16) / 2) / (sxdim / range) + yc; 
         plot_point(sxpos, sypos, IT_MAX, IT_MAX, iterations(fx, fy));
      }
   return 1;
}

/********** ITERATIONS: Calculate number of iterations for each point
                        n.b. not very optimizable */

int iterations(long double cr, long double ci)
{
   int           it;
   long double   zr = 0, zi = 0, temp;

   for (it = 0; (it < IT_MAX) && (zr * zr + zi * zi) < 4; ++it) {
      temp = zr * zr - zi * zi + cr;
      zi = 2 * zr * zi + ci;
      zr = temp;
   }
   return it;
}

/********** ITERATION_COLOR: Returns HSV values appropriate to number of
                             iterations passed (normally, maxcol == maxit) */

int iteration_color(int it, int maxit, int maxcol, 
                    float *hue, float *sat, float *val)
{
   float   place;      /* place within full color spectrum (0 - 1 inclusive) */

   if (maxit < 2 || maxcol < 2)
      return 0;                                         /* basic limit check */
   if (it >= maxit)
      *hue = *sat = *val = 0;                 /* members of set always black */
   else {
      place = ((float) it / maxcol);
      place = (place >= 1.0) ? ((float) maxcol - 1) / maxcol : place;
      *hue = (int)(place * HUEB) / HUEB * 360;                  /* basic hue */
      *val = 0.3 + 0.7 * ((place * HUEB) - (int) (place * HUEB));
      *sat = (*val <= 0.5) ? 1.0 : 1.0 - (*val - 0.5);
      *hue = (int)(*hue + ((place * HUEB) - (int) (place * HUEB)) * 90) % 360;
   }
   return 1;                              
}


