/*
        Modify Menu
*/
#include <stdio.h>                      /* standard stuff */
#include <graphics.h>                   /* graphics */
#include <dos.h>
#include <string.h>
#include "fdestria.h"
#include "fdesign.h"
#include "fdesequa.h"
#include "fdesfile.h"
#include "fdesmenu.h"
#include "fdesmous.h"
#include "fdesplot.h"


void grat_on(void)			/* put graticules on screen */
{
int x,y;
	for (x=0; x<maxx; x += (maxx/GRAT_X))
	for (y=0; y<maxy; y += (maxy/GRAT_Y))
	{
		putpixel(x,y,WHITE);
	}
}

void grat_off(void)			/* remove graticules from screen */
{
int x,y;
	for (x=0; x<maxx; x += (maxx/GRAT_X))
	for (y=0; y<maxy; y += (maxy/GRAT_Y))
	{
		putpixel(x,y,BLACK);
	}
}

popmenu modifymenu = {
	7 ,
        "Scratch Everything", "Add Triangle", "Delete Triangle", "Adjust Triangle",
        "Grat is On", "Re-Crop", "Main Menu"
	};

popmenu modi_quit = {
        2 ,
        "Stay here and continue to modify", "Return to main menu"
        };

void recrop(void)               /* re-crop triangles in modify menu screen */
{
int x1,y1,x2,y2;
float top,left,right,bottom;
float scalex,scaley;
float offsetx,offsety;
        /* &&& */
        putmsg(0,0,"Input box for triangles",BLUE,WHITE);
        box_new(&x1,&y1,&x2,&y2);
        clrmsg();
        if ((x1==x2) || (y1==y2)) return;
        triangles_limits(&left,&top,&right,&bottom);
        scalex = (x2-x1)/(right - left);
        scaley = (y2-y1)/(bottom - top);
        if (scalex > scaley) scalex = scaley;
        else scaley = scalex;
        offsetx = -((left+right)/2.0)*scalex + (x2+x1)/2.0;
        offsety = -((bottom+top)/2.0)*scaley + (y2+y1)/2.0;
        IFS_rescale(scalex,offsetx,scaley,offsety,0);
        triangles_use_temp();
}


void modify_scr(void)
{
int i;
        cleardevice();
        grat_on();
	if (triangle0_is) {
		setcolor(LIGHTRED);
		setlinestyle(DASHED_LINE,0,THICK_WIDTH);
		triangle_show(&triangle0);
	}
	if (num_triangles) {
		setlinestyle(SOLID_LINE,0,NORM_WIDTH);
		for (i = 0; i < num_triangles; i++)
		{
                        setcolor(colors[i%MAXCOLORS_]);
			triangle_show(&triangles[i]);
		}
	}
}
/************************************************************************
	Modify Menu Input
************************************************************************/
void modify_input(void)
{
float a,b,c;			/* length of triangle side */
int select,rcode,i,done,add_done;
int tr_sel,refok;
int corner;
int save_row,save_col;
mouse_state m;
	modify_scr();
        plot_type = 1;                 /* do a small plot while inputting */
        IFS_changed = 1;
        mouse_idle_job = doIFSrand;     /* do a small plot while inputting */
        done = 0;
	do {
                select = popup(0,0,&modifymenu,WHITE,BLUE);
		switch (select) {
		case 1:
                        IFS_changed = 1;
                        stpcpy(last_file,"No File");
                        file_modified = 0;
                        mouse_idle_job = mouse_idle;
			refok = 0;
			do {
				num_triangles = 0;
				triangle0_is = 0;
				modify_scr();
                                putmsg(0,0,"Input reference triangle (big)",BLUE,WHITE);
				setlinestyle(DASHED_LINE,0,THICK_WIDTH);
                                triangle_new(&triangle0,LIGHTRED);
				clrmsg();
                                a = pt_pt_distance(triangle0.row[0],triangle0.col[0],
                                                   triangle0.row[1],triangle0.col[1]);
                                b = pt_pt_distance(triangle0.row[1],triangle0.col[1],
                                                   triangle0.row[2],triangle0.col[2]);
                                c = pt_pt_distance(triangle0.row[2],triangle0.col[2],
                                                   triangle0.row[0],triangle0.col[0]);
				if ((a!=0)&(b!=0)&(c!=0)) {
					refok = 1;
					triangle0_is = 1; }
				else {
					putmsg(10,100,
					"Reference Triangle must have non-zero area",
					WHITE,BLACK);
					mouse_click(&m);
					clrmsg();
				}
			} while (!refok);
			do {
				setlinestyle(SOLID_LINE,0,NORM_WIDTH);
                                putmsg(0,0,"Input triangle or end with right button",
				       GREEN,WHITE);
                                rcode = triangle_new(&triangles[num_triangles],
                                        colors[num_triangles%MAXCOLORS_]);
				if (((rcode&0x01) != 0) &&
				   (transform_affine(&triangles[num_triangles]) == 0))
				{
					putmsg(100,100,
					"Transform not Affine (a side is too long)",
					RED,WHITE);
					mouse_click(&m);
					clrmsg();
					clrmsg();
					modify_scr();
                                        IFS_changed = 1;        /* only for clearing window */
				}
				else if ((rcode&0x01) != 0) {
					num_triangles++;
					if (num_triangles > 1) {
						IFS_changed = 1;
						mouse_idle_job = doIFSrand;
					}
					clrmsg();
				}
                                else {
                                        clrmsg();
				}
                        } while ((rcode&0x01) && (num_triangles < MAXFUNC));
			break;
		case 2:	/* add triangle */
			add_done = 0;
                        if (num_triangles < MAXFUNC)
			{
                        file_modified = 1;
			do {
                                putmsg(0,0,"Add one triangle",BLUE,WHITE);
				setlinestyle(SOLID_LINE,0,NORM_WIDTH);
                                rcode = triangle_new(&triangles[num_triangles],
                                        colors[num_triangles%MAXCOLORS_]);
				if (transform_affine(&triangles[num_triangles]) == 0)
				{
						putmsg(100,100,"Transform not Affine (a side is too long)",
						RED,WHITE);
						mouse_click(&m);
						clrmsg();
						clrmsg();
                                                IFS_changed = 1; /* to clear screen */
						modify_scr();
				}
				else {
					if ((rcode&0x01) != 0)
                                        {
                                                num_triangles++;
                                                if (num_triangles > 1) {
                                                        IFS_changed = 1;
                                                        mouse_idle_job = doIFSrand;
                                                }
                                        }
					add_done = 1;
					clrmsg();
                                        IFS_changed = 1;
				}
			} while (add_done == 0);
			}
			break;
		case 3:
                        putmsg(0,0,"Select triangle to delete",BLUE,WHITE);
			mouse_click(&m);
			clrmsg();
			tr_sel = pt_closest_triangle(m.col,m.row);
/*			gotoxy(1,13); printf("Selected %d",tr_sel);
*/			if (tr_sel == -1) {
				putmsg(50,100,"Use Scratch Everything to delete Reference Triangle ",
					WHITE,RED);
                                mouse_click(&m);
				clrmsg();
				break;
			}
			if (tr_sel < (num_triangles-1))
			{
                                file_modified = 1;
				if (tr_sel != (num_triangles-1)) {
					for (i=tr_sel; i<(num_triangles-1); i++) {
                                                triangles[i].row[0] = triangles[i+1].row[0];
                                                triangles[i].col[0] = triangles[i+1].col[0];
                                                triangles[i].row[1] = triangles[i+1].row[1];
                                                triangles[i].col[1] = triangles[i+1].col[1];
                                                triangles[i].row[2] = triangles[i+1].row[2];
                                                triangles[i].col[2] = triangles[i+1].col[2];
					}
				}
			}
			num_triangles--;
                        if (num_triangles > 1) {
				IFS_changed = 1;
				mouse_idle_job = doIFSrand;
			}
			else {
				mouse_idle_job = mouse_idle;
			}
                        IFS_changed = 1;
			modify_scr();
			break;
                case 4: /* adjust triangle */
                        putmsg(0,0,"Select triangle to adjust",BLUE,WHITE);
			mouse_click(&m);
			clrmsg();
			tr_sel = pt_closest_triangle(m.col,m.row);
                        if (tr_sel == -1) {
                                putmsg(50,100,"Cannot Adjust Reference Triangle ",WHITE,RED);
				mouse_click(&m);
				clrmsg();
				break;
			}
                        else {
                                putmsg(0,0,"Select Corner to Move",GREEN,WHITE);
                                mouse_click(&m);
				corner = triangle_corner(&triangles[tr_sel],m.col,m.row);
                                clrmsg();
                                do {
                                        putmsg(0,0,"Click left to move, Click right to end",BLUE,WHITE);
					rcode = mouse_click_grat(&m);
/*					rcode = mouse_click(&m); */
                                        save_row = triangles[tr_sel].row[corner];
                                        save_col = triangles[tr_sel].col[corner];
                                        clrmsg();
                                        if (rcode&0x01) {
                                                triangles[tr_sel].row[corner] = m.row;
                                                triangles[tr_sel].col[corner] = m.col;
                                                file_modified = 1;
						if (transform_affine(&triangles[tr_sel])) {
                                                        IFS_changed = 1;
                                                        modify_scr();
                                                }
                                                else {
                                                        triangles[tr_sel].row[corner] = save_row;
                                                        triangles[tr_sel].col[corner] = save_col;
                                                        putmsg(100,100,"Not Affine",RED,WHITE);
                                                        mouse_click(&m);
                                                        clrmsg();
                                                }
                                        }
                                } while (!(rcode&0x02));
                        }
                        break;
                case 5: /* toggle use_grat global variable */
                        if (use_grat)
                        {
                                use_grat = 0;
                                modifymenu.item[4] = "Grat is Off";
                        }
                        else
                        {
                                use_grat = 1;
                                modifymenu.item[4] = "Grat is On";
                        }
                        break;
                case 6: /* re-crop */
			recrop();
			modify_scr();
                        break;
                case 7: /* return/continue */
			if (triangle0_is == 0) {
                                putmsg(100,100,"Error: No Triangles",RED,WHITE);
                                delay(1000);
				clrmsg();
			} else if (num_triangles < 2) {
				putmsg(10,100,
                                      "Error: At least two transformation triangles required",
				      RED,WHITE);
                                delay(3000);
				clrmsg();
			}
			else {
				cleardevice();
                                plot_type = 0;
				mouse_idle_job = mouse_idle;
                                doIFSrand();
				done = 1;
			}
                        if (done == 0)
                        {
                                select = popup(150,150,&modi_quit,WHITE,RED);
                                if (select == 2)
                                {
                                        stpcpy(last_file,"No File");
                                        file_modified = 0;
                                        default_fractal();
                                        cleardevice();
                                        plot_type = 0;
                                        mouse_idle_job = mouse_idle;
                                        doIFSrand();
                                        done = 1;
                                }
                        }
			break;
		}
	} while (!done);
}

