/*
        File save and retrieve routines
*/
#include <string.h>
#include <stdio.h>
#include <graphics.h>
#include <dos.h>
#include "fdesglob.h"
#include "fdestria.h"
#include "fdesign.h"
#include "fdesequa.h"
#include "fdesmenu.h"
#include "fdesmous.h"
#include "fdesplot.h"

/* trn_file save and load */
char last_file[15];             /* last file loaded successfully */
int file_modified;              /* flag nonzero if file has been modified */

void ifs_name_fix(char *s)
{
	strtok(s,".");
        strcat(s,".IFS");
}
void gif_name_fix(char *s)
{
	strtok(s,".");
        strcat(s,".GIF");
}
/************************************************************************
        .TRN file load and save
************************************************************************/
void trn_name_fix(char *s)
{
	strtok(s,".");
	strcat(s,".TRN");
}
void trnfile_save(char *fname)
{
FILE *trnfile;
mouse_state m;
int i;
        if (strlen(fname) == 0)
        {
                putmsg(100,200,"No input filespec",RED,WHITE);
                mouse_click(&m);
                clrmsg();
                return;
        }
        trn_name_fix(fname);
	trnfile = fopen(fname,"wb");
        i = REV;
        fwrite(&i,sizeof(REV),1,trnfile);
        fwrite(&num_triangles,sizeof(num_triangles),1,trnfile);
        fwrite(&triangle0,sizeof(triangle),1,trnfile);
        for (i = 0; i < num_triangles; i++)
        {
                fwrite(&triangles[i],sizeof(triangle),1,trnfile);
        }
	fclose(trnfile);
	stpcpy(last_file,fname);
        file_modified = 0;
	putmsg(100,200,"File saved",BLUE,WHITE);
	delay(1000);
        clrmsg();
}
int trnfile_load(char *fname)
{
FILE *trnfile;
mouse_state m;
int i,j;
int file_rev;
int t_num_triangles;
int     temp;                   /* for conversion to float values */

        trn_name_fix(fname);
        trnfile = fopen(fname,"rb");
        if (trnfile == NULL)
        {
                putmsg(100,200,"File not found (click mouse)",BLUE,WHITE);
                mouse_click(&m);
                clrmsg();
        }
        else
	{
                fread(&file_rev,sizeof(REV),1,trnfile);
		fread(&t_num_triangles,sizeof(num_triangles),1,trnfile);
                if ((file_rev>500) || (t_num_triangles > MAXFUNC))
		{
			fclose(trnfile);
			putmsg(100,200,"Bad file",BLUE,WHITE);
                        delay(1000);
			clrmsg();
		}
		else {
			stpcpy(last_file,fname);
                        file_modified = 0;
			num_triangles = t_num_triangles;
                        if (file_rev < 9) {             /* old file format */
                                for (i = 0; i < 3; i++) {
                                        fread(&temp,sizeof(int),1,trnfile);
                                        triangle0.row[i] = temp;
                                        fread(&temp,sizeof(int),1,trnfile);
                                        triangle0.col[i] = temp;
                                }
                                for (j = 0; j < num_triangles; j++)
                                for (i = 0; i < 3; i++) {
                                        fread(&temp,sizeof(int),1,trnfile);
                                        triangles[j].row[i] = temp;
                                        fread(&temp,sizeof(int),1,trnfile);
                                        triangles[j].col[i] = temp;
                                }
                        }
                        else {
                                if (file_rev > 300)     /* read in floats */
                                        fread(&triangle0,sizeof(triangle),1,trnfile);
                                else                    /* read in ints */
                                {
                                        for (i=0; i<3; i++)
                                        {
                                                fread(&temp,sizeof(int),1,trnfile);
                                                triangle0.row[i] = temp;
                                        }
                                        for (i=0; i<3; i++)
                                        {
                                                fread(&temp,sizeof(int),1,trnfile);
                                                triangle0.col[i] = temp;
                                        }

                                }
                                for (j = 0; j < num_triangles; j++)
                                {
                                        /* revs 3.01 and later use float values */
                                        if (file_rev > 300)
                                                fread(&triangles[j],
                                                    sizeof(triangle),1,trnfile);
                                        else
                                        /* revs 3.00 and earlier use int values */
                                        {
                                                for (i=0; i<3; i++)
                                                {
                                                        fread(&temp,sizeof(int),1,trnfile);
                                                        triangles[j].row[i] = temp;
                                                }
                                                for (i=0; i<3; i++)
                                                {
                                                        fread(&temp,sizeof(int),1,trnfile);
                                                        triangles[j].col[i] = temp;
                                                }
                                        }
                                }
                        }
			fclose(trnfile);
                        IFS_changed = 1;
                        return(1);
		}
        }
        return(0);
}

