/*
    Copyright (C) 1996,99  Marian Krivos
	nezmar@internet.alcatel.sk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    base.h - base graphics support headers

*/

#ifndef __BASE_H
#define __BASE_H

#include <string.h>
#include <math.h>
#ifndef __linux__
#include <conio.h>
#else
#include <unistd.h>
#include <sched.h>
#ifndef LINUXFB
#include <vga.h>
#include <vgakeyboard.h>
#include <vgamouse.h>
#else
#include "linuxfb.h"
#endif
#ifdef __cplusplus
extern "C" {
#endif
void outpb(unsigned, unsigned);
void outpw(unsigned, unsigned);
unsigned char  inpb(unsigned);
unsigned short inpw(unsigned);
void LinuxInit(void);
#define outp outpb
#define inp  inpb
#ifdef __cplusplus
};
#endif
#define cprintf printf
#endif

#ifdef __DJGPP__
#include <pc.h>
#include <dpmi.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __WATCOMC__
#include <i86.h>
#define pi 3.141592653589793238

// for WATCOM & DOS
#ifdef __DOS__
#define __MSDOS__
#endif


typedef struct {
  unsigned long handle;			/* 0, 2 */
  unsigned long size; 	/* or count */	/* 4, 6 */
  unsigned long address;		/* 8, 10 */
} __dpmi_meminfo;

typedef union {
  struct {
    unsigned long edi;
    unsigned long esi;
    unsigned long ebp;
    unsigned long res;
    unsigned long ebx;
    unsigned long edx;
    unsigned long ecx;
    unsigned long eax;
  } d;
  struct {
    unsigned short di, di_hi;
    unsigned short si, si_hi;
    unsigned short bp, bp_hi;
    unsigned short res, res_hi;
    unsigned short bx, bx_hi;
    unsigned short dx, dx_hi;
    unsigned short cx, cx_hi;
    unsigned short ax, ax_hi;
    unsigned short flags;
    unsigned short es;
    unsigned short ds;
    unsigned short fs;
    unsigned short gs;
    unsigned short ip;
    unsigned short cs;
    unsigned short sp;
    unsigned short ss;
  } x;
  struct {
    unsigned char edi[4];
    unsigned char esi[4];
    unsigned char ebp[4];
    unsigned char res[4];
    unsigned char bl, bh, ebx_b2, ebx_b3;
    unsigned char dl, dh, edx_b2, edx_b3;
    unsigned char cl, ch, ecx_b2, ecx_b3;
    unsigned char al, ah, eax_b2, eax_b3;
  } h;
} __dpmi_regs;

int __dpmi_int(int _vector, __dpmi_regs *_regs);
int __dpmi_allocate_dos_memory(int _paragraphs, int *_ret_selector_or_max);

#endif

unsigned long inpl(unsigned);
void outpl(unsigned, unsigned);

#define  _GSET   0
#define  _GXOR   1
#define  _GAND   2
#define  _GOR    3
#define	 _GPLUS	 4
#define	 _GMINUS 5
#define	 _GNOT   6
#define	 _GREPLACE  7
#define	 _GTRANSP   8

enum Colors { CBLACK,CDARK,CGRAYED,CGRAY1,CGRAY2,CGRAY3,CBLUE,CBLUELIGHT,
	CGREEN,CGREENLIGHT,CRED,CREDLIGHT,CBROWN,CYELLOW,CWHITED,CWHITE};

enum Fonts { FONT0406,  FONT0808, FONT0816, FONT1222, FONT1625 };

#if (defined(__WATCOMC__) && defined(__QNX__))
unsigned int delay(unsigned int);
#else
void delay(unsigned int);
#ifdef __linux__
#define delay usleep
#endif
#endif

#ifdef __linux__
extern int	test_mmx(void) asm("_test_mmx");
extern void	set_mmx(void) asm("_set_mmx");
extern void	reset_mmx(void) asm("_reset_mmx");
void SetPalette256(void *) asm("_SetPalette256");
void GetPalette256(void *) asm("_GetPalette256");
int set_ppop(int mode) asm("_set_ppop");
void draw_box(int x, int y, int w, int h);
void fill_box(int x, int y, int w, int h);
void draw_point(int x, int y) asm("_draw_point");
int  get_point(int x, int y) asm("_get_point");
void draw_line(int x, int y, int x1, int y1)  asm("_draw_line");
void draw_hline(int x, int y, int w) asm("_draw_hline");
void drawto_line(int x, int y) asm("_drawto_line");
extern int X_width asm("_X_width"), Y_width asm("_Y_width");
void clear_frame_buffer(unsigned int c) asm("_clear_frame_buffer");
void PaletteInit(void) asm("_PaletteInit");
void _palette(unsigned , unsigned int) asm("__palette");
extern void Line(int x,int y,int w,int h) asm("_Line");
extern int X_max asm("_X_max"), Y_max asm("_Y_max"); /* maximalne rozlisenie */
extern int fonth asm("_fonth"), fontw asm("_fontw"), fontn asm("_fontn");
#else
extern int	test_mmx(void);
extern void	set_mmx(void);
extern void	reset_mmx(void);
void SetPalette256(void *);
void GetPalette256(void *);
int set_ppop(int mode);
void draw_box(int x, int y, int w, int h);
void fill_box(int x, int y, int w, int h);
void draw_point(int x, int y);
int get_point(int x, int y);
void draw_line(int x, int y, int x1, int y1);
void draw_hline(int x, int y, int w);
void drawto_line(int x, int y);
extern int X_width, Y_width;
void clear_frame_buffer(unsigned int c);
extern void Line(int x,int y,int w,int h);
extern int X_max, Y_max; /* maximalne rozlisenie */
extern int fonth, fontw, fontn;
#endif

int graph_set_mode(int mode);
void draw_spline(int points[8]);
void calc_spline(int points[8], int npts, int *x, int *y);
void set_fcolor(unsigned int  c) ;
void set_bcolor(unsigned int c) ;
void set_colors(unsigned int f, unsigned int b);
int text_out(int x, int y, char *text);
void text_to_buffer(int x, int y, char *s, int xsize, int ysize, char *buf);
int get_area_size(int x, int y);
void fill_convex(int c, int a[][2]);
void draw_convex(int c, int a[][2]);
int  get_fcolor(void);
int  get_bcolor(void);
void get_block(int x,int y,int a,int b, void *p) ;
void put_block(int x,int y,int a,int b, void *p) ;
void set_clip_rect(int w, int h, int x, int y);

void IErrorText(char *s, int flag);
extern void Pixel(int x,int y);
extern void Rect(int x,int y,int w,int h);
extern void Box(int x,int y,int w,int h);
extern void RamToVideo(int x,int y,int xm,int ym,int w,int h);
extern void VideoToRam(int x,int y,int xm,int ym,int w,int h);
extern void RamToRam(int x,int y,int xmax,int ymax,int xdst,int ydst,int xmaxdst,int ymaxdst,int w,int h,char *from,char *to);
extern void RamToRamd(int x,int y,int xmax,int ymax,int xdst,int ydst,int xmaxdst,int ymaxdst,int w,int h,char *from,char *to);
extern void Text(int x,int y,char *s);
extern void DrawCircle(int x,int y, int r);
extern void FillCircle(int x,int y, int r);
extern void draw_circle(int x,int y, int r);
extern void fill_circle(int xs, int ys, int r);
extern int set_font(int font);
int gprintf(int x, int y, const char *format,...);

#ifdef __WATCOMC__
#pragma aux Line "_*"
#pragma aux set_ppop "_*"
#pragma aux draw_hline "_*"
#pragma aux X_width "_*"
#pragma aux Y_width "_*"
#pragma aux draw_line "_*"
#pragma aux SetPalette256 "_*"
#pragma aux GetPalette256 "_*"
#pragma aux set_mmx "_*"
#pragma aux reset_mmx "_*"
#pragma aux test_mmx "_*"
#pragma aux X_max "_*"
#pragma aux Y_max "_*"
#pragma aux clear_frame_buffer "_*"
#pragma aux fill_convex "_*"
#pragma aux draw_point "_*"
#pragma aux get_point "_*"
#pragma aux fontn "_*"
#pragma aux fontw "_*"
#pragma aux fonth "_*"
#endif

char * strupr(register char *s);
int stricmp(const char *s1, const char *s2);
int strnicmp(const char *s1, const char *s2, size_t cnt);

// only for compatibility

#define draw_rect(w, h, x, y) draw_box(x,y,w,h)
#define fill_rect(w, h, x, y) fill_box(x,y,w,h)

#define	 MAX_TEXT_LENGTH	256

typedef	long fixed;

typedef	struct
{
	int	x, xlast;
	int	y, ylast;
	int	dx,	dy;
	int	xmajor;
	int	xstep;
	int	error;
}
polyedge;

typedef	enum
{
	inactive,
	active,
	passed
}
edgestat;

typedef	struct
{
	edgestat status;
	polyedge e;
}
edge;

typedef	struct _scan
{
	struct _scan *next;
	int	x1,	x2;
}
scan;

void Snd(int a, int b);
void Puk(void);

typedef void (*PixelFillFunc) (int x, int y);
typedef void (*LineFillFunc) (int x, int y, int dx, int dy);
typedef void (*ScanFillFunc) (int x, int y, int w);

typedef struct
{
	LineFillFunc line;
	ScanFillFunc scan;
	int gc_xoffset;
	int gc_yoffset;
	int gc_ycliplo;
	int gc_xcliplo;
	int gc_ycliphi;
	int gc_xcliphi;
}
PolygonStruct;

void _DrawPolygon(int n, int pt[][2], PolygonStruct * current);
void _FillPolygon(int n, int pt[][2], PolygonStruct * current);

#ifdef __cplusplus
}
#endif
#endif
